#ifndef FORMFOLDERBROWSER_H
#define FORMFOLDERBROWSER_H


#include <QWidget>

class QModelIndex;
class QSqlQueryModel;

namespace Ui {
class FormFolderBrowser;
}

class FormFolderBrowser : public QWidget
{
    Q_OBJECT
    
public:
    explicit FormFolderBrowser(QWidget *parent = 0);
    ~FormFolderBrowser();
    
    int getSelectedFolderId();

signals:
    void folderSelected(int id, QString FolderName);


private slots:
    void on_listFolders_activated(const QModelIndex &index);

    void on_buttonUp_clicked();

    void on_buttonSelectFolder_clicked();

    void on_buttonInbox_clicked();

private:
    Ui::FormFolderBrowser *ui;
    int parentLevel;
    int previousLevel;
    QString previousName;
    QSqlQueryModel* model;
    QList<int> stackIds;
    QList<QString> stackNames;

    void loadLevel();

};

#endif // FORMFOLDERBROWSER_H
