#ifndef DIALOGNOTEEDIT_H
#define DIALOGNOTEEDIT_H

#include <QDialog>


class QMaemo5ValueButton;
class QMaemo5DatePickSelector;
class QMaemo5TimePickSelector;
class QMaemo5CalendarPickSelector;
class CJournal;
class QMaemo5CalDBPickSelector;
class QAbstractButton;
class QDate;
class QTime;


namespace Ui {
class DialogNoteEdit;
}

class DialogNoteEdit : public QDialog
{
    Q_OBJECT
    
public:
    explicit DialogNoteEdit(QWidget *parent = 0);
    ~DialogNoteEdit();

    void setComponentId(int ComponentId);
    void setComponentCalendarId(int CalendarComponentId);
    void setFolderId(int FolderId);
    void loadComponent();
    bool getDeleted();
    bool saveJournal();

    int getCalendarId();

    
private slots:
    void on_buttonFolder_clicked();
    void on_buttonBox_clicked(QAbstractButton *button);

private:
    Ui::DialogNoteEdit *ui;

    QMaemo5CalDBPickSelector* calendarPickSelector;

    QPushButton* deleteButton;

    int componentId;
    int componentCalendarId;
    int folderId;

    CJournal* journal;


    bool getJournal();
    bool getFolder();
    bool deleted;
    void updateView();
    void saveToFolder(); //BAD! need to check results better
};

#endif // DIALOGNOTEEDIT_H
