#include "database.h"

#include <QFile>
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSqlError>
#include <QVariant>
#include <iostream>

using namespace std;

bool db_connect()
{
    bool ok = QFile::exists(DB_HOME);

    if (!ok) {
        return false; //fatal error. The calendardb should exist
    }

    QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE");
    db.setDatabaseName(DB_HOME);
    if (!db.open()) {
        return false;
    }

    check_tables();


    return ok;
}

void check_tables () {
//check for each table. If it doesn't exist, create it.
    QStringList tl = QSqlDatabase::database().tables();
    if (!tl.contains("Setting")) {
            cout << "Setting table does not exist!" << endl;
            create_table_setting();
    }

    if (!tl.contains("Folder")) {
            cout << "Folder table does not exist!" << endl;
            create_table_folder();
    }

    if (!tl.contains("FolderItem")) {
            cout << "FolderItem table does not exist!" << endl;
            create_table_folder_item();
    }

    if (!tl.contains("Task")) {
            cout << "Task table does not exist!" << endl;
            create_table_task();
    }

    if (!tl.contains("Note")) {
            cout << "Note table does not exist!" << endl;
            create_table_note();
    }

    if (!tl.contains("Category")) {
            cout << "Category table does not exist!" << endl;
    }
}

bool create_table_setting(){
    QSqlQuery query;
    bool ok = query.exec(DDL_SETTING);
    if(!ok) {
        cout << query.lastError().text().toLocal8Bit().constData();
    }
    return ok;
}

bool create_table_folder(){
    //TODO need to return error information
    QSqlQuery query;
    bool ok = query.exec(DDL_FOLDER);
    if(!ok) {
        cout << query.lastError().text().toLocal8Bit().constData();
    }
    int dml_errors = 0;
    foreach (QString str, DML_GROUPS) {
        cout << str.toLocal8Bit().constData() << endl;
        bool ok_dml;
        ok_dml = query.exec(str);
        if(!ok_dml) {
            dml_errors++;
            cout << query.lastError().text().toLocal8Bit().constData();
        }
    }

    return ok;
}

bool create_table_folder_item(){
    QSqlQuery query;
    bool ok = query.exec(DDL_FOLDER_ITEM);
    if(!ok) {
        cout << query.lastError().text().toLocal8Bit().constData();
    }
    return ok;
}

bool create_table_task(){
    QSqlQuery query;
    bool ok = query.exec(DDL_TASK);
    if(!ok) {
        cout << query.lastError().text().toLocal8Bit().constData();
    }
    return ok;
}

bool create_table_note(){
    QSqlQuery query;
    bool ok = query.exec(DDL_NOTE);
    if(!ok) {
        cout << query.lastError().text().toLocal8Bit().constData();
    }
    return ok;
}

//OLD stuff below! NEED to clean up
bool db_create()
{
    int err_count = 0;
    bool ok = false;
    QSqlQuery query;

    ok = query.exec( "CREATE TABLE Parent("
                            "PlusId INTEGER PRIMARY KEY AUTOINCREMENT, "
                            "Id INTEGER, "
                            "CalendarId INTEGER,"
                            "ComponentType INTEGER,"
                            "Parent INTEGER,"
                            "System INTEGER,"
                            "Sequence INTEGER,"
                            "Summary TEXT)");

    if(!ok){
        err_count++;
        cout << query.lastError().text().toLocal8Bit().constData();
    }
    ok = query.exec("CREATE INDEX IDX_Parent_Id on Parent(Id)");
    if(!ok){
        err_count++;
        cout << query.lastError().text().toLocal8Bit().constData();
    }
    ok = query.exec("CREATE INDEX IDX_Parent_Parent on Parent(Parent)");
    if(!ok){
        err_count++;
        cout << query.lastError().text().toLocal8Bit().constData();
    }
    //create Inbox system group and other recommended groups
    ok = query.exec("Insert into parent (Id,CalendarId,ComponentType,Parent,System,Sequence,Summary)"
                    " VALUES(0,0,500,0,1,-900,'Inbox')");
    ok = query.exec("Insert into parent (Id,CalendarId,ComponentType,Parent,System,Sequence,Summary)"
                    " VALUES(0,0,500,0,0,-700,'Projects')");
    ok = query.exec("Insert into parent (Id,CalendarId,ComponentType,Parent,System,Sequence,Summary)"
                    " VALUES(0,0,500,0,0,-400,'Someday')");
    if(!ok){
        err_count++;
        cout << query.lastError().text().toLocal8Bit().constData();
    }

    if(err_count > 0){
        return false;
    } else {
        return true;
    }

}

int db_getInbox()
{
    QSqlQuery query;
    query.exec("select plusid from parent where summary='Inbox'");
    if(query.next()){
        return query.value(0).toInt();
    } else
    {
        return -1;
    }
}

void db_sync()
{
    int inbox_id = db_getInbox();
    int err_count = 0;
    int ok_count = 0;
    QSqlQuery query;

    bool ok = query.exec("select id, calendarid, componenttype, summary "
               "from calendar.components a where a.componenttype = 2 and a.id not in (select id from parent)");
    if(!ok){
        cout << "select query failed!" << endl;
    }

    QSqlQuery query2;
    query2.prepare("Insert into parent (Id,CalendarId,ComponentType,Parent,System,Sequence,Summary)"
                   " VALUES(:id,:calendarid,:componenttype,:parent,:system,:sequence,:summary)");
    cout << "Looping" << endl;
    while(query.next())
    {
        cout << ":id\t" << query.value(0).toInt() << endl;
        cout << ":calendarid\t" << query.value(1).toInt() << endl;
        cout << ":componenttype\t" << query.value(2).toInt() << endl;
        cout << ":summary\t" << query.value(3).toString().toLocal8Bit().constData() << endl;
        query2.bindValue(":id", query.value(0).toInt());
        query2.bindValue(":calendarid", query.value(1).toInt());
        query2.bindValue(":componenttype", query.value(2).toInt());
        query2.bindValue(":summary", query.value(3).toString());
        query2.bindValue(":parent", inbox_id);
        query2.bindValue(":system", 0);
        query2.bindValue(":sequence", 0);
        ok = query2.exec();
        if(ok)
        {
            ok_count++;
        } else
        {
            cout << query2.lastError().text().toLocal8Bit().constData() << endl;
            err_count++;
        }

    }
    cout << "Success:" << ok_count << endl;
    cout << "Failed:" << err_count << endl;
}
