#include "dialogeditrange.h"
#include "ui_dialogeditrange.h"
#include <QtMaemo5/QMaemo5ValueButton>
#include <QtMaemo5/QMaemo5DatePickSelector>

DialogEditRange::DialogEditRange(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DialogEditRange)
{
    ui->setupUi(this);
    endDateButton = new QMaemo5ValueButton("Date");
    endDateButton->setValueLayout(QMaemo5ValueButton::ValueUnderText);


    dtpicker = new QMaemo5DatePickSelector();
    endDateButton->setPickSelector(dtpicker);
    QGridLayout *layout = qobject_cast<QGridLayout *>(ui->groupBox->layout());
    layout->addWidget(endDateButton,2,1,1,-1);
    layout->removeWidget(ui->radioEndBy);
    layout->addWidget(ui->radioEndBy,2,0);
}

DialogEditRange::~DialogEditRange()
{
    delete ui;
}

int DialogEditRange::getCount(){
    return ui->spinBox->value();
}

int DialogEditRange::getRangeType(){
    if(ui->radioNoEnd->isChecked())
        return 1;
    if(ui->radioEndAfter->isChecked())
        return 2;
    if(ui->radioEndBy->isChecked())
        return 3;

    return -1;
}

QDate DialogEditRange::getUntilDate(){
    return dtpicker->currentDate();
}

QDateTime DialogEditRange::getUntilDateTime(){
    //returns the end of the day where it should stop
    QDateTime qdtEnd(dtpicker->currentDate());
    qdtEnd.setTime(QTime(23,59,00));
    return qdtEnd;
}

QString DialogEditRange::getRange(){

    if(ui->radioNoEnd->isChecked())
        return QString("");
    if(ui->radioEndAfter->isChecked())
        return QString("COUNT=" + QString::number(ui->spinBox->value()));
    if(ui->radioEndBy->isChecked())
        return "UNTIL=" + this->getUntilDateTime().toString("yyyyMMddThhmmss"); //store local time like default app does

    return QString("");
}

int DialogEditRange::getUntilForComponent(){
    if(ui->radioEndBy->isChecked()){
        return this->getUntilDateTime().toUTC().toTime_t(); //repeat up to UNTIL
    } else {
        return -1; //repeat forever or up to COUNT
    }
}
