# -*- coding: utf-8 -*-

__author__= "Michael Wong"
__modify__= "Binkcn/l32606"
__email__="binkcn@vip.qq.com/l32606@126.com"
__version__= "0.5.6"
__build__="111101"

import platform
import sys
import string
import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtWebKit import *
import Utils
from Models import *
#from PyQt4.QtMaemo5 import *
#from flickcharm import *
from PyQt4.QtMaemo5 import QMaemo5InformationBox

from datetime import datetime


class DefaultCustomDelegate(QStyledItemDelegate):

    '''Delegate to do custom draw of the items'''

    memoized_size = {}
    memoized_width = {}

    def __init__(self, parent):
        '''Initialization'''

        QStyledItemDelegate.__init__(self, parent)

        self.show_replyto = False

        self.topMargin=10
        self.bottomMargin=10
        self.leftMargin=10
        self.rightMargin=10
        self.textMargin=5
        self.avatarWidth=50
        self.verifiedWidth=15
        self.nameHeight=20
        self.rtMargin=55

        self.firstHeight=0
        self.operationHeight=60

        self.bg_color = QColor('#000000')
        self.bg_alternate_color = QColor('#333333')
        self.user_color = QColor('#7AB4F5')
        self.time_color = QColor('#7AB4F5')
        self.replyto_color = QColor('#7AB4F5')

        self.text_color = QColor('#FFFFFF')
        self.separator_color = QColor('#000000')

        self.fm = None
        self.minifm = None

        self.normFont = None
        self.miniFont = None
        
    def cal_height_for_status(self,width,text,thumbnailFile):
        if thumbnailFile=="":
            #just calculate the text's height
            #print "===cal_height_for_status "+ str(option.rect.width() - self.leftMargin-self.rightMargin-self.avatarWidth-self.textMargin)
            height = self.fm.boundingRect(
                0,
                0,
                width - self.leftMargin-self.rightMargin-self.avatarWidth-self.textMargin,
                800,
                int(Qt.AlignTop) | int(Qt.AlignLeft)
                    | int(Qt.TextWordWrap),
                text,
                ).height() + self.topMargin+self.bottomMargin+self.textMargin+self.nameHeight
        else:
            #also calculate the picture's height
            thumbnail=QPixmap(thumbnailFile)
            thumbnailWidth=thumbnail.width()
            thumbnailHeight=thumbnail.height()
#                print thumbnailWidth,thumbnailHeight
            height = self.fm.boundingRect(
                0,
                0,
                width - self.leftMargin-self.rightMargin-self.avatarWidth-self.textMargin-thumbnailWidth-self.textMargin,
                800,
                int(Qt.AlignTop) | int(Qt.AlignLeft)
                    | int(Qt.TextWordWrap),
                text,
                ).height() + self.topMargin+self.bottomMargin+self.textMargin+self.nameHeight
            if thumbnailHeight+ self.topMargin+self.bottomMargin+self.nameHeight+self.textMargin>height:
                height=thumbnailHeight+ self.topMargin+self.bottomMargin+self.nameHeight+self.textMargin
        #at least it should higher than avatar+margins
        if height<self.topMargin+self.avatarWidth+self.bottomMargin:
            height=self.topMargin+self.avatarWidth+self.bottomMargin
        return height
        
    def cal_height_for_rt_status(self,width,rtText,rtThumbnailFile):
        if rtThumbnailFile=="":
            #just calculate the text's height
           # print "===cal_height_for_rt_status "+ str(option.rect.width() - self.leftMargin-self.rightMargin-self.avatarWidth-self.textMargin)
            rtHeight = self.fm.boundingRect(
                0,
                0,
                width - self.leftMargin-self.rightMargin-self.avatarWidth-self.textMargin-self.rtMargin,
                800,
                int(Qt.AlignTop) | int(Qt.AlignLeft)
                    | int(Qt.TextWordWrap),
                rtText,
                ).height() +self.topMargin+self.bottomMargin
        else:
            #also calculate the picture's height
            rtThumbnail=QPixmap(rtThumbnailFile)
            rtThumbnailWidth=rtThumbnail.width()
            rtThumbnailHeight=rtThumbnail.height()
#                print thumbnailWidth,thumbnailHeight
            rtHeight = self.fm.boundingRect(
                0,
                0,
                width - self.leftMargin-self.rightMargin-self.avatarWidth-self.textMargin-rtThumbnailWidth-self.textMargin-self.rtMargin,
                800,
                int(Qt.AlignTop) | int(Qt.AlignLeft)
                    | int(Qt.TextWordWrap),
                rtText,
                ).height() +self.topMargin+self.bottomMargin
            if rtThumbnailHeight+self.topMargin+self.bottomMargin>rtHeight:
                rtHeight=rtThumbnailHeight+self.topMargin+self.bottomMargin
        if rtHeight<self.avatarWidth+self.topMargin+self.bottomMargin:
            rtHeight=self.avatarWidth+self.topMargin+self.bottomMargin
        return rtHeight

    def sizeHint(self, option, index):
        '''Custom size calculation of our items'''

        #test if an operation at first
        testResult=index.data(Utils.ROLE_TEST_OPERATION).toBool()
        if testResult:
            return QSize(option.rect.width(),self.operationHeight)
        #test if a gap
        testResult=index.data(Utils.ROLE_TEST_GAP).toBool()
        if testResult:
            return QSize(option.rect.width(),self.operationHeight)


        statusId=index.data(Utils.ROLE_ID).toString()
        #uid=statusId+ 'x' +str(option.rect.width())

        if option.rect.height() > 2000 or option.rect.width() < option.rect.height():
            width = option.rect.width()
        else:        
            width = option.rect.width()
        uid=statusId+ 'x' + str(width)
        
        #print "===sizeHint: " + str(index.row())+": " + uid + " : "+index.data(Utils.ROLE_ID).toString() + "width:" + str(option.rect.width()) + "height:" + str(option.rect.height())
        #(x1, y1, x2, y2) = option.rect.getCoords()
        #print "+++sizeHint: " + "Y:"+str(y2-y1) +"X:"+str(x2-x1) + "  : " + index.data(Utils.ROLE_ID).toString()
        try:
            return self.memoized_size[uid]
        except:

            size = QStyledItemDelegate.sizeHint(self, option, index)
            if not self.fm:
                self.fm = QFontMetrics(option.font)
            #calculate the tweet's height
            text = index.data(Qt.DisplayRole).toString()
            thumbnailFile=index.data(Utils.ROLE_THUMBNAIL).toString()
            height=self.cal_height_for_status(width,text,thumbnailFile)
            
            self.firstHeight=height
#            #print "firstHeight", self.firstHeight
            rtHeight=0
            rtUser=index.data(Utils.ROLE_RT_NAME).toString()
            rtScreenUser=index.data(Utils.ROLE_RT_SCREENNAME).toString()
            if rtUser!="":
                #need to show the rt.
                #print "=============" + rtUser
                rtText=rtUser+"(@"+rtScreenUser+") : "+index.data(Utils.ROLE_RT_TEXT).toString()
                rtThumbnailFile=index.data(Utils.ROLE_RT_THUMBNAIL).toString()
                rtHeight=self.cal_height_for_rt_status(width,rtText,rtThumbnailFile)


#            print "rtHeight",rtHeight
            height+=rtHeight
#            if self.show_replyto:
#                reply_name = index.data(role=REPLYTOSCREENNAMEROLE)
#                reply_text = index.data(role=REPLYTEXTROLE)
#                if reply_name and reply_text:
#
#                    # One time is enought sizeHint need to be fast
#
#                    reply = 'In reply to @' + reply_name + ' : ' \
#                        + reply_text
#                    if not self.minifm:
#                        if not self.miniFont:
#                            self.miniFont = QFont(option.font)
#                            self.miniFont.setPointSizeF(option.font.pointSizeF()
#                                    * 0.80)
#                        self.minifm = QFontMetrics(self.miniFont)
#                    height += self.minifm.boundingRect(
#                        0,
#                        0,
#                        option.rect.width() - 75,
#                        800,
#                        int(Qt.AlignTop) | int(Qt.AlignLeft)
#                            | int(Qt.TextWordWrap),
#                        reply,
#                        ).height()
#                elif reply_name:
#                    reply = 'In reply to @' + reply_name
#                    if not self.minifm:
#                        if not self.miniFont:
#                            self.miniFont = QFont(option.font)
#                            self.miniFont.setPointSizeF(option.font.pointSizeF()
#                                    * 0.80)
#                        self.minifm = QFontMetrics(self.miniFont)
#                    height += self.minifm.boundingRect(
#                        0,
#                        0,
#                        option.rect.width() - 75,
#                        800,
#                        int(Qt.AlignTop) | int(Qt.AlignLeft)
#                            | int(Qt.TextWordWrap),
#                        reply,
#                        ).height()

            if height < 70:
                height = 70

            self.memoized_size[uid] = QSize(size.width(), height)
            #print "====setHint height: " + str(height)  + "  : " +  index.data(Utils.ROLE_ID).toString()
            return self.memoized_size[uid]

    def paint(
        self,
        painter,
        option,
        index,
        ):
        '''Paint our tweet'''

#        if not USE_PYSIDE:
        (x1, y1, x2, y2) = option.rect.getCoords()
        width = option.rect.width()
        #print "====paint height: " + str(option.rect.height())  + "  : " + index.data(Utils.ROLE_ID).toString()
#        else:
#            #Work arround Pyside bug #544
#            y1 = option.rect.y()
#            y2 = y1 + option.rect.height()
#            x1 = option.rect.x()
#            x2 = x1 + option.rect.width()

        # Ugly hack ?
        if y1 < 0 and y2 < 0:
            return

        if not self.fm:
            self.fm = QFontMetrics(option.font)

        if not self.normFont:
            self.normFont = QFont(option.font)
            self.miniFont = QFont(option.font)
            self.miniFont.setPointSizeF(option.font.pointSizeF() * 0.80)

        painter.save()

        # Draw alternate ?

        if index.row() % 2 == 0:
            painter.fillRect(option.rect, self.bg_color)
        else:
            painter.fillRect(option.rect, self.bg_alternate_color)

        # highlight selected items

        if option.state & QStyle.State_Selected:
            painter.fillRect(option.rect, option.palette.highlight())

        #draw the operation
        testResult=index.data(Utils.ROLE_TEST_OPERATION).toBool()
        if testResult:
            opeName=index.data(Utils.ROLE_OPERATION).toString()
            painter.setPen(self.text_color)
            new_rect = \
                painter.drawText(
#                        option.rect.adjusted(int(self.show_avatar)* 70, 5, -4, 0),
                        option.rect,
                        int(Qt.AlignCenter) | int(Qt.TextWordWrap),
                        opeName)
            # Draw line

            painter.setPen(self.separator_color)
            painter.drawLine(x1, y2, x2, y2)

            painter.restore()
            return

        #draw the gap
        testResult=index.data(Utils.ROLE_TEST_GAP).toBool()
        if testResult:
            opeName=index.data(Qt.DisplayRole).toString()
            painter.setPen(self.text_color)
            new_rect = \
                painter.drawText(
#                        option.rect.adjusted(int(self.show_avatar)* 70, 5, -4, 0),
                        option.rect,
                        int(Qt.AlignCenter) | int(Qt.TextWordWrap),
                        opeName)
            # Draw line

            painter.setPen(self.separator_color)
            painter.drawLine(x1, y2, x2, y2)

            painter.restore()
            return

#        model = index.model()
        text = index.data(Qt.DisplayRole).toString()
        name=index.data(Utils.ROLE_NAME).toString()
        screenname=index.data(Utils.ROLE_SCREENNAME).toString()
        userImage=index.data(Utils.ROLE_AVATAR).toString()
        time=index.data(Utils.ROLE_TIME).toString()
        isverified=index.data(Utils.ROLE_ISVERIFIED).toString()

        # Draw avatar
        avatar=QPixmap(userImage)
        painter.drawPixmap(x1 + self.leftMargin, y1 + self.topMargin, self.avatarWidth, self.avatarWidth, avatar)

        # Draw verified
        verifiedLeft = 0
        
        if str(isverified)=="1":
            verifiedLeft = 20
            verified = Utils.VERIFIED_FILE
            verified=QPixmap(verified)
            verifiedx = x1 + 55
            verifiedy = y1 + 5
            painter.drawPixmap(verifiedx + self.leftMargin, verifiedy + self.topMargin, self.verifiedWidth, self.verifiedWidth, verified)

        # Draw name
        name = name #name+"(@"+screenname+")"
        painter.setFont(self.miniFont)
        painter.setPen(self.user_color)
        painter.drawText(option.rect.adjusted(verifiedLeft + self.leftMargin+self.avatarWidth+self.textMargin, self.topMargin, -self.rightMargin, -self.bottomMargin),
                         int(Qt.AlignTop) | int(Qt.AlignLeft),
                         name)
        
        # Draw Timeline
#        painter.setFont(self.miniFont)
        if index.data(Utils.ROLE_CM_NUM) != 0 and index.data(Utils.ROLE_RT_NUM) != 0:
            time_text = time+"(C:"+index.data(Utils.ROLE_CM_NUM).toString()+" F:"+index.data(Utils.ROLE_RT_NUM).toString()+")"
        elif index.data(Utils.ROLE_CM_NUM) != 0:    
            time_text = time+"(C:"+index.data(Utils.ROLE_CM_NUM).toString()+")"
        elif index.data(Utils.ROLE_RT_NUM) != 0:    
            time_text = time+"(F:"+index.data(Utils.ROLE_RT_NUM).toString()+")"
        else:
            time_text = time
        painter.setPen(self.time_color)
        painter.drawText(option.rect.adjusted(self.leftMargin+self.avatarWidth+self.textMargin, self.topMargin, -self.rightMargin, -self.bottomMargin),
                         int(Qt.AlignTop) | int(Qt.AlignRight),
                         time_text)# + ":"+index.data(Utils.ROLE_ID).toString())

        # Draw tweet
        painter.setPen(self.text_color)
        painter.setFont(self.normFont)
        thumbnailFile=index.data(Utils.ROLE_THUMBNAIL).toString()

        if thumbnailFile=="":
            #just draw the text
            new_rect = \
                painter.drawText(
                        option.rect.adjusted(self.leftMargin+self.avatarWidth+self.textMargin, self.topMargin+self.nameHeight+self.textMargin, -self.rightMargin, -self.bottomMargin),
                        int(Qt.AlignTop) | int(Qt.AlignLeft) | int(Qt.TextWordWrap),
                        text)
        else:
            thumbnail=QPixmap(thumbnailFile)
            thumbnailWidth=thumbnail.width()
            thumbnailHeight=thumbnail.height()
            painter.drawPixmap(x2- thumbnailWidth-self.rightMargin, y1 + self.topMargin+self.nameHeight+self.textMargin, thumbnailWidth, thumbnailHeight, thumbnail)
            new_rect = \
                painter.drawText(
                        option.rect.adjusted(self.leftMargin+self.avatarWidth+self.textMargin, self.topMargin+self.nameHeight+self.textMargin, -self.rightMargin- thumbnailWidth-self.textMargin, -self.bottomMargin),
                        int(Qt.AlignTop) | int(Qt.AlignLeft) | int(Qt.TextWordWrap),
                        text)

        self.firstHeight=self.cal_height_for_status(width,text,thumbnailFile)
#        print new_rect.height()
#        print self.firstHeight
        rtUser=index.data(Utils.ROLE_RT_NAME).toString()
        rtScreenUser=index.data(Utils.ROLE_RT_SCREENNAME).toString()
        if rtUser!="":
            #need to draw the rt.
            rtText=rtUser+" : "+index.data(Utils.ROLE_RT_TEXT).toString()
            rtAvatar=QPixmap(index.data(Utils.ROLE_RT_AVATAR).toString())

            #draw a line
            pen=painter.pen()
            pen.setColor(self.separator_color)
            pen.setStyle(Qt.DashDotLine)
            painter.setPen(pen)
            painter.drawLine(x1, y1+self.firstHeight, x2, y1+self.firstHeight)
            pen.setColor(self.text_color)
            pen.setStyle(Qt.SolidLine)
            painter.setPen(pen)

            # Draw avatar
            painter.drawPixmap(x1 + self.leftMargin+self.rtMargin, y1 + self.firstHeight+self.bottomMargin, self.avatarWidth, self.avatarWidth, rtAvatar)

            rtThumbnailFile=index.data(Utils.ROLE_RT_THUMBNAIL).toString()

            if rtThumbnailFile=="":
                #just draw the text
                new_rect = \
                    painter.drawText(
                            option.rect.adjusted(self.leftMargin+self.rtMargin+self.avatarWidth+self.textMargin, self.firstHeight+self.bottomMargin, -self.rightMargin, -self.bottomMargin),
                            int(Qt.AlignTop) | int(Qt.AlignLeft) | int(Qt.TextWordWrap),
                            rtText)
            else:
                #also calculate the picture's height
                rtThumbnail=QPixmap(rtThumbnailFile)
                rtThumbnailWidth=rtThumbnail.width()
                rtThumbnailHeight=rtThumbnail.height()
#                print thumbnailWidth,thumbnailHeight
                painter.drawPixmap(x2- rtThumbnailWidth-self.rightMargin, y1 + self.firstHeight+self.bottomMargin, rtThumbnailWidth, rtThumbnailHeight, rtThumbnail)
                new_rect = \
                    painter.drawText(
                            option.rect.adjusted(self.leftMargin+self.rtMargin+self.avatarWidth+self.textMargin, self.firstHeight+self.bottomMargin, -self.rightMargin- rtThumbnailWidth-self.textMargin, -self.bottomMargin),
                            int(Qt.AlignTop) | int(Qt.AlignLeft) | int(Qt.TextWordWrap),
                            rtText)


        # Draw line
        painter.setPen(self.separator_color)
        painter.drawLine(x1, y2, x2, y2)

        painter.restore()
        

class StatusCellDelegate(DefaultCustomDelegate):

    '''Delegate to do custom draw of the items'''

    def __init__(self, parent):
        '''Initialization'''

        DefaultCustomDelegate.__init__(self, parent)

        self.user_color = QColor('#3399cc')
        self.replyto_color = QColor('#3399cc')
        self.time_color = QColor('#94a1a7')
        self.bg_color = QColor('#edf1f2')
        self.bg_alternate_color = QColor('#e6eaeb')
        self.text_color = QColor('#444444')
        self.separator_color = QColor('#c8cdcf')

class MenuCellDelegate(QStyledItemDelegate):

    '''Delegate to do custom draw of the items'''

    def __init__(self, parent):
        '''Initialization'''

        QStyledItemDelegate.__init__(self, parent)

#        self.user_color = QColor('#3399cc')
#        self.replyto_color = QColor('#3399cc')
#        self.time_color = QColor('#94a1a7')
        self.bg_color = QColor('#edf1f2')
        self.bg_alternate_color = QColor('#e6eaeb')
        self.text_color = QColor('#444444')
        self.separator_color = QColor('#c8cdcf')

        self.menuHeight=70

        self.topMargin=10
        self.bottomMargin=10
        self.leftMargin=10
        self.rightMargin=10
        self.avatarWidth=64
        self.avatarHeight=42

        self.fm = None
        self.minifm = None

        self.normFont = None
        self.miniFont = None

    def sizeHint(self, option, index):
        '''Custom size calculation of our items'''

        return QSize(80,self.menuHeight)


    def paint(
        self,
        painter,
        option,
        index,
        ):

        (x1, y1, x2, y2) = option.rect.getCoords()
        if y1 < 0 and y2 < 0:
            return
        '''
        print "paint-----------------"
        print index.row()
        print x1,y1,x2,y2
        print index
        print index.row()
        if (option.state & QStyle.State_MouseOver):
            print "State_MouseOver"
        else:
            print "not State_MouseOver"
            
        if (option.state & QStyle.State_Selected):
            print "State_Selected"
        else:
            print "not State_Selected"
        if (option.state & QStyle.State_HasFocus):
            print "State_HasFocus"
        else:
            print "not State_HasFocus"
        if (option.state & QStyle.State_Active):
            print "State_Active"
        else:
            print "not State_Active"
        '''

            
        
        if not self.fm:
            self.fm = QFontMetrics(option.font)

        if not self.normFont:
            self.normFont = QFont(option.font)
            self.normFont.setPointSizeF(option.font.pointSizeF() * 0.80)
            self.miniFont = QFont(option.font)
            self.miniFont.setPointSizeF(option.font.pointSizeF() * 0.60)

        painter.save()

        # Draw alternate ?

        if index.row() % 2 == 0:
            painter.fillRect(option.rect, QColor('#222222'))#self.bg_color)
        else:
            painter.fillRect(option.rect, QColor('#222222'))#self.bg_alternate_color)

        txt_color = self.bg_color
        
        # highlight selected items

        if (option.state & QStyle.State_Selected):
            painter.fillRect(option.rect, self.bg_color) #option.palette.highlight())
            txt_color = self.text_color

        #draw icon
        icon=index.data(Utils.ROLE_AVATAR).toString()
        avatar=QPixmap(icon)
        painter.drawPixmap(x1 + self.leftMargin, y1 + self.topMargin, self.avatarWidth, self.avatarHeight, avatar)


        menu=index.data(Qt.DisplayRole).toString()
        painter.setFont(self.miniFont)
        painter.setPen(txt_color)
        new_rect = \
            painter.drawText(
#                        option.rect.adjusted(int(self.show_avatar)* 70, 5, -4, 0),
                    option.rect,
                    int(Qt.AlignCenter) | int(Qt.AlignBottom)| int(Qt.TextWordWrap),
                    menu)

        unreads = index.data(Utils.ROLE_UNREAD).toString()
        #print "unreads: " + unreads
        if ( unreads != "0"):
            unread_pic=QPixmap(Utils.ICONS_DIR+"fan_new.png")
            painter.drawPixmap(x2 - unread_pic.width(), y1, unread_pic.width(), unread_pic.height(), unread_pic)

            painter.setPen(self.bg_color)
            if (int(unreads) >=10):
                unreads = "N"
            painter.drawText(x2 - 14, y1 + 14, unreads)
                    
        # Draw line

        #painter.setPen(self.separator_color)
        #painter.drawLine(x1, y2, x2, y2)

        painter.restore()
        return


class AccountCellDelegate(QStyledItemDelegate):

    '''Delegate to do custom draw of the items'''

    def __init__(self, parent):
        '''Initialization'''

        QStyledItemDelegate.__init__(self, parent)

        self.user_color = QColor('#3399cc')
        self.replyto_color = QColor('#3399cc')
        self.time_color = QColor('#94a1a7')
        self.bg_color = QColor('#edf1f2')
        self.bg_alternate_color = QColor('#e6eaeb')
        self.text_color = QColor('#444444')
        self.separator_color = QColor('#c8cdcf')

        self.menuHeight=70

        self.topMargin=5
        self.bottomMargin=5
        self.leftMargin=10
        self.rightMargin=10
        self.avatarWidth=48
        self.avatarHeight=48

        self.fm = None
        self.minifm = None

        self.normFont = None
        self.miniFont = None

    def sizeHint(self, option, index):
        '''Custom size calculation of our items'''

        return QSize(option.rect.width(),self.menuHeight)


    def paint(
        self,
        painter,
        option,
        index,
        ):

        (x1, y1, x2, y2) = option.rect.getCoords()
        if y1 < 0 and y2 < 0:
            return

        if not self.fm:
            self.fm = QFontMetrics(option.font)

        if not self.normFont:
            self.normFont = QFont(option.font)
            self.normFont.setPointSizeF(option.font.pointSizeF() * 1.2)
            self.miniFont = QFont(option.font)
            self.miniFont.setPointSizeF(option.font.pointSizeF() * 0.80)

        painter.save()

        # Draw alternate ?

        if index.row() % 2 == 0:
            painter.fillRect(option.rect, self.bg_color)
        else:
            painter.fillRect(option.rect, self.bg_alternate_color)

        # highlight selected items

        if option.state & QStyle.State_Selected:
            painter.fillRect(option.rect, option.palette.highlight())

        #draw icon
        icon=index.data(Utils.ROLE_AVATAR).toString()
        avatar=QPixmap(icon)
        painter.drawPixmap(x1 + self.leftMargin, y1 + self.topMargin, self.avatarWidth, self.avatarHeight, avatar)

        menu=index.data(Qt.DisplayRole).toString()
        painter.setPen(self.text_color)
        new_rect = \
            painter.drawText(
#                        option.rect.adjusted(int(self.show_avatar)* 70, 5, -4, 0),
                    option.rect,
                    int(Qt.AlignCenter) | int(Qt.TextWordWrap),
                    menu)
        # Draw line

        painter.setPen(self.separator_color)
        painter.drawLine(x1, y2, x2, y2)

        painter.restore()
        return

class AccountsWindow(QMainWindow):
    def __init__(self, parent=None, accounts=None, websites=None , orientation=0, mode="False"):
        super(AccountsWindow, self).__init__(parent)
        self.setWindowTitle("Maebo")
        self.orientation=orientation
        self.setAttribute(Qt.WA_Maemo5StackedWindow)

        self.accounts=accounts
        self.websites=websites
        self.running_mode = mode

        self.accountsListView=QListView()
        self.accountsListView.setWordWrap(True)
        self.accountsListView.setEditTriggers(QAbstractItemView.SelectedClicked)
        self.accountsListView.setSpacing(0)
        self.accountsListView.setUniformItemSizes(False)
        self.accountsListView.setResizeMode(QListView.Adjust)
        self.accountsListView.setHorizontalScrollBarPolicy(Qt.ScrollBarAlwaysOff)
        self.accountsListView.setVerticalScrollBarPolicy(Qt.ScrollBarAsNeeded)

        self.accountsListView.setItemDelegate(AccountCellDelegate(self))
        self.accountsModel=AccountsModel(self.accounts,self.websites)
        self.accountsListView.setModel(self.accountsModel)

        self.setCentralWidget(self.accountsListView)
        self.centralWidget().setStyleSheet("background-color: "+Utils.COLOR_BACKGROUND);
        self.setFixedSize(800,480)
        
    def set_running_mode(self, mode):
        self.running_mode = mode

    def closeEvent(self, event):
        print "close"
        if self.running_mode == "True":
            self.hide()
            event.ignore()
        #event.accept()

class MenusWindow(QMainWindow):
    def __init__(self, parent=None, menus=None , orientation=0, title="Maemo-Menus"):
        super(MenusWindow, self).__init__(parent)
        self.setWindowTitle(title)
        self.orientation=orientation
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.menus=menus
        self.menuListView=QListView()
        self.menuListView.setWordWrap(True)
        self.menuListView.setEditTriggers(QAbstractItemView.SelectedClicked)
        self.menuListView.setSpacing(0)
        self.menuListView.setUniformItemSizes(False)
        self.menuListView.setResizeMode(QListView.Adjust)
        self.menuListView.setHorizontalScrollBarPolicy(Qt.ScrollBarAlwaysOff)
        self.menuListView.setVerticalScrollBarPolicy(Qt.ScrollBarAsNeeded)

        self.menuListView.setItemDelegate(MenuCellDelegate(self))
        self.menuModel=MenusModel(self.menus)
        self.menuListView.setModel(self.menuModel)
        
        self.setCentralWidget(self.menuListView)
        #self.centralWidget().setStyleSheet("background-color: "+Utils.COLOR_BACKGROUND);
        self.setFixedWidth(80)

class TimelineWindow(QMainWindow):
    def __init__(self, parent=None, statuses=None , orientation=0):
        super(TimelineWindow, self).__init__(parent)
        self.orientation=255
        self.currentMenuIdx = None
        
        self.setWindowTitle("Maebo")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.statusesListView=QListView()
        self.statusesListView.setWordWrap(True)
        self.statusesListView.setEditTriggers(QAbstractItemView.SelectedClicked)
        self.statusesListView.setSpacing(0)
        self.statusesListView.setUniformItemSizes(False)
        self.statusesListView.setResizeMode(QListView.Adjust)
        self.statusesListView.setHorizontalScrollBarPolicy(Qt.ScrollBarAlwaysOff)
        self.statusesListView.setVerticalScrollBarPolicy(Qt.ScrollBarAlwaysOn)
        if statuses!=None:
            self.statusesModel=StatusModel(statuses)
            self.statusesListView.setModel(self.statusesModel)
        self.statusesListView.setItemDelegate(StatusCellDelegate(self))
        #self.statusesListView.setStyleSheet("background-color: "+Utils.COLOR_BACKGROUND);
        #self.setFixedSize(800,480)

        self.menus=Utils.build_menus()
        self.menuListView=QListView()
        self.menuListView.setWordWrap(True)
        self.menuListView.setEditTriggers(QAbstractItemView.SelectedClicked)
        self.menuListView.setSpacing(0)
        self.menuListView.setUniformItemSizes(False)
        self.menuListView.setResizeMode(QListView.Adjust)
        self.menuListView.setHorizontalScrollBarPolicy(Qt.ScrollBarAlwaysOff)
        self.menuListView.setVerticalScrollBarPolicy(Qt.ScrollBarAlwaysOff)

        #self.menuListView.setStyleSheet("background-color: "+'#444444');
        
        self.menuListView.setItemDelegate(MenuCellDelegate(self))
        self.menuModel=MenusModel(self.menus)
        self.menuListView.setModel(self.menuModel)

        self.mainHFrame=QFrame()
        self.mainHLayout=QHBoxLayout(self.mainHFrame)
        self.mainHLayout.setSpacing(0)
        self.mainHLayout.setContentsMargins(0,0,0,0)   
        
        self.mainVFrame=QFrame()
        self.mainVLayout=QVBoxLayout(self.mainVFrame)
        self.mainVLayout.setSpacing(0)
        self.mainVLayout.setContentsMargins(0,0,0,0)   

        self.mainFrame=QFrame()
        self.mainLayout=QHBoxLayout(self.mainFrame)
        self.mainLayout.addWidget(self.mainVFrame)
        self.mainLayout.addWidget(self.mainHFrame)
        self.mainLayout.setSpacing(0)
        self.mainLayout.setContentsMargins(0,0,0,0) 

        self.setCentralWidget(self.mainFrame)
        
        #self.setCentralWidget(self.mainHFrame)
        #self.centralWidget().setStyleSheet("background-color: "+Utils.COLOR_BACKGROUND);
        
    def closeEvent(self, event):
        self.emit(SIGNAL("timelinwin_close()"))
        
    def current_index(self):
        return self.statusesListView.currentIndex()

    def set_current_index(self,index):
        self.statusesListView.setCurrentIndex(index)

    def load_statuses(self,statuses):
        self.statusesModel=StatusModel(statuses)
#        self.statusesListView.setItemDelegate(StatusCellDelegate(statuses,self.orientation))
        self.statusesListView.setItemDelegate(StatusCellDelegate(self))
        self.statusesListView.setModel(self.statusesModel)
        
    def switch(self,orientation):
        #print "sw" + str(orientation) + str(self.orientation)

        if orientation==self.orientation:
            return
        self.orientation=orientation

        if orientation==1:        
            self.mainHLayout.removeWidget(self.menuListView)
            self.mainHLayout.removeWidget(self.statusesListView)
            self.mainVLayout.addWidget(self.statusesListView)
            self.mainVLayout.addWidget(self.menuListView)
            self.menuListView.setFixedSize(480,70)
            self.menuListView.setFlow(QListView.LeftToRight)
            self.mainVFrame.show()
            self.mainHFrame.hide()            
            #print "switch portrait"
        else:
            self.mainVLayout.removeWidget(self.menuListView)
            self.mainVLayout.removeWidget(self.statusesListView)
            self.mainHLayout.addWidget(self.menuListView)
            self.mainHLayout.addWidget(self.statusesListView)
            self.menuListView.setFixedSize(80,420)
            self.menuListView.setFlow(QListView.TopToBottom)
            self.mainHFrame.show()
            self.mainVFrame.hide()
            #print "switch landspace"

class UserButton(QPushButton):
    def __init__(self, parent=None,status=None, orientation=0):
        super(UserButton, self).__init__(parent)
        self.status=status
        self.orientation=orientation
        self.leftMargin=10
        self.topMargin=10
        self.bottomMargin=10
        self.rightMargin=10
        self.textMargin=10
        self.avatarWidth=50
        self.verifiedWidth=15

        self.fm = None
        self.minifm = None

        self.normFont = None
        self.miniFont = None

    def sizeHint(self):
        return QSize(800,70)
    
    def paintEvent(self, event):
        super(UserButton, self).paintEvent(event)
        

        painter = QPainter(self)
#        painter.save()
        (x1, y1, x2, y2) = event.rect().getCoords()
#        print x1,y1,x2,y2
        if y1 < 0 and y2 < 0:
            return

        if self.status==None:
            userImage=Utils.DEFAULT_AVATAR_FILE
            text=""
        else:
            self.miniFont = QFont(painter.font())
            self.miniFont.setPointSizeF(painter.font().pointSizeF() * 0.80)
            user=self.status["user"]
            userImage=Utils.AVATAR_DIR+str(self.status["account"])+"_"+str(user["id"])
            if platform.os.access(userImage, platform.os.W_OK) == 0:
                userImage=Utils.DEFAULT_AVATAR_FILE
            text=user["name"]+"(@"+user["screen_name"]+")"+ "   "+"来自："+user["location"]
#            if user["verified"]==1:
#                text=text+" [认证用户]"
            text=text+"\n"
            text=text+" 听众:"+str(user["followers_count"])+" 收听:"+str(user["friends_count"])+" 广播:"+str(user["statuses_count"])+""

        # Draw verified
        verifiedLeft = 0
        if user["verified"]==1:
            verifiedLeft = 20
            verified = Utils.VERIFIED_FILE
            verified=QPixmap(verified)
            verifiedx = x1 + 55
            verifiedy = y1 + 0
            painter.drawPixmap(verifiedx + self.leftMargin, verifiedy + self.topMargin, self.verifiedWidth, self.verifiedWidth, verified)


        avatar=QPixmap(userImage)
        painter.drawPixmap(x1 + self.leftMargin, y1 + self.topMargin, self.avatarWidth, self.avatarWidth, avatar)
        painter.save()
        painter.setFont(self.miniFont)
        painter.drawText(event.rect().adjusted(verifiedLeft + self.leftMargin+self.avatarWidth+self.textMargin, 5, 0, 0),
                         int(Qt.AlignTop) | int(Qt.AlignLeft),
                         text)

        painter.restore()


class StatusWindow(QMainWindow):
    def __init__(self, parent=None, orientation=0):
        super(StatusWindow, self).__init__(parent)
        self.orientation=orientation
        self.setWindowTitle("Maebo")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
#        self.userView=QWebView()
#        self.userView.setFixedSize(770,100)

        self.userBtn=UserButton()
#        self.userBtn.setFixedSize(770,80)

        self.statusContentView = StatusContentView(self,self.orientation)
        self.statusContentView.setSizePolicy(QSizePolicy(QSizePolicy.Preferred,QSizePolicy.Maximum))
        #self.statusContentView.setFixedHeight(200)
        self.status=None
        self.reply_status=None
        self.down_orgpic = "True"
        self.statuses=[]
        self.comment_statuses=[]
        
        self.buttonFrame=QFrame()
        self.rtBtn = QPushButton(unicode("转发"))
        self.cmtBtn = QPushButton(unicode("评论"))
        self.favBtn = QPushButton(unicode("收藏"))
        self.dmBtn = QPushButton(unicode("私信"))
        self.cmBtn = QPushButton(unicode("﻿显示评论"))
        self.ReplyBtn = QPushButton(unicode("﻿回复"))
        self.rtBtn.setFixedSize(110,50)
        self.cmtBtn.setFixedSize(110,50)
        self.favBtn.setFixedSize(110,50)
        self.dmBtn.setFixedSize(110,50)
        self.cmBtn.setFixedSize(110,50)
        self.ReplyBtn.setFixedSize(110,50)
        self.btnLayout=QHBoxLayout(self.buttonFrame)
        #self.btnLayout.insertStretch(0,100)
        self.btnLayout.addWidget(self.rtBtn)
        self.btnLayout.addWidget(self.cmtBtn)
        self.btnLayout.addWidget(self.favBtn)
        #self.btnLayout.addWidget(self.dmBtn)
        self.btnLayout.addWidget(self.ReplyBtn)
        self.btnLayout.addWidget(self.cmBtn)
        self.btnLayout.setContentsMargins(0,0,0,0)   
        
        #self.connect(self.cmBtn, SIGNAL("clicked()"), self.show_comments)
        #self.connect(self.ReplyBtn, SIGNAL("clicked()"), self.clicked_ReplyBtn)


        self.commentsOpe=Utils.build_an_operation(Utils.STATUS_OPE_TYPE_COMMENT,
                                          "Comments", None)
        #self.commentsOpe                                  
        self.currentOpe=None

        #self.statuses.insert(0,self.commentsOpe)
        self.statusesListView=QListView()
        self.statusesListView.setWordWrap(True)
        self.statusesListView.setEditTriggers(QAbstractItemView.SelectedClicked)
        self.statusesListView.setSpacing(0)
        #self.statusesListView.setUniformItemSizes(False)
        self.statusesListView.setResizeMode(QListView.Adjust)
        self.statusesListView.setHorizontalScrollBarPolicy(Qt.ScrollBarAlwaysOff)
        self.statusesListView.setVerticalScrollBarPolicy(Qt.ScrollBarAsNeeded)
        self.statusesListView.setItemDelegate(StatusCellDelegate(self))
        #self.statusesListView.setSizePolicy(QSizePolicy(QSizePolicy.Preferred,QSizePolicy.Minimum))
        
        self.mainFrame=QFrame()
        self.mainLayout=QVBoxLayout(self.mainFrame)
        self.mainLayout.addWidget(self.userBtn, Qt.AlignTop)
        self.mainLayout.addWidget(self.statusContentView)
        self.mainLayout.addWidget(self.statusesListView)
        self.mainLayout.addWidget(self.buttonFrame)
        self.mainLayout.setSpacing(0)
        #self.mainLayout.insertStretch(3,100)
        self.mainLayout.setContentsMargins(0,0,0,0)        
        self.setCentralWidget(self.mainFrame)
        #self.statusesListView.setStyleSheet("background-color: "+Utils.COLOR_BACKGROUND);
        self.mainLayout.setAlignment(Qt.AlignHCenter|Qt.AlignTop)
        #self.setFixedSize(800,480)
        self.hide_comments();

    def switch(self,orientation):
        if orientation==self.orientation:
            return
        self.orientation=orientation
        #if self.orientation==0:
            #self.statusContentView.setFixedSize(800,425)
#            self.chapterContentView.setFixedWidth(800)
        #elif self.orientation==1:
            #self.statusContentView.setFixedSize(480,745)
#            self.chapterContentView.setFixedWidth(480)

    def change_favBtn_text(self,fav):
        if fav==0:
            self.favBtn.setText(unicode("收藏"))
        else:
            self.favBtn.setText(unicode("取消收藏"))

    def load_status(self, down_orgpic):
        #print "load_status"
        self.userBtn.status=self.status
        self.down_orgpic = down_orgpic
        self.statuses=[]
        self.statusesListView.hide()
        #self.statuses.insert(0, self.status)
        #self.statuses.insert(1, self.commentsOpe)
        self.statuses.extend(self.comment_statuses)
        if len(self.statuses)>1:## and self.bCommentFlag == 1:
            #print "load_status: " + str(len(self.statuses))
            #print "load_status"
            self.statusesModel=StatusModel(self.statuses)
            self.statusesListView.setItemDelegate(StatusCellDelegate(self))
            self.statusesListView.setModel(self.statusesModel)
            self.show_comments()
        else:
            self.hide_comments()
            
            

        self.userBtn.repaint()
        self.change_favBtn_text(self.status["favorited"])
        self.statusContentView.update_content(self.status, down_orgpic)

    def show_comments(self):
        #print "show_comments"
        self.statusesListView.show()
        self.statusContentView.hide()
        self.rtBtn.hide()
        self.cmtBtn.hide()
        self.favBtn.hide()
        self.ReplyBtn.show()
        self.ReplyBtn.repaint()
        self.buttonFrame.hide()
        self.buttonFrame.show()

        self.cmBtn.setText(unicode("隐藏评论"))
        self.bCommentFlag=1

    def hide_comments(self):
        #print "hide_comments"
        self.statusContentView.show()
        self.statusesListView.hide()
        self.cmBtn.setText(unicode("﻿显示评论"))
        self.cmBtn.repaint()
        self.bCommentFlag=0
        self.statuses=[]
        self.rtBtn.show()
        self.cmtBtn.show()
        self.favBtn.show()
        self.ReplyBtn.hide()
    

class NewStatusWindow(QMainWindow):
    def __init__(self, parent=None, orientation=0):
        super(NewStatusWindow, self).__init__(parent)
        self.setWindowTitle("Maebo")
        self.orientation=255
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.textEdit=QTextEdit()
        #self.textEdit.setFixedHeight(150)
        #self.textEdit.setFixedWidth(760)
        self.connect(self.textEdit, SIGNAL("textChanged()"),
                     self.change_number)

        self.picPreBtn=QToolButton()
        self.picPreBtn.setFixedSize(250,250)


#        self.statusContentView = StatusContentView(self,self.orientation)
        self.avatarLabel=QLabel()
        self.avatarLabel.setFixedWidth(70)
        self.avatarLabel.setAlignment(Qt.AlignTop)
        self.avatarLabel.setMargin(10)

        self.statusLabel=QLabel()
        #self.statusLabel.setFixedSize(680,180)
        self.statusLabel.setWordWrap(True)
        self.statusLabel.setAlignment(Qt.AlignTop)        
        #self.statusLabel.setAlignment(Qt.AlignLeft|Qt.AlignTop)
#        self.statusLabel.setIndent(20)


        #self.avatarLabel1=QLabel()
        #self.avatarLabel1.setFixedSize(70,180)
        #self.avatarLabel1.setAlignment(Qt.AlignTop)
        #self.avatarLabel1.setMargin(10)

        self.statusLabel1=QLabel()
        self.statusLabel1.setWordWrap(True)
        self.statusLabel1.setAlignment(Qt.AlignTop)

        self.statusFrame1=QFrame()
        self.statusLayout1=QHBoxLayout(self.statusFrame1)
        #self.statusLayout1.addWidget(self.avatarLabel1)
        self.statusLayout1.addWidget(self.statusLabel1)
        self.statusLayout1.setAlignment(Qt.AlignTop)
        #

        self.buttonFrame=QFrame()
        self.numLabel=QLabel("140")
        self.picBtn = QPushButton(unicode("插入图片"))
        self.rmPicBtn = QPushButton(unicode("删除图片"))
        self.sharpBtn = QPushButton(unicode("#﻿话题#"))
        self.clearBtn = QPushButton(unicode("清除"))
        self.sendBtn = QPushButton(unicode("发送"))
        self.picBtn.setFixedSize(140,50)
        self.rmPicBtn.setFixedSize(140,50)
        self.sharpBtn.setFixedSize(120,50)
        self.clearBtn.setFixedSize(120,50)
        self.sendBtn.setFixedSize(120,50)
        self.btnLayout=QHBoxLayout(self.buttonFrame)
        self.btnLayout.insertStretch(0,100)
        self.btnLayout.addWidget(self.numLabel)
        self.btnLayout.addWidget(self.picBtn)
        self.btnLayout.addWidget(self.rmPicBtn)
        self.btnLayout.addWidget(self.sharpBtn)
        self.btnLayout.addWidget(self.clearBtn)
        self.btnLayout.addWidget(self.sendBtn)

        self.picFrame=QFrame()
        self.picLayout=QVBoxLayout(self.picFrame)
        self.picLayout.addWidget(self.textEdit)
#        self.picLayout.addStretch(80)
        self.picLayout.addWidget(self.picPreBtn)
        self.picLayout.setAlignment(Qt.AlignCenter)
        self.picLayout.setContentsMargins(0,0,5,0)
        #self.picLayout.setSpacing(20)

        self.statusFrame=QFrame()
        self.statusLayout=QHBoxLayout(self.statusFrame)
        self.statusLayout.addWidget(self.avatarLabel)
#        self.picLayout.addStretch(80)
        self.statusLayout.addWidget(self.statusLabel)
        self.statusLayout.setAlignment(Qt.AlignTop)#|Qt.AlignLeft)
#        self.picLayout.setContentsMargins(10,10,10,0)
#        self.picLayout.setSpacing(20)
        
        self.cbCommentCurrent = QCheckBox(unicode("﻿评论当前微博"), self)
        self.cbCommentOriginal = QCheckBox(unicode("评论原始微博"), self)
        #self.cbCommentCurrent.hide()
        self.cbCommentCurrent.setFixedHeight(50)
        self.cbCommentOriginal.setFixedHeight(50)
        self.cbCommentCurrent.setStyleSheet("QCheckBox::indicator { width: 50px; height: 50px; };")
        self.cbCommentOriginal.setStyleSheet("QCheckBox::indicator { width: 50px; height:50px; };")
        self.cbFrame=QFrame()
        self.cbLayout=QHBoxLayout(self.cbFrame)
        self.cbLayout.insertStretch(0,100)
        self.cbLayout.addWidget(self.cbCommentCurrent)
        self.cbLayout.addWidget(self.cbCommentOriginal)

        self.bReplyFlag=0
        self.iOriginalID=0
        self.cbReplyCurrent = QCheckBox(unicode("﻿转发到我的微博"), self)
        self.cbReplyOriginal = QCheckBox(unicode("评论原始微博"), self)
        #self.cbReplyCurrent.hide()
        self.cbReplyCurrent.setFixedHeight(50)
        self.cbReplyOriginal.setFixedHeight(50)
        self.cbReplyCurrent.setStyleSheet("QCheckBox::indicator { width: 50px; height: 50px; };")
        self.cbReplyOriginal.setStyleSheet("QCheckBox::indicator { width: 50px; height:50px; };")
        self.cbReplyFrame=QFrame()
        self.cbReplyLayout=QHBoxLayout(self.cbReplyFrame)
        self.cbReplyLayout.insertStretch(0,100)
        self.cbReplyLayout.addWidget(self.cbReplyCurrent)
        self.cbReplyLayout.addWidget(self.cbReplyOriginal)
        
        self.mainFrame=QFrame()
        self.mainLayout=QVBoxLayout(self.mainFrame)
#        self.mainLayout.addWidget(self.textEdit)
        self.mainLayout.addWidget(self.picFrame)
        #self.mainLayout.addStretch(180)
        self.mainLayout.addWidget(self.statusFrame)
        self.mainLayout.addWidget(self.statusFrame1)
        #self.mainLayout.insertStretch(3,50)
        self.mainLayout.addWidget(self.cbFrame)
        self.mainLayout.addWidget(self.cbReplyFrame)
        self.mainLayout.addWidget(self.buttonFrame)
        #self.mainLayout.setAlignment(Qt.AlignHCenter|Qt.AlignTop)
        self.mainLayout.setContentsMargins(5,0,5,0)

        self.setCentralWidget(self.mainFrame)
        #self.setFixedSize(800,480)
        self.rmPicBtn.hide()
        self.picPreBtn.hide()
        self.connect(self.sharpBtn, SIGNAL("clicked()"), self.insert_topic)
        self.connect(self.clearBtn, SIGNAL("clicked()"), self.clear_content)
        self.connect(self.picBtn, SIGNAL("clicked()"), self.attach_pic)
        self.connect(self.rmPicBtn, SIGNAL("clicked()"), self.remove_pic)
        self.connect(self.cbCommentCurrent, SIGNAL("clicked()"), self.check_cbCurrent)
        self.connect(self.cbCommentOriginal, SIGNAL("clicked()"), self.check_cbOriginal)
        #self.connect(self.cbReplyCurrent, SIGNAL("clicked()"), self.check_cbReplyCurrent)
        #self.connect(self.cbReplyOriginal, SIGNAL("clicked()"), self.check_cbReplyOriginal)
        self.picture=None
        self.switch(orientation)

    def change_number(self):
        content=self.textEdit.toPlainText()
#        print content
        num=content.count()
#        print num
        if num>140:
            self.textEdit.setPlainText(content.left(140))
            num=140
        self.numLabel.setText(str(140-num))

    def attach_pic(self):
        path = QFileDialog.getOpenFileName(self,
                    unicode("请选择文件"),"/home/user/MyDocs/DCIM",
                    "Picture Files (*.jpeg *.JPEG *.jpg *.JPG *.png *.PNG *.gif *.GIF)")
        if path:
            self.picture=path
            icon=QIcon(path)
            self.picPreBtn.setIcon(icon)
            self.picPreBtn.setIconSize(QSize(250,250))
            self.picPreBtn.show()
            #self.textEdit.setFixedWidth(600)
            self.picLayout.setAlignment(Qt.AlignHCenter)
            self.picBtn.hide()
            self.rmPicBtn.show()

    def remove_pic(self):
        self.picture=None
        #self.textEdit.setFixedWidth(760)
        self.picPreBtn.hide()
        self.picLayout.setAlignment(Qt.AlignHCenter)
        self.rmPicBtn.hide()
        self.picBtn.show()


    def load_status(self,status=None,timelineType=None,isReply=0):
        self.picture=None
        self.timelineType=timelineType
        self.status=status
        if status==None:
#            self.textEdit.setFixedSize(770,150)
            #self.textEdit.setFixedWidth(760)
            self.textEdit.setText("")
            self.picBtn.show()
            self.statusFrame.hide()
            self.statusFrame1.hide()
            self.cbFrame.hide()
            self.cbReplyFrame.hide()
            self.sendBtn.setText(unicode("发送"))
            self.bReplyFlag = 0

        else:
            self.picBtn.hide()
            if timelineType==Utils.TIMELINE_TYPE_MENTIONS:
                #retweet
                #self.textEdit.setFixedSize(760,150)
#                self.statusContentView.setFixedSize(760,180)
#                self.statusContentView.show()
                self.statusFrame.show()
                self.statusFrame1.hide()
                self.cbReplyFrame.hide()
                rt=status["retweeted_status"]
                self.sendBtn.setText(unicode("转发"))
                self.bReplyFlag = 0
                if rt!=None:
                    #retweet the retweeted one.
#                    html=self.gene_html(rt)
#                    self.statusContentView.setHtml(html)
                    rtUser=rt["user"]
                    rtUserImage=Utils.AVATAR_DIR+str(rt["account"])+"_"+str(rtUser["id"])
                    if platform.os.access(rtUserImage, platform.os.W_OK) == 0:
                        userImage=Utils.DEFAULT_AVATAR_FILE
                    self.avatarLabel.setPixmap(QPixmap(rtUserImage))
                    self.statusLabel.setText(rtUser["name"]+"(@"+rtUser["screen_name"]+"): "+rt["text"])

                    text="//@"+status["user"]["name"]+":"+status["text"]
                    self.textEdit.setText(text)
                    self.cbCommentOriginal.show()
                    self.cbFrame.show()
                else:
                    #retweet the original one.
#                    html=self.gene_html(status)
#                    self.statusContentView.setHtml(html)
                    user=status["user"]
                    userImage=Utils.AVATAR_DIR+str(status["account"])+"_"+str(user["id"])
                    if platform.os.access(userImage, platform.os.W_OK) == 0:
                        userImage=Utils.DEFAULT_AVATAR_FILE
                    self.avatarLabel.setPixmap(QPixmap(userImage))

                    self.statusLabel.setText(user["name"]+"(@"+user["screen_name"]+"): "+status["text"])

                    self.textEdit.setText("")
                    self.cbCommentOriginal.hide()
            elif timelineType==Utils.TIMELINE_TYPE_COMMENTS:
                #comment
                #self.textEdit.setFixedSize(760,150)
#                self.statusContentView.setFixedSize(760,180)
#                self.statusContentView.show()
#                html=self.gene_html(status)
#                self.statusContentView.setHtml(html)
                self.textEdit.setText("")
                user=status["user"]
                userImage=Utils.AVATAR_DIR+str(status["account"])+"_"+str(user["id"])
                if platform.os.access(userImage, platform.os.W_OK) == 0:
                    userImage=Utils.DEFAULT_AVATAR_FILE
                self.avatarLabel.setPixmap(QPixmap(userImage))

                self.statusLabel.setText(user["name"]+"(@"+user["screen_name"]+"): "+status["text"])
                self.statusLabel.show()

                reply_status = None
                txt_prefix = ""
                self.statusLabel1.hide() 
                if status["status"] != None:
                    reply_status =status["status"]
                    txt_prefix = "的微博: "
                if status["reply_comment"] != None and status["reply_comment"]["text"] != None:
                    reply_status =status["reply_comment"]
                    txt_prefix = "的评论: "
                    #print "reply_status id "+str(reply_status["text"])
                if reply_status != None:    
                    reply_user=reply_status["user"]
                    #reply_userImage=Utils.AVATAR_DIR+str(reply_status["account"])+"_"+str(reply_user["id"])
                    #if platform.os.access(reply_userImage, platform.os.W_OK) == 0:
                    #    reply_userImage=Utils.DEFAULT_AVATAR_FILE
                    #self.avatarLabel1.setPixmap(QPixmap(reply_userImage))
                    self.statusLabel1.setText("﻿回复" + reply_user["name"]+txt_prefix+reply_status["text"])
                    self.statusLabel1.show()    
                
                self.cbFrame.hide()
                self.cbReplyFrame.show()
                if isReply==0:
                    self.sendBtn.setText(unicode("评论"))
                    self.bReplyFlag = 0
                else:
                    self.sendBtn.setText(unicode("﻿回复"))
                    self.bReplyFlag = 1
                    self.cbReplyOriginal.hide()
            elif timelineType==Utils.TIMELINE_TYPE_DM:
                #dm
                self.textEdit.setFixedSize(760,150)
                self.statusFrame.hide()
                text="对 @"+status["user"]["name"]+" 说:"
                self.textEdit.setText(text)
        self.move_to_end()

    def insert_topic(self):
        cursor=self.textEdit.textCursor()
        cursor.insertText("##")
        self.move_to_end()

    def clear_content(self):
        self.textEdit.setText("")
        self.move_to_end()
        
    def check_cbCurrent(self):
        if self.cbCommentCurrent.isChecked():
            self.cbCommentOriginal.setChecked(0)

    def check_cbOriginal(self):
        if self.cbCommentOriginal.isChecked():
            self.cbCommentCurrent.setChecked(0)
    def check_cbReplyCurrent(self):
        if self.cbReplyCurrent.isChecked():
            self.cbReplyOriginal.setChecked(0)

    def check_cbReplyOriginal(self):
        if self.cbReplyOriginal.isChecked():
            self.cbReplyCurrent.setChecked(0)
            
            
    def move_to_end(self):
        cursor=self.textEdit.textCursor()
        cursor.movePosition(QTextCursor.EndOfBlock,QTextCursor.MoveAnchor)
        self.textEdit.setTextCursor(cursor)

    def output_param(self):
        param={}
        param["timelineType"]=self.timelineType
        if self.timelineType==None:
            param["status"]=self.textEdit.toPlainText()
            if self.picture!=None:
                param["pic"]=self.picture
        elif self.timelineType==Utils.TIMELINE_TYPE_MENTIONS:
            param["status"]=self.textEdit.toPlainText()
            
            #rt
            rt=self.status["retweeted_status"]
            if rt!=None:
                id=rt["id"]
            else:
                id=self.status["id"]
            param["id"]=id

            param["is_comment"]=0
            if self.cbCommentCurrent.isChecked():
                param["is_comment"]=1
                id=self.status["id"]
            if self.cbCommentOriginal.isChecked():
            	param["is_comment"]=2
            	id=rt["id"]
            param["id"]=id
            
        elif self.timelineType==Utils.TIMELINE_TYPE_COMMENTS:
            param["comment"]=self.textEdit.toPlainText()
            id=self.status["id"]
            param["id"]=id
            if self.cbReplyCurrent.isChecked():
                param["without_mention"]=2 
            if self.cbReplyOriginal.isChecked():
            	param["comment_ori"]=1
            if self.bReplyFlag == 1:
                param["id"]=self.iOriginalID
                param["cid"]=id
        elif self.timelineType==Utils.TIMELINE_TYPE_DM:
            param["text"]=self.textEdit.toPlainText()
            id=self.status["user"]["id"]
            param["id"]=id
        return param

#    def gene_html(self,status):
#        html="""
#        <html>
#        <body bgcolor="#edf1f2" style='word-break:break-all'>
#        <table width="100%" border="0" bgcolor="#edf1f2">
#            <tr style="font-size:22px">
#                <td width="60px">
#                    $userImage
#                </td>
#                <td>
#                    $name:$text
#                </td>
#            </tr>
#        </table>
#        </body>
#        </html>
#        """
#        user=status["user"]
#        name=user["name"]
#
#        userImage=Utils.AVATAR_DIR+str(status["account"])+"_"+str(user["id"])+".jpg"
#        if platform.os.access(userImage, platform.os.W_OK) == 0:
#            userImage=Utils.AVATAR_DIR+"default.jpg"
#
#
#        userImage='<img src=file://"'+userImage+'"/>'
#        text=status["text"]
#        html=string.replace(html, "$text", text)
#        html=string.replace(html, "$userImage", userImage)
#        html=string.replace(html, "$name", name)
#        return html

    def enable_send(self,ifEnable):
        self.sendBtn.setEnabled(ifEnable)

    def switch(self,orientation):
        if orientation==self.orientation:
            return
        self.orientation=orientation
        if self.orientation==1:
            self.statusLabel.setFixedHeight(300)
        else:
            self.statusLabel.setFixedHeight(120)

#        elif self.orientation==1:
#            if self.rmPicBtn.isVisible()==False:
#                print "isVisible"
#                #self.textEdit.setFixedSize(440, 400)
#            else:
#                print "!isVisible"
                #self.textEdit.setFixedSize(280, 400)
        



class StatusContentView(QWebView):
    def __init__(self, parent=None,orientation=0):
        super(StatusContentView, self).__init__(parent)
        self.orientation=orientation
        #set the size for the rendering problem when change the content
        #if self.orientation==0:
        #    self.setFixedSize(760,300)
#            self.setFixedWidth(800)
        #elif self.orientation==1:
        #    self.setFixedSize(480,745)
#            self.setFixedWidth(480)
#        print self.sizeHint()
#        self.settings().setAttribute(QWebSettings.PluginsEnabled,True)
#        self.grabGesture(Qt.SwipeGesture)
#        self.setRenderHint(QPainter.HighQualityAntialiasing)
        scroller=self.property("kineticScroller").toPyObject()
        scroller.setEnabled(True)
        
        self.page().setLinkDelegationPolicy(QWebPage.DelegateAllLinks)
#        self.connect(self,
#                     SIGNAL("loadFinished(bool)"),
#                     self.loadfinished)
        
        self.connect(self,
                     SIGNAL("linkClicked(const QUrl&)"),
                     self.urlClicked)
                     
#    def loadfinished(self, strOK):
#        print "debug!A!"
#        print strOK
        
    def urlClicked(self, strUrl):
        tmpURL = str(strUrl.toString())
        
        try:
            import os
            os.system('dbus-send --system --type=method_call --dest=com.nokia.osso_browser /com/nokia/osso_browser/request com.nokia.osso_browser.load_url string:"' + tmpURL + '"')
        except:
            print "Debug:"
            print tmpURL
            print "Maemo5 Broswer have a Bug."
        
    #disable the right-click menu
    def contextMenuEvent (self, event):
        pass

#    def event(self,event):
##        print "event"
#        if (event.type() == QEvent.Gesture):
#            print "aa"
#            gesture=event.gesture(Qt.SwipeGesture)
#            if (gesture.state() == Qt.GestureFinished):
#                if gesture.horizontalDirection() == QSwipeGesture.Left:
#                    print "left"
#                elif gesture.horizontalDirection() == QSwipeGesture.Right:
#                    print "right"
#            return True
#        else:
#            return super(ChaptersContentView, self).event(event)

    def update_content(self, status, down_orgpic):
        html="""
        <html>
        <HEAD>
            <META http-equiv=Content-Type content="text/html; charset=gbk">
            <title>404</title>
        </HEAD>
        <body bgcolor="#edf1f2" style='word-break:break-all;-khtml-user-select: none;font-size:16px'><font face="Nokia Sans">
        <table width="100%" border="0">
            <tr>
                <td width="100%" align="left" style='font-size:24px'>
                    $text
                </td>
            </tr>
            <tr>
                <td width="100%" align="center">
                    <span id="tip"></span>
                    <img id="objpic" src="$spic" onclick="javascript:doLoadImage();"onload="javascript: {
    var originImage=new Image();
    originImage.src = this.src;
    this.width   =   document.body.clientWidth-20; 
    this.height   =   (this.width   /   originImage.width)   *   originImage.height; 
}">
                    <span style="display:none;" id="picurl">$pic</span>
                    <script type="text/javascript">
                        function doLoadImage(){
                            document.getElementById('objpic').src = document.getElementById('picurl').innerHTML;
                            <!--document.getElementById('tip').innerHTML = 'Downloading...'; -->
                        }
 function   sleep(n) 
 { 
     var   start=new   Date().getTime(); 
     while(true)   if(new   Date().getTime()-start> n)   break; 
 }
                        window.onresize   =function   ()   {  { 
    var originImage=new Image();
    originImage.src = document.getElementById('objpic').src;
    document.getElementById('objpic').width   =   document.body.clientWidth-20; 
    document.getElementById('objpic').height   =   (document.getElementById('objpic').width   /   originImage.width)   *   originImage.height; 
    originImage.src = document.getElementById('rtobjpic').src;
    document.getElementById('rtobjpic').width   =   document.body.clientWidth-20; 
    document.getElementById('rtobjpic').height   =   (document.getElementById('rtobjpic').width  /   originImage.width)   *   originImage.height; 
 }}

                        <!--doLoadImage();-->
                        <!--doInit();-->
                        $down_pic
                        function doInit(){
                            if (document.getElementById('objpic').src.length > 5){
                                document.getElementById('tip').innerHTML = 'Double-click this image to download large image.';
                            }
                        }
                    </script>
                </td>
            </tr>
            $rt
            <tr>
                <table>
                    <tr>
                        <td align="left" style='font-size:16px'>
                            $createdAt $source
                        </td>
                        <td align="right">
                            
                        </td>
                    </tr>
                </table>
            </tr>
        </table>
        </body>
        </html>
        """
        rtHtml="""
            <tr>
                <td width="100%">
                    <table>
                        <tr>
                            <td valign="top">
                                <table>
                                    <tr>
                                        <td width="60px" valign="top" cellpadding="10">
                                        $rtAvatar
                                        </td>
                                    </tr>
                                </table>
                            </td>
                            <td style='font-size:22px' align="left" valign="top">
                                $rtText
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td width="100%" align="center">
                    <span id="rttip"></span>
                    <img id="rtobjpic" src="$rtspic" onclick="javascript:doLoadRtImage();"onload="javascript: {
    var originImage=new Image();
    originImage.src = this.src;
    this.width   =   document.body.clientWidth-20; 
    this.height   =   (this.width   /   originImage.width)   *   originImage.height; 
}">
                    <span style="display:none;" id="rtpicurl">$rtpic</span>
                    <script type="text/javascript">
                        function doLoadRtImage(){
                            document.getElementById('rtobjpic').src = document.getElementById('rtpicurl').innerHTML;
                            <!--document.getElementById('rttip').innerHTML = 'Downloading...';-->
                        }
                        <!--doLoadRtImage(); -->
                        <!--doInitRt();-->
                        $down_rtpic
                        function doInitRt(){
                            if (document.getElementById('rtobjpic').src.length > 5){
                                document.getElementById('rttip').innerHTML = 'Double-click this image to download large image.';
                            }
                        }
                    </script>
                </td>
            </tr>
        """
        #print "=====================down_orgpic:", down_orgpic
        text=status["text"]
        source=status["source"]
        if source ==None:
            source=""
        createdAt=status["created_at"]
#        createdAtString=Utils.gene_datetime_string(createdAt)
        createdAtString=str(createdAt)
        spic=status["thumbnail_pic"]
        pic=status["original_pic"]
        if pic==None:
            pic=""
        
        if spic!=None:
            filename=spic.split("/")[-1]
            if len(filename)==0 or filename=="460":
                filename=spic.split("/")[-2]
        
            spic=Utils.THUMBNAIL_DIR+str(status["account"])+"_"+str(status["id"])+"_"+filename
            if os.access(spic, platform.os.W_OK) == 0:
                #spic=""
                spic = status["thumbnail_pic"]
                print spic
            else:
                spic = "file:///" + spic
        else:
            spic=""
        
        rt=None
        rtUser=""
        rtName=""
        rtText=""
        rtpic=""
        rtspic=""
        rtAvatar=""
        rt=status["retweeted_status"]
        if rt!=None:
            html=string.replace(html, "$rt", rtHtml)
            rtUser=rt["user"]
            rtName=rtUser["name"]
            rtScreenName=rtUser["screen_name"]
            rtUserImage=Utils.AVATAR_DIR+str(status["account"])+"_"+str(rtUser["id"])
            if platform.os.access(rtUserImage, platform.os.W_OK) == 0:
                rtUserImage=Utils.DEFAULT_AVATAR_FILE
            rtAvatar="<img src=\"file:///"+rtUserImage+"\"/>"

#            rtUserImage=rtUser["profile_image_url"]
#            if rtUserImage==None:
#                rtUserImage=Utils.AVATAR_DIR+"default.jpg"
#            rtAvatar="<img src=\""+rtUserImage+"\"/>"
            
            rtText=rt["text"]
            rtspic=rt["thumbnail_pic"]
            rtpic=rt["original_pic"]
            if rtpic==None:
                rtpic=""
            
            if rtspic!=None:
                filename=rtspic.split("/")[-1]
                if len(filename)==0 or filename=="460":
                    filename=rtspic.split("/")[-2]
                
                rtspic=Utils.THUMBNAIL_DIR+str(rt["account"])+"_"+str(rt["id"])+"_"+filename
                if os.access(rtspic, platform.os.W_OK) == 0:
                    #rtspic=""
                    rtspic=rt["thumbnail_pic"]                    
                    print rtspic
                else:
                    rtspic = "file:///" + rtspic
            else:
                rtspic=""
            
#            rtPic=rt["original_pic"]
#            if rtPic==None:
#                rtPic=""
#            else:
#                rtPic="<img src=\""+rtPic+"\"/>"

        else:
            html=string.replace(html, "$rt", "")
            
        if down_orgpic == "True":
            #print "doLoadImage();"
            down_pic = "doLoadImage();"
            down_rtpic = "doLoadRtImage();"
        else:
            #print "doInit();"
            down_pic = "doInit();"
            down_rtpic = "doInitRt();"  
            
        text = self.parseURL(text, status["bmiddle_pic"])
        html=string.replace(html, "$text", text)
        html=string.replace(html, "$source", source)
        html=string.replace(html, "$createdAt", createdAtString)
        html=string.replace(html, "$spic", spic)
        html=string.replace(html, "$pic", pic)
        html=string.replace(html, "$down_pic", down_pic)
        if rt!=None:
            rtText = self.parseURL(rtText, status["bmiddle_pic"])
            html=string.replace(html, "$rtText", rtName+"(@"+rtScreenName+"): "+rtText)
        else:
            html=string.replace(html, "$rtText", "")
        html=string.replace(html, "$rtspic", rtspic)
        html=string.replace(html, "$rtpic", rtpic)
        html=string.replace(html, "$rtAvatar", rtAvatar)
        html=self.repFace(html, status["bmiddle_pic"])
        html=string.replace(html, "$down_rtpic", down_rtpic)
        #print html
        self.setHtml(html)
        
    def parseURL(self, html, strer):
        if strer==None:
            strer=""
            
        if len(strer)==10:
            return html
        else:
            import re
            html = re.sub(r"(http:\/\/t.cn/\w+)", r"<a target='_blank' href='\1'>\1</a>", html)
            return html
            

    def repFace(self, html, strer):
        if strer==None:
            strer=""
            
        if len(strer)==10:
            facePath = Utils.ICONS_DIR+"face.qq/"
            
            html = string.replace(html, "/惊讶", "<img src=\"file:///"+facePath+"0.gif\"/>")
            html = string.replace(html, "/撇嘴", "<img src=\"file:///"+facePath+"1.gif\"/>")
            html = string.replace(html, "/色", "<img src=\"file:///"+facePath+"2.gif\"/>")
            html = string.replace(html, "/发呆", "<img src=\"file:///"+facePath+"3.gif\"/>")
            html = string.replace(html, "/得意", "<img src=\"file:///"+facePath+"4.gif\"/>")
            html = string.replace(html, "/流泪", "<img src=\"file:///"+facePath+"5.gif\"/>")
            html = string.replace(html, "/羞涩", "<img src=\"file:///"+facePath+"6.gif\"/>")
            html = string.replace(html, "/闭嘴", "<img src=\"file:///"+facePath+"7.gif\"/>")
            html = string.replace(html, "/睡", "<img src=\"file:///"+facePath+"8.gif\"/>")
            html = string.replace(html, "/大哭", "<img src=\"file:///"+facePath+"9.gif\"/>")
            html = string.replace(html, "/尴尬", "<img src=\"file:///"+facePath+"10.gif\"/>")
            html = string.replace(html, "/发怒", "<img src=\"file:///"+facePath+"11.gif\"/>")
            html = string.replace(html, "/调皮", "<img src=\"file:///"+facePath+"12.gif\"/>")
            html = string.replace(html, "/呲牙", "<img src=\"file:///"+facePath+"13.gif\"/>")
            html = string.replace(html, "/微笑", "<img src=\"file:///"+facePath+"14.gif\"/>")
            html = string.replace(html, "/难过", "<img src=\"file:///"+facePath+"15.gif\"/>")
            html = string.replace(html, "/酷", "<img src=\"file:///"+facePath+"16.gif\"/>")
            #html = string.replace(html, "/口罩", "<img src=\"file:///"+facePath+"17.gif\"/>")
            html = string.replace(html, "/抓狂", "<img src=\"file:///"+facePath+"18.gif\"/>")
            html = string.replace(html, "/吐", "<img src=\"file:///"+facePath+"19.gif\"/>")
            html = string.replace(html, "/偷笑", "<img src=\"file:///"+facePath+"20.gif\"/>")
            html = string.replace(html, "/可爱", "<img src=\"file:///"+facePath+"21.gif\"/>")
            html = string.replace(html, "/白眼", "<img src=\"file:///"+facePath+"22.gif\"/>")
            html = string.replace(html, "/傲慢", "<img src=\"file:///"+facePath+"23.gif\"/>")
            html = string.replace(html, "/饥饿", "<img src=\"file:///"+facePath+"24.gif\"/>")
            html = string.replace(html, "/困", "<img src=\"file:///"+facePath+"25.gif\"/>")
            html = string.replace(html, "/惊恐", "<img src=\"file:///"+facePath+"26.gif\"/>")
            html = string.replace(html, "/流汗", "<img src=\"file:///"+facePath+"27.gif\"/>")
            html = string.replace(html, "/憨笑", "<img src=\"file:///"+facePath+"28.gif\"/>")
            html = string.replace(html, "/大兵", "<img src=\"file:///"+facePath+"29.gif\"/>")
            html = string.replace(html, "/奋斗", "<img src=\"file:///"+facePath+"30.gif\"/>")
            html = string.replace(html, "/诅咒", "<img src=\"file:///"+facePath+"31.gif\"/>")
            html = string.replace(html, "/疑问", "<img src=\"file:///"+facePath+"32.gif\"/>")
            html = string.replace(html, "/嘘…", "<img src=\"file:///"+facePath+"33.gif\"/>")
            html = string.replace(html, "/晕", "<img src=\"file:///"+facePath+"34.gif\"/>")
            html = string.replace(html, "/折磨", "<img src=\"file:///"+facePath+"35.gif\"/>")
            html = string.replace(html, "/衰", "<img src=\"file:///"+facePath+"36.gif\"/>")
            html = string.replace(html, "/骷髅", "<img src=\"file:///"+facePath+"37.gif\"/>")
            html = string.replace(html, "/敲打", "<img src=\"file:///"+facePath+"38.gif\"/>")
            html = string.replace(html, "/再见", "<img src=\"file:///"+facePath+"39.gif\"/>")
            #html = string.replace(html, "/XXXX", "<img src=\"file:///"+facePath+"40.gif\"/>")
            html = string.replace(html, "/发抖", "<img src=\"file:///"+facePath+"41.gif\"/>")
            html = string.replace(html, "/爱情", "<img src=\"file:///"+facePath+"42.gif\"/>")
            html = string.replace(html, "/跳跳", "<img src=\"file:///"+facePath+"43.gif\"/>")
            #html = string.replace(html, "/查找", "<img src=\"file:///"+facePath+"44.gif\"/>")
            #html = string.replace(html, "/女Q", "<img src=\"file:///"+facePath+"45.gif\"/>")
            html = string.replace(html, "/猪头", "<img src=\"file:///"+facePath+"46.gif\"/>")
            #html = string.replace(html, "/猫咪", "<img src=\"file:///"+facePath+"47.gif\"/>")
            #html = string.replace(html, "/狗", "<img src=\"file:///"+facePath+"48.gif\"/>")
            html = string.replace(html, "/拥抱", "<img src=\"file:///"+facePath+"49.gif\"/>")
            #html = string.replace(html, "/钱", "<img src=\"file:///"+facePath+"50.gif\"/>")
            #html = string.replace(html, "/灯泡", "<img src=\"file:///"+facePath+"51.gif\"/>")
            #html = string.replace(html, "/酒杯", "<img src=\"file:///"+facePath+"52.gif\"/>")
            html = string.replace(html, "/蛋糕", "<img src=\"file:///"+facePath+"53.gif\"/>")
            html = string.replace(html, "/闪电", "<img src=\"file:///"+facePath+"54.gif\"/>")
            html = string.replace(html, "/炸弹", "<img src=\"file:///"+facePath+"55.gif\"/>")
            html = string.replace(html, "/刀", "<img src=\"file:///"+facePath+"56.gif\"/>")
            html = string.replace(html, "/足球", "<img src=\"file:///"+facePath+"57.gif\"/>")
            #html = string.replace(html, "/音乐", "<img src=\"file:///"+facePath+"58.gif\"/>")
            #html = string.replace(html, "/大便", "<img src=\"file:///"+facePath+"59.gif\"/>")
            html = string.replace(html, "/咖啡", "<img src=\"file:///"+facePath+"60.gif\"/>")
            html = string.replace(html, "/饭", "<img src=\"file:///"+facePath+"61.gif\"/>")
            #html = string.replace(html, "/药", "<img src=\"file:///"+facePath+"62.gif\"/>")
            html = string.replace(html, "/玫瑰", "<img src=\"file:///"+facePath+"63.gif\"/>")
            html = string.replace(html, "/凋谢", "<img src=\"file:///"+facePath+"64.gif\"/>")
            #html = string.replace(html, "/唇", "<img src=\"file:///"+facePath+"65.gif\"/>")
            html = string.replace(html, "/爱心", "<img src=\"file:///"+facePath+"66.gif\"/>")
            html = string.replace(html, "/心碎", "<img src=\"file:///"+facePath+"67.gif\"/>")
            #html = string.replace(html, "/餐桌", "<img src=\"file:///"+facePath+"68.gif\"/>")
            html = string.replace(html, "/礼物", "<img src=\"file:///"+facePath+"69.gif\"/>")
            #html = string.replace(html, "/电话", "<img src=\"file:///"+facePath+"70.gif\"/>")
            #html = string.replace(html, "/时间", "<img src=\"file:///"+facePath+"71.gif\"/>")
            #html = string.replace(html, "/信件", "<img src=\"file:///"+facePath+"72.gif\"/>")
            #html = string.replace(html, "/电视", "<img src=\"file:///"+facePath+"73.gif\"/>")
            html = string.replace(html, "/太阳", "<img src=\"file:///"+facePath+"74.gif\"/>")
            html = string.replace(html, "/月亮", "<img src=\"file:///"+facePath+"75.gif\"/>")
            html = string.replace(html, "/强", "<img src=\"file:///"+facePath+"76.gif\"/>")
            html = string.replace(html, "/弱", "<img src=\"file:///"+facePath+"77.gif\"/>")
            html = string.replace(html, "/握手", "<img src=\"file:///"+facePath+"78.gif\"/>")
            html = string.replace(html, "/胜利", "<img src=\"file:///"+facePath+"79.gif\"/>")
            #html = string.replace(html, "/灰老鼠", "<img src=\"file:///"+facePath+"80.gif\"/>")
            #html = string.replace(html, "/小女孩", "<img src=\"file:///"+facePath+"81.gif\"/>")
            #html = string.replace(html, "/XXXX", "<img src=\"file:///"+facePath+"82.gif\"/>")
            #html = string.replace(html, "/XXXX", "<img src=\"file:///"+facePath+"83.gif\"/>")
            #html = string.replace(html, "/男Q", "<img src=\"file:///"+facePath+"84.gif\"/>")
            html = string.replace(html, "/飞吻", "<img src=\"file:///"+facePath+"85.gif\"/>")
            html = string.replace(html, "/怄火", "<img src=\"file:///"+facePath+"86.gif\"/>")
            #html = string.replace(html, "/酒瓶", "<img src=\"file:///"+facePath+"87.gif\"/>")
            #html = string.replace(html, "/可乐", "<img src=\"file:///"+facePath+"88.gif\"/>")
            html = string.replace(html, "/西瓜", "<img src=\"file:///"+facePath+"89.gif\"/>")
            #html = string.replace(html, "/阴雨", "<img src=\"file:///"+facePath+"90.gif\"/>")
            #html = string.replace(html, "/多云", "<img src=\"file:///"+facePath+"91.gif\"/>")
            #html = string.replace(html, "/雪人", "<img src=\"file:///"+facePath+"92.gif\"/>")
            #html = string.replace(html, "/星星", "<img src=\"file:///"+facePath+"93.gif\"/>")
            #html = string.replace(html, "/女", "<img src=\"file:///"+facePath+"94.gif\"/>")
            #html = string.replace(html, "/男", "<img src=\"file:///"+facePath+"95.gif\"/>")
            html = string.replace(html, "/冷汗", "<img src=\"file:///"+facePath+"96.gif\"/>")
            html = string.replace(html, "/擦汗", "<img src=\"file:///"+facePath+"97.gif\"/>")
            html = string.replace(html, "/抠鼻", "<img src=\"file:///"+facePath+"98.gif\"/>")
            html = string.replace(html, "/鼓掌", "<img src=\"file:///"+facePath+"99.gif\"/>")
            html = string.replace(html, "/糗大了", "<img src=\"file:///"+facePath+"100.gif\"/>")
            html = string.replace(html, "/坏笑", "<img src=\"file:///"+facePath+"101.gif\"/>")
            html = string.replace(html, "/左哼哼", "<img src=\"file:///"+facePath+"102.gif\"/>")
            html = string.replace(html, "/右哼哼", "<img src=\"file:///"+facePath+"103.gif\"/>")
            html = string.replace(html, "/哈欠", "<img src=\"file:///"+facePath+"104.gif\"/>")
            html = string.replace(html, "/鄙视", "<img src=\"file:///"+facePath+"105.gif\"/>")
            html = string.replace(html, "/委屈", "<img src=\"file:///"+facePath+"106.gif\"/>")
            html = string.replace(html, "/快哭了", "<img src=\"file:///"+facePath+"107.gif\"/>")
            html = string.replace(html, "/阴险", "<img src=\"file:///"+facePath+"108.gif\"/>")
            html = string.replace(html, "/亲亲", "<img src=\"file:///"+facePath+"109.gif\"/>")
            html = string.replace(html, "/吓", "<img src=\"file:///"+facePath+"110.gif\"/>")
            html = string.replace(html, "/可怜", "<img src=\"file:///"+facePath+"111.gif\"/>")
            html = string.replace(html, "/菜刀", "<img src=\"file:///"+facePath+"112.gif\"/>")
            html = string.replace(html, "/啤酒", "<img src=\"file:///"+facePath+"113.gif\"/>")
            html = string.replace(html, "/篮球", "<img src=\"file:///"+facePath+"114.gif\"/>")
            html = string.replace(html, "/乒乓", "<img src=\"file:///"+facePath+"115.gif\"/>")
            html = string.replace(html, "/示爱", "<img src=\"file:///"+facePath+"116.gif\"/>")
            html = string.replace(html, "/瓢虫", "<img src=\"file:///"+facePath+"117.gif\"/>")
            html = string.replace(html, "/抱拳", "<img src=\"file:///"+facePath+"118.gif\"/>")
            html = string.replace(html, "/勾引", "<img src=\"file:///"+facePath+"119.gif\"/>")
            html = string.replace(html, "/拳头", "<img src=\"file:///"+facePath+"120.gif\"/>")
            html = string.replace(html, "/差劲", "<img src=\"file:///"+facePath+"121.gif\"/>")
            html = string.replace(html, "/爱你", "<img src=\"file:///"+facePath+"122.gif\"/>")
            html = string.replace(html, "/NO", "<img src=\"file:///"+facePath+"123.gif\"/>")
            html = string.replace(html, "/OK", "<img src=\"file:///"+facePath+"124.gif\"/>")
            html = string.replace(html, "/转圈", "<img src=\"file:///"+facePath+"125.gif\"/>")
            html = string.replace(html, "/磕头", "<img src=\"file:///"+facePath+"126.gif\"/>")
            html = string.replace(html, "/回头", "<img src=\"file:///"+facePath+"127.gif\"/>")
            html = string.replace(html, "/跳绳", "<img src=\"file:///"+facePath+"128.gif\"/>")
            html = string.replace(html, "/挥手", "<img src=\"file:///"+facePath+"129.gif\"/>")
            html = string.replace(html, "/激动", "<img src=\"file:///"+facePath+"130.gif\"/>")
            html = string.replace(html, "/街舞", "<img src=\"file:///"+facePath+"131.gif\"/>")
            html = string.replace(html, "/献吻", "<img src=\"file:///"+facePath+"132.gif\"/>")
            html = string.replace(html, "/左太极", "<img src=\"file:///"+facePath+"133.gif\"/>")
            html = string.replace(html, "/右太极", "<img src=\"file:///"+facePath+"134.gif\"/>")
            html = string.replace(html, "/黑丝带", "<img src=\"file:///"+facePath+"135.gif\"/>")
            html = string.replace(html, "/祈福", "<img src=\"file:///"+facePath+"136.gif\"/>")
            html = string.replace(html, "/黄丝带", "<img src=\"file:///"+facePath+"137.gif\"/>")
            html = string.replace(html, "/百合花", "<img src=\"file:///"+facePath+"138.gif\"/>")
            html = string.replace(html, "/糖", "<img src=\"file:///"+facePath+"150.gif\"/>")
            html = string.replace(html, "/红包", "<img src=\"file:///"+facePath+"151.gif\"/>")
            html = string.replace(html, "/月饼", "<img src=\"file:///"+facePath+"152.gif\"/>")
            html = string.replace(html, "/酒", "<img src=\"file:///"+facePath+"153.gif\"/>")
            html = string.replace(html, "/团圆饼", "<img src=\"file:///"+facePath+"154.gif\"/>")
            html = string.replace(html, "/玉兔", "<img src=\"file:///"+facePath+"155.gif\"/>")
            html = string.replace(html, "/蛋黄月饼", "<img src=\"file:///"+facePath+"156.gif\"/>")
            
        else:
            facePath = Utils.ICONS_DIR+"face.sina/"
            html = string.replace(html, "[满月]", "<img src=\"file:///"+facePath+"moon1.gif\"/>")
            html = string.replace(html, "[月饼]", "<img src=\"file:///"+facePath+"mooncake3.gif\"/>")
            html = string.replace(html, "[酒壶]", "<img src=\"file:///"+facePath+"wine.gif\"/>")
            html = string.replace(html, "[团]", "<img src=\"file:///"+facePath+"tuan.gif\"/>")
            html = string.replace(html, "[圆]", "<img src=\"file:///"+facePath+"yuan.gif\"/>")
            html = string.replace(html, "[织]", "<img src=\"file:///"+facePath+"zz2.gif\"/>")
            html = string.replace(html, "[围观]", "<img src=\"file:///"+facePath+"wg.gif\"/>")
            html = string.replace(html, "[威武]", "<img src=\"file:///"+facePath+"vw.gif\"/>")
            html = string.replace(html, "[给力]", "<img src=\"file:///"+facePath+"geili.gif\"/>")
            html = string.replace(html, "[神马]", "<img src=\"file:///"+facePath+"horse2.gif\"/>")
            html = string.replace(html, "[浮云]", "<img src=\"file:///"+facePath+"fuyun.gif\"/>")
            html = string.replace(html, "[奥特曼]", "<img src=\"file:///"+facePath+"otm.gif\"/>")
            html = string.replace(html, "[兔子]", "<img src=\"file:///"+facePath+"rabbit.gif\"/>")
            html = string.replace(html, "[熊猫]", "<img src=\"file:///"+facePath+"panda.gif\"/>")
            html = string.replace(html, "[飞机]", "<img src=\"file:///"+facePath+"travel.gif\"/>")

            html = string.replace(html, "[呵呵]", "<img src=\"file:///"+facePath+"smile.gif\"/>")
            html = string.replace(html, "[嘻嘻]", "<img src=\"file:///"+facePath+"tooth.gif\"/>")
            html = string.replace(html, "[哈哈]", "<img src=\"file:///"+facePath+"laugh.gif\"/>")
            html = string.replace(html, "[爱你]", "<img src=\"file:///"+facePath+"love.gif\"/>")
            html = string.replace(html, "[晕]", "<img src=\"file:///"+facePath+"dizzy.gif\"/>")
            html = string.replace(html, "[泪]", "<img src=\"file:///"+facePath+"sad.gif\"/>")
            html = string.replace(html, "[馋嘴]", "<img src=\"file:///"+facePath+"cz.gif\"/>")
            html = string.replace(html, "[抓狂]", "<img src=\"file:///"+facePath+"crazy.gif\"/>")
            html = string.replace(html, "[哼]", "<img src=\"file:///"+facePath+"hate.gif\"/>")
            html = string.replace(html, "[抱抱]", "<img src=\"file:///"+facePath+"bb.gif\"/>")
            html = string.replace(html, "[可爱]", "<img src=\"file:///"+facePath+"tz.gif\"/>")
            html = string.replace(html, "[怒]", "<img src=\"file:///"+facePath+"angry.gif\"/>")
            html = string.replace(html, "[汗]", "<img src=\"file:///"+facePath+"sweat.gif\"/>")
            html = string.replace(html, "[困]", "<img src=\"file:///"+facePath+"sleepy.gif\"/>")
            html = string.replace(html, "[害羞]", "<img src=\"file:///"+facePath+"shame.gif\"/>")

            html = string.replace(html, "[睡觉]", "<img src=\"file:///"+facePath+"sleep.gif\"/>")
            html = string.replace(html, "[钱]", "<img src=\"file:///"+facePath+"money.gif\"/>")
            html = string.replace(html, "[偷笑]", "<img src=\"file:///"+facePath+"hei.gif\"/>")
            html = string.replace(html, "[酷]", "<img src=\"file:///"+facePath+"cool.gif\"/>")
            html = string.replace(html, "[衰]", "<img src=\"file:///"+facePath+"cry.gif\"/>")
            html = string.replace(html, "[吃惊]", "<img src=\"file:///"+facePath+"cj.gif\"/>")
            html = string.replace(html, "[闭嘴]", "<img src=\"file:///"+facePath+"bz.gif\"/>")
            html = string.replace(html, "[鄙视]", "<img src=\"file:///"+facePath+"bs2.gif\"/>")
            html = string.replace(html, "[挖鼻屎]", "<img src=\"file:///"+facePath+"kbs.gif\"/>")
            html = string.replace(html, "[花心]", "<img src=\"file:///"+facePath+"hs.gif\"/>")
            html = string.replace(html, "[鼓掌]", "<img src=\"file:///"+facePath+"gz.gif\"/>")
            html = string.replace(html, "[失望]", "<img src=\"file:///"+facePath+"sw.gif\"/>")
            html = string.replace(html, "[思考]", "<img src=\"file:///"+facePath+"sk.gif\"/>")
            html = string.replace(html, "[生病]", "<img src=\"file:///"+facePath+"sb.gif\"/>")
            html = string.replace(html, "[亲亲]", "<img src=\"file:///"+facePath+"qq.gif\"/>")

            html = string.replace(html, "[怒骂]", "<img src=\"file:///"+facePath+"nm.gif\"/>")
            html = string.replace(html, "[太开心]", "<img src=\"file:///"+facePath+"mb.gif\"/>")
            html = string.replace(html, "[懒得理你]", "<img src=\"file:///"+facePath+"ldln.gif\"/>")
            html = string.replace(html, "[右哼哼]", "<img src=\"file:///"+facePath+"yhh.gif\"/>")
            html = string.replace(html, "[左哼哼]", "<img src=\"file:///"+facePath+"zhh.gif\"/>")
            html = string.replace(html, "[嘘]", "<img src=\"file:///"+facePath+"x.gif\"/>")
            html = string.replace(html, "[委屈]", "<img src=\"file:///"+facePath+"wq.gif\"/>")
            html = string.replace(html, "[吐]", "<img src=\"file:///"+facePath+"t.gif\"/>")
            html = string.replace(html, "[可怜]", "<img src=\"file:///"+facePath+"kl.gif\"/>")
            html = string.replace(html, "[打哈气]", "<img src=\"file:///"+facePath+"k.gif\"/>")
            html = string.replace(html, "[顶]", "<img src=\"file:///"+facePath+"d.gif\"/>")
            html = string.replace(html, "[疑问]", "<img src=\"file:///"+facePath+"yw.gif\"/>")
            html = string.replace(html, "[握手]", "<img src=\"file:///"+facePath+"ws.gif\"/>")
            html = string.replace(html, "[耶]", "<img src=\"file:///"+facePath+"ye.gif\"/>")
            html = string.replace(html, "[good]", "<img src=\"file:///"+facePath+"good.gif\"/>")

            html = string.replace(html, "[弱]", "<img src=\"file:///"+facePath+"sad_thumb.gif\"/>")
            html = string.replace(html, "[不要]", "<img src=\"file:///"+facePath+"no.gif\"/>")
            html = string.replace(html, "[ok]", "<img src=\"file:///"+facePath+"ok.gif\"/>")
            html = string.replace(html, "[赞]", "<img src=\"file:///"+facePath+"z2.gif\"/>")
            html = string.replace(html, "[来]", "<img src=\"file:///"+facePath+"come.gif\"/>")
            html = string.replace(html, "[蛋糕]", "<img src=\"file:///"+facePath+"cake.gif\"/>")
            html = string.replace(html, "[心]", "<img src=\"file:///"+facePath+"heart.gif\"/>")
            html = string.replace(html, "[伤心]", "<img src=\"file:///"+facePath+"unheart.gif\"/>")
            html = string.replace(html, "[钟]", "<img src=\"file:///"+facePath+"clock.gif\"/>")
            html = string.replace(html, "[猪头]", "<img src=\"file:///"+facePath+"pig.gif\"/>")
            html = string.replace(html, "[话筒]", "<img src=\"file:///"+facePath+"m.gif\"/>")
            html = string.replace(html, "[月亮]", "<img src=\"file:///"+facePath+"moon.gif\"/>")
            html = string.replace(html, "[下雨]", "<img src=\"file:///"+facePath+"rain.gif\"/>")
            html = string.replace(html, "[太阳]", "<img src=\"file:///"+facePath+"sun.gif\"/>")
            html = string.replace(html, "[微博蛋糕]", "<img src=\"file:///"+facePath+"weibo2zhounian.gif\"/>")
            html = string.replace(html, "[蜡烛]", "<img src=\"file:///"+facePath+"lazu.gif\"/>")
        return html

    def update_content_html(self, contentHtml=None, baseUrl=None):
#        settings=self.settings()
#        settings.setDefaultTextEncoding("gbk")
#        self.reload()
#        self.setHtml("")
        self.setHtml(contentHtml,baseUrl)
#        self.reload()

    def zoom(self,size):
        self.setZoomFactor(size)

#class ContentEventFilter(QObject):
#
#    def __init__(self, parent = None):
#        QObject.__init__(self, parent)
#        self.mousePressed=False
#
#    def eventFilter(self, object, event):
#        eventType = event.type()
#        if eventType == QEvent.MouseButtonPress:
#            if event.buttons() == Qt.LeftButton:
#                self.mousePressed  = True
#        if eventType == QEvent.MouseButtonRelease:
#            if event.buttons() == Qt.LeftButton:
#                self.mousePressed  = False
#        if eventType == QEvent.MouseMove:
#            if self.mousePressed:
#                return True
#        return False


class AccountsManaForm(QDialog):
    def __init__(self, accounts=None,websites=None, parent=None, orientation=0):
        super(AccountsManaForm, self).__init__(parent)
        self.accounts=accounts
        self.websites=websites
#        print self.accounts
        self.orientation=orientation
        self.accountsListView=QListView()
        self.accountsListView.setWordWrap(True)
        self.accountsListView.setEditTriggers(QAbstractItemView.SelectedClicked)
        self.accountsListView.setSpacing(0)
        self.accountsListView.setUniformItemSizes(False)
        self.accountsListView.setResizeMode(QListView.Adjust)
        self.accountsListView.setHorizontalScrollBarPolicy(Qt.ScrollBarAlwaysOff)
        self.accountsListView.setVerticalScrollBarPolicy(Qt.ScrollBarAsNeeded)

        self.accountsListView.setItemDelegate(AccountCellDelegate(self))
        self.accountsModel=AccountsModel(self.accounts,self.websites)
        self.accountsListView.setModel(self.accountsModel)

        self.accountsListView.setStyleSheet("background-color: "+Utils.COLOR_BACKGROUND)

        self.setWindowTitle(unicode("账户管理"))
        self.addButton = QPushButton(unicode("添加"))
        self.editButton = QPushButton(unicode("编辑"))
        self.delButton = QPushButton(unicode("删除"))

#        if self.orientation==1:
#            self.outerLayout = QVBoxLayout(self)
#        else:
        self.outerLayout = QGridLayout(self)
        self.outerLayout.setObjectName("outerLayout")
        
        self.buttonFormLayout=QFormLayout()
        self.buttonFormLayout.setAlignment(Qt.AlignTop)
        if self.orientation==1:
            self.addButton.setFixedWidth(140)
            self.editButton.setFixedWidth(140)
            self.delButton.setFixedWidth(140)
            self.buttonFormLayout.addRow(self.addButton,self.editButton,self.delButton)
            self.setFixedHeight(500)
        else:
            self.addButton.setFixedWidth(150)
            self.editButton.setFixedWidth(150)
            self.delButton.setFixedWidth(150)
            self.buttonFormLayout.addRow(self.addButton)
            self.buttonFormLayout.addRow(self.editButton)
            self.buttonFormLayout.addRow(self.delButton)
            self.setFixedHeight(300)
        self.buttonFrame=QFrame()
        self.buttonFrame.setLayout(self.buttonFormLayout)
        self.outerLayout.addWidget(self.accountsListView,0,0)
        if self.orientation==1:
            self.outerLayout.addWidget(self.buttonFrame,1,0)
        else:
            self.outerLayout.addWidget(self.buttonFrame,0,1)

    def switch(self,orientation):
        if orientation==self.orientation:
            return
        self.orientation=orientation
        self.buttonFormLayout.removeWidget(self.addButton)
        self.buttonFormLayout.removeWidget(self.editButton)
        self.buttonFormLayout.removeWidget(self.delButton)
        self.outerLayout.removeWidget(self.buttonFrame)
        if self.orientation==1:
            self.addButton.setFixedWidth(140)
            self.editButton.setFixedWidth(140)
            self.delButton.setFixedWidth(140)
            self.buttonFormLayout.addRow(self.addButton,self.editButton,self.delButton)
            self.setFixedHeight(500)
        else:
            self.addButton.setFixedWidth(150)
            self.editButton.setFixedWidth(150)
            self.delButton.setFixedWidth(150)
            self.buttonFormLayout.addRow(self.addButton)
            self.buttonFormLayout.addRow(self.editButton)
            self.buttonFormLayout.addRow(self.delButton)
            self.setFixedHeight(300)


    def update_accounts(self,accounts):
        self.accounts=accounts
        self.accountsModel=AccountsModel(self.accounts,self.websites)
        self.accountsListView.setModel(self.accountsModel)

    def get_selected(self):
        rownum=-1
        smodel=self.accountsListView.selectionModel()
        if smodel.hasSelection():
            index=smodel.selectedIndexes()[0]
            rownum=index.row()
        return rownum

class NewAccountForm(QDialog):
    def __init__(self, websites=None,account=None, parent=None,orientation=0):
        super(NewAccountForm, self).__init__(parent)
        self.orientation=orientation
#        self.oAccount=account
        self.label_5 = QLabel(unicode("昵称"))
        self.label_5.setObjectName("label_5")
        self.label = QLabel(unicode("令牌"))
        self.label.setObjectName("label")
        self.label_2 = QLabel(unicode("密钥"))
        self.label_2.setObjectName("label_2")
        self.label_4 = QLabel(unicode("平台"))
        self.label_4.setObjectName("label_4")
        self.nicknameLE = QLineEdit(self)
        self.label_6 = QLabel(unicode("通知"))
        self.label_6.setObjectName("label_6")
        self.nicknameLE.setObjectName("nickname")
        self.usernameLE = QLineEdit(self)
        self.usernameLE.setObjectName("username")
        self.passwordLE = QLineEdit(self)
        #self.passwordLE.setEchoMode(QLineEdit.PasswordEchoOnEdit)
        self.passwordLE.setObjectName("password")
        
        self.radiogroup = QGroupBox(self)        
        self.label_radio = QRadioButton(unicode("未读消息自动通知"), self.radiogroup)

        self.webCB=QComboBox(self)
        index=0
        for website in websites:
            self.webCB.insertItem(index,unicode(website["name"]),QVariant(website["id"]))
            index+=1

        self.confirmButton = QPushButton(unicode("确定"))

        self.cancelButton = QPushButton(unicode("取消"))

        self.cancelButton.setFixedWidth(200)
        self.confirmButton.setFixedWidth(200)
        self.connect(self.cancelButton,
                     SIGNAL("clicked()"),
                     self.hide)

#        if self.orientation==1:
#            self.outerLayout = QVBoxLayout(self)
#        else:
        self.outerLayout = QGridLayout(self)
        self.outerLayout.setObjectName("outerLayout")
        self.formLayout=QFormLayout()
        self.formLayout.setAlignment(Qt.AlignTop)
        self.formLayout.addRow(self.label_4,self.webCB)
        self.formLayout.addRow(self.label_5,self.nicknameLE)
        self.formLayout.addRow(self.label,self.usernameLE)
        self.formLayout.addRow(self.label_2,self.passwordLE)
        self.formLayout.addRow(self.label_6,self.label_radio)

        self.frame=QFrame()
        self.frame.setLayout(self.formLayout)
        
        self.buttonFormLayout=QFormLayout()
        self.buttonFormLayout.setAlignment(Qt.AlignTop)
        if self.orientation==1:
            self.buttonFormLayout.addRow(self.confirmButton,self.cancelButton)
        else:
            self.buttonFormLayout.addRow(self.confirmButton)
            self.buttonFormLayout.addRow(self.cancelButton)
            
            # get token url.
            self.gettokenButton = QPushButton(unicode("绑定我的微博帐号\r\n获取令牌以及密钥\r\n点击按钮后请稍等"))
            self.gettokenButton.setFixedHeight(150)
            self.gettokenButton.setFixedWidth(200)
            self.connect(self.gettokenButton,SIGNAL("clicked()"),self.getToken)
            
            self.buttonFormLayout.addRow(self.gettokenButton)
        self.buttonFrame=QFrame()
        self.buttonFrame.setLayout(self.buttonFormLayout)

        self.outerLayout.addWidget(self.frame,0,0)
        if self.orientation==1:
            self.outerLayout.addWidget(self.buttonFrame,1,0)
        else:
            self.outerLayout.addWidget(self.buttonFrame,0,1)
        self.outerLayout.setAlignment(self.formLayout,Qt.AlignTop)
        self.update_account(account)

    def getToken(self):
        self.websiteSelect = self.webCB.currentIndex()
        
        print "init input pin form..."
        self.getTokenAccessForm=getTokenAccessForm(self, self.websiteSelect)
        self.connect(self.getTokenAccessForm.confirmButton,
                 SIGNAL("clicked()"),
                 self.getTokenAccess)
        self.getTokenAccessForm.show()
        
        
    def getTokenAccess(self):
        self.InputPin = self.getTokenAccessForm.InputPin.text()
        print "getTokenAccess: ->" + self.InputPin + "<-"
        
        if self.InputPin is None or self.InputPin=="":
            self.show_notice("请输入PIN码")
        else:
            if self.websiteSelect==0:
                from weibopy.auth import OAuthHandler
                key = "475214689"
                secret = "f9b9d4850089e3b95a5c3e6e1d17bed5"
                
            else:
                from qqweibo.auth import OAuthHandler
                key = "de5f447222ac49189edc36cd061806c6"
                secret = "7ba914334cfc0ef56271de89be36cdb0"
            
            try:
                #self.auth = OAuthHandler(key, secret)
                #self.auth_url = self.auth.get_authorization_url()
                
                tokenAccess = self.getTokenAccessForm.auth.get_access_token(self.InputPin)  
                
                self.usernameLE.setText(unicode(tokenAccess.key))
                self.passwordLE.setText(unicode(tokenAccess.secret))
                
                self.getTokenAccessForm.hide()
            except Exception, e:
                self.show_notice("前往服务器API验证时出现错误！")
                print e
                

    def show_notice(self,message,timeout=QMaemo5InformationBox.DefaultTimeout):
        QMaemo5InformationBox.information(None,"\n"+unicode(message)+"\n",timeout)

    def switch(self,orientation):
        if orientation==self.orientation:
            return
        self.orientation=orientation
        self.buttonFormLayout.removeWidget(self.confirmButton)
        self.buttonFormLayout.removeWidget(self.cancelButton)
        if orientation==1:
            self.buttonFormLayout.addRow(self.confirmButton,self.cancelButton)
            self.outerLayout.addWidget(self.buttonFrame,1,0)
        else:
            self.buttonFormLayout.addRow(self.confirmButton)
            self.buttonFormLayout.addRow(self.cancelButton)
            self.outerLayout.addWidget(self.buttonFrame,0,1)

    def update_account(self,account=None):
        self.account=account
        if account is not None:
            self.nicknameLE.setFocus()
            if account["nickname"] is None:
                self.nicknameLE.setText("")
            else:
                self.nicknameLE.setText(unicode(account["nickname"]))
                self.nicknameLE.selectAll()
            if account["username"] is None:
                self.usernameLE.setText("")
            else:
                self.usernameLE.setText(unicode(account["username"]))
                self.usernameLE.selectAll()
            if account["password"] is None:
                self.passwordLE.setText("")
            else:
                self.passwordLE.setText(unicode(account["password"]))
            if account["website"] is None:
                self.webCB.setCurrentIndex(0)
            else:
                for i in range(self.webCB.count()):
                    self.webCB.setCurrentIndex(i)
                    if self.webCB.itemData(self.webCB.currentIndex())==QVariant(account["website"]):
                        break
            if account["auto_update"]=="True":
                self.label_radio.setChecked(True)
            else:
                self.label_radio.setChecked(False)


    def validate(self,callback):
        if self.nicknameLE.text() is None or self.nicknameLE.text()=="":
            callback(unicode("请输入昵称"))
            return 0
        if self.usernameLE.text() is None or self.usernameLE.text()=="":
            callback(unicode("请输入令牌"))
            return 0
        elif self.passwordLE.text() is None or self.passwordLE.text()=="":
            callback(unicode("请输入密钥"))
            return 0
        else:
            return 1

    def output_account(self,callback):
        if self.validate(callback):
            self.account["nickname"]=str(self.nicknameLE.text())
            self.account["username"]=str(self.usernameLE.text())
            self.account["password"]=str(self.passwordLE.text())
            self.account["website"]=int(self.webCB.itemData(self.webCB.currentIndex()).toString())
            self.account["auto_update"]=str(self.label_radio.isChecked())

            return self.account
        else:
            return None
            
class DeleteAccountForm(QDialog):
    def __init__(self, account=None,website=None, parent=None,orientation=0):
        super(DeleteAccountForm, self).__init__(parent)
        self.orientation=orientation
        self.account=account
        self.website=website
        username=account["nickname"]
        web=website["name"]
        self.setWindowTitle(unicode("删除账户"))
        self.label = QLabel(unicode("确认删除账户 %s-%s ?" %(username,web)))
        self.label.setWordWrap(True)

#        if self.orientation==1:
#            self.outerLayout = QVBoxLayout(self)
#        else:
        self.outerLayout = QGridLayout(self)
        self.outerLayout.setObjectName("outerLayout")
        self.formLayout=QFormLayout()
        self.formLayout.setAlignment(Qt.AlignTop)
        self.formLayout.addRow(self.label)

        self.frame=QFrame()
        self.frame.setLayout(self.formLayout)
        
        self.confirmButton = QPushButton(unicode("确定"))
        self.cancelButton = QPushButton(unicode("取消"))
        self.connect(self.cancelButton,
                     SIGNAL("clicked()"),
                     self.hide)
        self.buttonFormLayout=QFormLayout()
        self.buttonFormLayout.setAlignment(Qt.AlignTop)
        self.buttonFrame=QFrame()
        if self.orientation==1:
            self.label.setFixedWidth(430)
            self.confirmButton.setFixedWidth(200)
            self.cancelButton.setFixedWidth(200)
            self.buttonFormLayout.addRow(self.confirmButton,self.cancelButton)
        else:
            self.label.setFixedWidth(600)
            self.confirmButton.setFixedWidth(150)
            self.cancelButton.setFixedWidth(150)
            self.buttonFormLayout.addRow(self.confirmButton)
            self.buttonFormLayout.addRow(self.cancelButton)
        self.buttonFrame.setLayout(self.buttonFormLayout)
        self.outerLayout.addWidget(self.frame,0,0)
        if self.orientation==1:
            self.outerLayout.addWidget(self.buttonFrame,1,0)
        else:
            self.outerLayout.addWidget(self.buttonFrame,0,1)
        self.outerLayout.setAlignment(self.formLayout,Qt.AlignTop)

    def switch(self,orientation):
        if orientation==self.orientation:
            return
        self.orientation=orientation
        self.buttonFormLayout.removeWidget(self.confirmButton)
        self.buttonFormLayout.removeWidget(self.cancelButton)
        self.outerLayout.removeWidget(self.buttonFrame)
        if self.orientation==1:
            self.label.setFixedWidth(430)
            self.confirmButton.setFixedWidth(200)
            self.cancelButton.setFixedWidth(200)
            self.buttonFormLayout.addRow(self.confirmButton,self.cancelButton)
            self.outerLayout.addWidget(self.buttonFrame,1,0)
        else:
            self.label.setFixedWidth(600)
            self.confirmButton.setFixedWidth(150)
            self.cancelButton.setFixedWidth(150)
            self.buttonFormLayout.addRow(self.confirmButton)
            self.buttonFormLayout.addRow(self.cancelButton)
            self.outerLayout.addWidget(self.buttonFrame,0,1)

class getTokenAccessForm(QDialog):
    def __init__(self, parent=None, websiteSelect=0):
        super(getTokenAccessForm, self).__init__(parent)
        self.setWindowTitle(unicode("输入PIN绑定微博账户"))
        self.label = QLabel(unicode("请输入从浏览器中获得的授权码PIN，然后点击确认："))
        self.label.setWordWrap(True)
        
        self.InputPin = QLineEdit(self)
        self.InputPin.setObjectName("InputPin")

        self.browserButton = QPushButton(unicode("点击此处打开浏览器前往授权页面"))
        self.connect(self.browserButton,
                     SIGNAL("clicked()"),
                     self.openBrowser)
        
        #self.openBrowserLabel = QLabel(unicode("请复制以下地址，然后在浏览器中打开进入授权页面："))
        #self.openBrowserURL = QLineEdit(self)
        #self.openBrowserURL.setObjectName("InputPin")

        self.outerLayout = QGridLayout(self)
        self.outerLayout.setObjectName("outerLayout")
        self.formLayout=QFormLayout()
        self.formLayout.setAlignment(Qt.AlignTop)
        #self.formLayout.addRow(self.openBrowserLabel)
        #self.formLayout.addRow(self.openBrowserURL)
        self.formLayout.addRow(self.browserButton)
        self.formLayout.addRow(self.label)
        self.formLayout.addRow(self.InputPin)

        self.frame=QFrame()
        self.frame.setLayout(self.formLayout)
        
        self.confirmButton = QPushButton(unicode("确定"))
        self.cancelButton = QPushButton(unicode("取消"))
        self.connect(self.cancelButton,
                     SIGNAL("clicked()"),
                     self.hide)
        self.buttonFormLayout=QFormLayout()
        self.buttonFormLayout.setAlignment(Qt.AlignTop)
        self.buttonFrame=QFrame()
        
        self.confirmButton.setFixedWidth(150)
        self.cancelButton.setFixedWidth(150)
        self.buttonFormLayout.addRow(self.confirmButton)
        self.buttonFormLayout.addRow(self.cancelButton)
        self.buttonFrame.setLayout(self.buttonFormLayout)
        self.outerLayout.addWidget(self.frame,0,0)
        self.outerLayout.addWidget(self.buttonFrame,0,1)
        self.outerLayout.setAlignment(self.formLayout,Qt.AlignTop)
        
        if websiteSelect==0:
            from weibopy.auth import OAuthHandler
            key = "475214689"
            secret = "f9b9d4850089e3b95a5c3e6e1d17bed5"
            
        else:
            from qqweibo.auth import OAuthHandler
            key = "de5f447222ac49189edc36cd061806c6"
            secret = "7ba914334cfc0ef56271de89be36cdb0"
        
        print "get auth url..."
        try:
            self.auth = OAuthHandler(key, secret)
            #print "OAuthHandler"
            self.auth_url = self.auth.get_authorization_url()
        except Exception, e:
            self.show_notice("初始化绑定失败:"+str(e))
            print e
        
        #self.openBrowserURL.setText(self.auth_url)
    
    def openBrowser(self):
        tmpOpenBrowserWindow = openBrowserWindow(self,self.auth_url)
        tmpOpenBrowserWindow.show()
        #try:
             
            #import os
            #print "open browser..."
            #print self.auth_url
            # maebo browser have a bug!
            #os.system('browser --url="' + self.auth_url + '"')
            #os.system('dbus-send --system --type=method_call --dest=com.nokia.osso_browser /com/nokia/osso_browser/request com.nokia.osso_browser.load_url string:"' + self.auth_url + '"')
        #except:
        #    self.show_notice("Maemo5 Broswer have a Bug.")
    
        #BrowserWindow = QWebView()
        #BrowserWindow.load(QUrl(self.auth_url))
        #BrowserWindow.show()
    

    def show_notice(self,message,timeout=QMaemo5InformationBox.DefaultTimeout):
        QMaemo5InformationBox.information(None,"\n"+unicode(message)+"\n",timeout)

class openBrowserWindow(QDialog):
    def __init__(self, parent=None, authurl=None):
        super(openBrowserWindow, self).__init__(parent)
        self.setWindowTitle(unicode("微博账户授权绑定页面"))
        
        #self.aboutLabel=QLabel()
        #self.aboutLabel.setText("test")
        #self.formLayout=QFormLayout(self)
        #self.formLayout.addRow(self.aboutLabel)
        
        
        #self.mainFrame=QFrame()
        #self.mainLayout=QVBoxLayout(self.mainFrame)
        #self.mainLayout.insertStretch(0,20)
        #self.mainLayout.addWidget(self.userBtn)
        #self.mainLayout.addWidget(self.statusContentView)
        #self.mainLayout.addWidget(self.buttonFrame)
        #self.setCentralWidget(self.mainFrame)
        
        BrowserWindow = QWebView()
        BrowserWindow.load(QUrl(authurl))
        BrowserWindow.show()
        
#        BrowserWindow.page().setLinkDelegationPolicy(QWebPage.DelegateAllLinks)
#        BrowserWindow.connect(self,
#                     SIGNAL("loadFinished(bool)"),
#                     self.loadfinished)
        
#        self.connect(self,
#                     SIGNAL("linkClicked(const QUrl&)"),
#                     self.urlClicked)

        self.formLayout=QFormLayout(self)
        self.formLayout.addRow(BrowserWindow)
                     
    def loadfinished(self, strOK):
        print "debug!loadfinished!"
        print strOK

        self.formLayout=QFormLayout(self)
        self.formLayout.addRow(BrowserWindow)
        
        
class SettingForm(QDialog):
    def __init__(self, parent=None, settings=None):
        super(SettingForm, self).__init__(parent)
        self.setWindowTitle(unicode("微博设置"))

        #self.setFixedHeight(400)
                
        self.InputUpdateNum = QLineEdit(self)
        self.InputUpdateNum.setObjectName("InputUpdateNum")
        if settings["updatenum"] == "None":
            settings["updatenum"] = "10"
        self.InputUpdateNum.setText(settings["updatenum"])
        self.label_updatenum = QLabel(unicode("每次更新条数："))
        #self.label_updatenum.setWordWrap(True)
        #self.InputUpdateNum.setFixedHeight(50)
        #self.label_updatenum.setFixedHeight(60)
        
        self.InputUpdateInterval = QLineEdit(self)
        self.InputUpdateInterval.setObjectName("InputUpdateInterval")
        if settings["updateinterval"] == "None":
            settings["updateinterval"] = "3"        
        self.InputUpdateInterval.setText(settings["updateinterval"])   
        self.label_front = QLabel(unicode("  使用时"))     
        self.InputUpdateInterval2 = QLineEdit(self)
        self.InputUpdateInterval2.setObjectName("InputUpdateInterval2")
        if settings["updateinterval2"] == "None":
            settings["updateinterval2"] = "10"               
        self.InputUpdateInterval2.setText(settings["updateinterval2"])
        self.label_background = QLabel(unicode("分钟,  后台"))
        self.label_front.setContentsMargins(0,0,0,0) 
        self.InputUpdateInterval2.setContentsMargins(0,0,0,0) 
        self.label_background.setContentsMargins(0,0,0,0) 
        self.label_front.setContentsMargins(0,0,0,0) 


        #self.label_minute0 = QLabel(unicode("分钟, "))   
        self.label_minute2 = QLabel(unicode("分钟"))  
        self.label_minute2.setContentsMargins(0,0,0,0)   
        
        self.intervelFrame=QFrame()
        self.intLayout=QHBoxLayout(self.intervelFrame)
        self.intLayout.addWidget(self.label_front)
        self.intLayout.addWidget(self.InputUpdateInterval)
        self.intLayout.addWidget(self.label_background)
        self.intLayout.addWidget(self.InputUpdateInterval2)
        self.intLayout.addWidget(self.label_minute2)
        self.intervelFrame.setFixedHeight(60)
        self.intLayout.setContentsMargins(0,0,0,0)   
        self.intLayout.setSpacing(0)
        self.intLayout.setAlignment(Qt.AlignBottom)
        
        self.label_update_interval = QLabel(unicode("新消息更新间隔:"))
        self.label_update_interval.setFixedHeight(60)
        #self.label_updatenum.setFixedHeight(60)
        
        self.radiogroup = QGroupBox(self)        
        self.label_radio = QRadioButton(unicode("下载图片及头像"), self.radiogroup)
        if settings["downpic"]=="True":
            self.label_radio.setChecked(True)
        else:
            self.label_radio.setChecked(False)
        self.label_downpic = QLabel(unicode("是否下载图片："))
        self.label_downpic.setFixedHeight(60)
        self.label_radio.setFixedSize(225,60)        
        self.rg_auto_down_orgpic = QGroupBox(self)        
        self.label_auto_down_orgpic = QRadioButton(unicode("下载原始图片"), self.rg_auto_down_orgpic)
        if settings["down_orgpic"]=="True":
            self.label_auto_down_orgpic.setChecked(True)
        else:
            self.label_auto_down_orgpic.setChecked(False)
        self.label_auto_down_orgpic.setFixedSize(225,60)  
        #self.label_auto_down_orgpic = QLabel(unicode("自动下载原始图片"))
        #self.label_auto_down_orgpic.setFixedHeight(60)
        #self.label_radio.setFixedSize(450,60)
        
        self.buttonPicFrame=QFrame()
        self.btnPicLayout=QHBoxLayout(self.buttonPicFrame)
        self.btnPicLayout.addWidget(self.radiogroup)
        self.btnPicLayout.addWidget(self.rg_auto_down_orgpic)
        self.btnPicLayout.setContentsMargins(0,0,0,0)   
        self.btnPicLayout.setSpacing(0)
        self.buttonPicFrame.setFixedSize(450,70)

        
            
        self.radiogroup1 = QGroupBox(self)        
        self.label_radio1 = QRadioButton(unicode("允许程序在后台运行"), self.radiogroup1)
        if settings["background"]=="True":
            self.label_radio1.setChecked(True)
        else:
            self.label_radio1.setChecked(False)
        self.label_mode = QLabel(unicode("后台模式:"))
        self.label_mode.setFixedHeight(60)
        self.label_radio1.setFixedSize(450,60)
        #self.radiogroup1.setSizePolicy(QSizePolicy(QSizePolicy.Preferred,QSizePolicy.Preferred))
            
        self.rg_sms_style1 = QGroupBox(self)        
        self.radio_led = QRadioButton(unicode("LED"), self.rg_sms_style1) 
        if settings["notify_led"]=="True":
            self.radio_led.setChecked(True)
        else:
            self.radio_led.setChecked(False)            
        self.rg_sms_style2 = QGroupBox(self)        
        self.radio_vibra = QRadioButton(unicode("Vibra"), self.rg_sms_style2) 
        if settings["notify_vibra"]=="True":
            self.radio_vibra.setChecked(True)
        else:
            self.radio_vibra.setChecked(False)            
        self.rg_sms_style3 = QGroupBox(self)        
        self.radio_sound = QRadioButton(unicode("Sound"), self.rg_sms_style3) 
        if settings["notify_sound"]=="True":
            self.radio_sound.setChecked(True)
        else:
            self.radio_sound.setChecked(False)
        self.radio_led.  setFixedHeight(60)
        self.radio_vibra.setFixedHeight(60)
        self.radio_sound.setFixedHeight(60)
        
        self.radio_led.setFixedWidth(150)
        self.radio_vibra.setFixedWidth(150)
        self.radio_sound.setFixedWidth(150)
        
        
        #self.rg_sms_style1.setContentsMargins(0,0,0,0)  
        #self.rg_sms_style2.setContentsMargins(0,0,0,0)  
        #self.rg_sms_style3.setContentsMargins(0,0,0,0)  
        #self.radio_led.setContentsMargins(0,0,0,0)  
        #self.radio_vibra.setContentsMargins(0,0,0,0)  
        #self.radio_sound.setContentsMargins(0,0,0,0)  
        
        self.buttonFrame=QFrame()
        self.btnLayout=QHBoxLayout(self.buttonFrame)
        self.btnLayout.addWidget(self.rg_sms_style1)
        self.btnLayout.addWidget(self.rg_sms_style3)
        self.btnLayout.addWidget(self.rg_sms_style2)
        self.btnLayout.setContentsMargins(0,0,0,0)   
        self.btnLayout.setSpacing(0)
#        self.btnLayout.setAlignment(Qt.AlignVCenter)
        self.label_sms = QLabel(unicode("新消息通知方式:"))
        self.label_sms.setFixedHeight(60)
        
        import conic 

        connection = conic.Connection()
        self.cb_connection =QComboBox(self)
        iaps = connection.get_all_iaps()
        self.cb_connection.insertItem(0, "(不启用)", QVariant("---None---"))
        index = 1
        for i in iaps:
            print "%s - %s type %s" % (i.get_name(), i.get_id(), i.get_bearer_type())
            self.cb_connection.insertItem(index,i.get_name(),QVariant(i.get_id()))
            index = index + 1
        self.cb_connection.model().sort(0)  
        
        if settings["auto_conn"] is None:
            self.cb_connection.setCurrentIndex(0)
        else:
            for i in range(self.cb_connection.count()):
                self.cb_connection.setCurrentIndex(i)
                if self.cb_connection.itemData(self.cb_connection.currentIndex())==QVariant(settings["auto_conn"]):
                    break
        self.label_conn = QLabel(unicode("更新时自动连接: "))

        self.mainFrame=QFrame()
        self.formLayout=QFormLayout(self.mainFrame)
        #sself.formLayout.setAlignment(Qt.AlignVCenter|Qt.AlignTop)
        self.formLayout.addRow(self.label_updatenum, self.InputUpdateNum)
        self.formLayout.addRow(self.label_downpic, self.buttonPicFrame)
        self.formLayout.addRow(self.label_mode, self.radiogroup1)
        self.formLayout.addRow(self.label_update_interval, self.intervelFrame)
        self.formLayout.addRow(self.label_conn, self.cb_connection)
        self.formLayout.addRow(self.label_sms, self.buttonFrame)
        self.formLayout.setVerticalSpacing(5)
        self.formLayout.setAlignment(Qt.AlignBottom)
        #self.formLayout.setRowWrapPolicy(QFormLayout.WrapAllRows)
        
        self.confirmButton = QPushButton(unicode("确定"))
        self.cancelButton = QPushButton(unicode("取消"))
        #self.confirmButton.setFixedWidth(150)
        #self.cancelButton.setFixedWidth(150)
        
        self.connect(self.cancelButton,
                     SIGNAL("clicked()"),
                     self.hide)
        
        
        self.buttonFrame=QFrame()
        self.buttonFormLayout=QFormLayout(self.buttonFrame)
        self.buttonFormLayout.setAlignment(Qt.AlignBottom)
        self.buttonFormLayout.addRow(self.confirmButton)
        self.buttonFormLayout.addRow(self.cancelButton)
                
        #self.buttonFrame.setLayout(self.buttonFormLayout)
        
        '''
        #self.bossFrame=QFrame(sed)
        self.outerLayout = QGridLayout(self)
        self.outerLayout.setObjectName("outerLayout")
        self.outerLayout.addWidget(self.mainFrame,0,0)
        self.outerLayout.addWidget(self.buttonFrame,0,1)
        self.outerLayout.setAlignment(Qt.AlignBottom)
        self.outerLayout.setContentsMargins(0,0,0,0)  
        #self.setCentralWidget(self.bossFrame)
        '''
        
        self.outerLayout=QHBoxLayout(self)
        self.outerLayout.addWidget(self.mainFrame)
        self.outerLayout.addWidget(self.buttonFrame)
        self.outerLayout.setAlignment(self.buttonFrame,Qt.AlignBottom)
        self.outerLayout.setContentsMargins(0,0,0,0)   
        self.outerLayout.setSpacing(0)
        
    def validate(self,callback):
        if self.InputUpdateNum.text() is None or self.InputUpdateNum.text()=="":
            callback(unicode("请输入每次更新微博条数！"))
            return 0
            
        inputnum = int(self.InputUpdateNum.text())
        if inputnum < 5 or inputnum > 50:
            callback(unicode("请输入5-50之间的数字！"))
            return 0
            
        return 1

    def output_account(self,callback):
        if self.validate(callback):
            self.setting = {}
            self.setting["updatenum"]=str(self.InputUpdateNum.text())
            self.setting["updateinterval"]=str(self.InputUpdateInterval.text())
            self.setting["updateinterval2"]=str(self.InputUpdateInterval2.text())
            self.setting["downpic"]=str(self.label_radio.isChecked())
            self.setting["down_orgpic"]=str(self.label_auto_down_orgpic.isChecked())
            self.setting["background"]=str(self.label_radio1.isChecked())
            self.setting["notify_led"]=str(self.radio_led.isChecked())
            self.setting["notify_vibra"]=str(self.radio_vibra.isChecked())
            self.setting["notify_sound"]=str(self.radio_sound.isChecked())
            self.setting["auto_conn"] = str(self.cb_connection.itemData(self.cb_connection.currentIndex()).toString())
            
            return self.setting
        else:
            return None

class AboutForm(QDialog):
    def __init__(self, parent=None):
        super(AboutForm, self).__init__(parent)
        self.setWindowTitle(unicode("关于"))
        self.aboutLabel=QLabel()
        st="""<b>maebo</b>
            <p>  Nokia N900 微博客户端(新浪+腾讯)
            <p>  版本号 %s  最后修订 %s
            <p>  原作者 %s
            <p>  二次开发 %s
            <p>  联系邮箱 %s
            <p>  Python %s - Qt %s
            <p>  PyQt %s""" % (
                          __version__, __build__,
                          __author__, __modify__, __email__,
                          platform.python_version(),
                          QT_VERSION_STR, PYQT_VERSION_STR)
        self.aboutLabel.setText(st)
        self.formLayout=QFormLayout(self)
        self.formLayout.addRow(self.aboutLabel)


class DefaultWindow(QMainWindow):
    def __init__(self, parent=None, accounts=None, websites=None , orientation=0):
        super(DefaultWindow, self).__init__(parent)
        self.setWindowTitle("Maebo")
        
        self.orientation=orientation
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        
        st="""
            <div style="color:#444;padding-left:10px;">
                欢迎您使用 <b>Maebo</b>！<br />
                Maebo是一款支持腾讯及新浪微博的手机客户端程序。<br />
                该客户端专为Nokia N900 Maemo系统量身定做开发。<br />
                在此特别感谢dospy.com论坛N900专区各位机友的长期支持。<br />
                如果您在Maebo使用过程中遇到问题，可以前往dospy论坛N900专区；<br />
                或者收听我的微博 t.qq.com/bink  weibo.com/binkcn 向我反馈。<br /><br />
                <b>请点击顶部菜单开始添加绑定您的微博账户。</b><br />
            </div>
            """
        self.aboutLabel=QLabel()
        self.aboutLabel.setText(st)
        
        self.setCentralWidget(self.aboutLabel)
        self.centralWidget().setStyleSheet("background-color: "+Utils.COLOR_BACKGROUND);
        
        self.setFixedSize(800,480)


#class LogWindow(QMainWindow):
#    def __init__(self, parent=None):
#        super(LogWindow, self).__init__(parent)
#        self.setAttribute(Qt.WA_Maemo5StackedWindow)
#        self.setWindowTitle(unicode("N3DR-日志"))
#        self.textEdit=QPlainTextEdit()
#        self.textEdit.setReadOnly(True)
#        self.setCentralWidget(self.textEdit)
#
#    def write(self,text):
#        tc=self.textEdit.textCursor()
#        tc.movePosition(QTextCursor.End)
#        self.textEdit.setTextCursor(tc)
#        self.textEdit.appendHtml(unicode(text))
