# -*- coding: utf-8 -*-
import logging
from weibopy.error import WeibopError

__author__="Michael"
__date__ ="$2011-9-1$"

from weibopy.auth import OAuthHandler, BasicAuthHandler
from weibopy.api import API
from Logger import Logger
from Writer import Writer
from Downloader import Downloader
from PyQt4.QtCore import *
import Utils
import os

APP_KEY="475214689"
APP_SECRET="f9b9d4850089e3b95a5c3e6e1d17bed5"

class UpdaterSina(QThread):
    def __init__(self,callback,parent=None):
        super(UpdaterSina, self).__init__(parent)
        self.logger = logging.getLogger('UpdaterSina')
        self.stopped = False
        self.mutex = QMutex()
        self.completed = False
#        self.logger =logger
        self.writer = Writer()
        self.downloader = Downloader()
        self.callback=callback
        self.logger.debug("UpdaterSina:__init__")

    def basicAuth(self, source, username, password):
        self.auth = BasicAuthHandler(username, password)
        self.api = API(self.auth,source=source)

    def OAuth(self, username, password):
        #self.auth = OAuthHandler(APP_KEY,APP_SECRET)
        #auth_url = self.auth.get_authorization_url()
        #print 'Please authorize: ' + auth_url
        #verifier = raw_input('PIN: ').strip()
        #self.auth.get_access_token(verifier)
        #self.api = API(self.auth)
        
        self.auth = OAuthHandler(APP_KEY,APP_SECRET)
        self.auth.setToken(username, password)
        self.api = API(self.auth)

    def initialize(self, accountId,timelineType,sinceId=None,maxId=None):
        self.logger.debug("UpdaterSina:initialize")
        self.stopped = False
        self.accountId=accountId
        self.timelineType=timelineType
        self.sinceId=sinceId
        self.maxId=maxId
        self.completed = False
        self.timeline = []


    def stop(self):
        try:
            self.mutex.lock()
            self.stopped = True
        finally:
            self.mutex.unlock()


    def is_stopped(self):
        try:
            self.mutex.lock()
            return self.stopped
        finally:
            self.mutex.unlock()

    def run(self):
        self.logger.debug("run")
        try:
            self.update_timeline(self.sinceId,self.maxId)
        except WeibopError,we:
            self.completed=False
            self.emit(SIGNAL("finished(bool)"),self.completed)
            self.emit(SIGNAL("show_notice(QString,int)"),we.reason,0)
        self.stop()


    def update_timeline(self,sinceId=None,maxId=None,countNum=20,pageNum=1):
        self.logger.debug("update_timeline")
        param={}
        param["count"]=countNum
        param["page"]=pageNum
        if sinceId!=None:
            param["since_id"]=sinceId
        if maxId!=None:
            param["max_id"]=maxId
        timeline=None
        if self.timelineType==Utils.TIMELINE_TYPE_FRIENDS:
            timeline = self.api.friends_timeline(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_DM:
            timeline = self.api.direct_messages(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_MENTIONS:
            timeline = self.api.mentions(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_COMMENTS:
            timeline = self.api.comments_timeline(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_FAVOUR:
            param={}
            param["source"]=APP_KEY
            param["id"]=1863105202
            timeline = self.api.favorites(**param)

        if timeline!=None:
            for line in timeline:
                status=Utils.build_a_status_from_obj(line,self.accountId)
                self.timeline.append(status)
                thumbnail=status["thumbnail_pic"]
                if thumbnail!=None:
                    filename=thumbnail.split("/")[-1]
                    picFilename=Utils.THUMBNAIL_DIR+str(self.accountId)+"_"+str(status["id"])+"_"+filename
                    if os.access(picFilename, os.W_OK) == 0:
                        picSource=self.downloader.download(thumbnail)
                        self.writer.write_to(picFilename, picSource)
                user=status["user"]
                
                avatar=user["profile_image_url"]
#                print avatar
                if avatar!=None:
                    picFilename=Utils.AVATAR_DIR+str(self.accountId)+"_"+str(user["id"])
                    if os.access(picFilename, os.W_OK) == 0:
                        picSource=self.downloader.download(avatar)
                        self.writer.write_to(picFilename, picSource)

                rtStatus=status["retweeted_status"]
                if rtStatus!=None:
                    rtUser=rtStatus["user"]
                    rtAvatar=rtUser["profile_image_url"]
                    if rtAvatar!=None:
                        picFilename=Utils.AVATAR_DIR+str(self.accountId)+"_"+str(rtUser["id"])
                        if os.access(picFilename, os.W_OK) == 0:
                            picSource=self.downloader.download(rtAvatar)
                            self.writer.write_to(picFilename, picSource)
                    rtThumbnail=rtStatus["thumbnail_pic"]
                    if rtThumbnail!=None:
                        filename=rtThumbnail.split("/")[-1]
                        picFilename=Utils.THUMBNAIL_DIR+str(self.accountId)+"_"+str(rtStatus["id"])+"_"+filename
                        if os.access(picFilename, os.W_OK) == 0:
                            picSource=self.downloader.download(rtThumbnail)
                            self.writer.write_to(picFilename, picSource)

        self.completed = True
        self.emit(SIGNAL("finished(bool)"),self.completed)
        self.logger.info("update completed!")


class SenderSina(QThread):
    def __init__(self,callback,parent=None):
        super(SenderSina, self).__init__(parent)
        self.logger = logging.getLogger('SenderSina')
        self.stopped = False
        self.mutex = QMutex()
        self.completed = False
        self.callback=callback
#        self.logger =logger
#        self.writer = Writer()
#        self.downloader = Downloader()
        self.logger.debug("SenderSina:__init__")


    def basicAuth(self, source, username, password):
        self.auth = BasicAuthHandler(username, password)
        self.api = API(self.auth,source=source)

    def OAuth(self, token, tokenSecret):
        self.auth = OAuthHandler(APP_KEY,APP_SECRET)
        self.auth.setToken(token, tokenSecret)
        self.api = API(self.auth)

    def initialize(self, accountId,param):
        self.logger.debug("SenderSina:initialize")
        self.stopped = False
        self.accountId=accountId
        self.param=param
        self.completed = False

    def stop(self):
        try:
            self.mutex.lock()
            self.stopped = True
        finally:
            self.mutex.unlock()


    def is_stopped(self):
        try:
            self.mutex.lock()
            return self.stopped
        finally:
            self.mutex.unlock()

    def run(self):
        self.logger.debug("run")
        try:
            self.send(self.param)
        except WeibopError,we:
            self.completed=False
            self.emit(SIGNAL("finished(bool)"),self.completed)
            self.emit(SIGNAL("show_notice(QString,int)"),we.reason,0)
        self.stop()


    def send(self, param):
        self.logger.debug("sending")
        param["source"]=APP_KEY
        self.logger.debug(param)
        timelineType=param["timelineType"]
        if timelineType==None:
            self.logger.debug("send a normal msg")
#            if hasattr(param, 'pic'):
            try:
                pic=str(param["pic"])
                self.logger.debug("with a picture:"+pic)
                status=self.api.upload(pic,str(param["status"]),None,None,param["source"])
            except KeyError,ae:
#            else:
                self.logger.error(os.sys.exc_info()[0])
                self.logger.debug(ae)
                self.logger.debug("just a text msg")
                status=self.api.update_status(**param)
        elif timelineType==Utils.TIMELINE_TYPE_MENTIONS:
            self.logger.debug("send a rt")
            #rt
            status=self.api.repost(**param)
        elif timelineType==Utils.TIMELINE_TYPE_COMMENTS:
            #comment
            self.logger.debug("send a comment")
            status=self.api.comment(**param)
        elif timelineType==Utils.TIMELINE_TYPE_DM:
            #dm
            self.logger.debug("send a dm")
            status=self.api.new_direct_message(**param)
        self.completed = True
        self.emit(SIGNAL("finished(bool)"),self.completed)
        self.logger.info("sending completed!")

