#ifndef _PROCESS_RUNNER_H_
#define _PROCESS_RUNNER_H_

#include <QObject>
#include <QByteArray>
#include <QProcess>

class QString;
class QStringList;

class ProcessRunner : public QObject
{
	Q_OBJECT
public:
	ProcessRunner();
	~ProcessRunner();

	int start(const QString &name, const QStringList &args);
	QByteArray& getStdout(void);
	QByteArray& getStderr(void);

signals:
	void finished(int exitCode);

private slots:
	void complete(int exitCode, QProcess::ExitStatus exitStatus);
	void bufferStdout(void);
	void bufferStderr(void);

private:
	QProcess *m_proc;
	QByteArray m_stdout;
	QByteArray m_stderr;
	Q_DISABLE_COPY(ProcessRunner);
};
#endif
