#ifndef _EDIT_INTERFACE_H_
#define _EDIT_INTERFACE_H_

#include <QWidget>

class QGridLayout;
class QCheckBox;
class QPushButton;
class QLabel;
class QLineEdit;

class MainWindow;
class ProcessRunner;

class EditInterface : public QWidget
{
	Q_OBJECT
public:
	EditInterface(MainWindow *main, ProcessRunner *runner);

public slots:
	void configure(void);

private slots:
	void toggleDhcp(int state);
	void toggleRoute(int state);

private:
	MainWindow *m_main;
	ProcessRunner *m_runner;

	QGridLayout *m_layout;
	QCheckBox *m_dhcp;
	QCheckBox *m_route;
        QPushButton *m_configure;
	QPushButton *m_cancel;
	QLabel *m_ipaddress;
	QLabel *m_netmask;
	QLineEdit *m_iptxt;
	QLineEdit *m_masktxt;
	QLineEdit *m_gwtxt;
};
#endif
