#if 0 /* -*- mode: c; c-file-style: "stroustrup"; tab-width: 8; -*-
 set -e; TRG=`basename $0 .c`; rm -f "$TRG"
 WARN="-Wall -Wstrict-prototypes -pedantic -Wno-long-long"
 WARN="$WARN -Wcast-align -Wpointer-arith " # -Wfloat-equal #-Werror
 WARN="$WARN -W -Wwrite-strings -Wcast-qual -Wshadow" # -Wconversion
 date=`date`; set -x
 #${CC:-gcc} -ggdb $WARN "$@" -o "$TRG" "$0"
 ${CC:-gcc} -s -O2 $WARN "$@" -o "$TRG" "$0"
 exit 0
 */
#endif
/*
 * $Id; devrootsh.c $
 *
 * Author: Tomi Ollila -- too ät iki piste fi
 *
 *	Copyright (c) 2009 Tomi Ollila
 *	    All rights reserved
 *
 * Created: Thu Nov 29 17:12:36 EET 2007 too
 * Last modified: Mon 28 Dec 2009 10:16:22 EET too
 */

/*
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * condition:
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#include <unistd.h>
#if 1
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

int main(int argc, char * argv[])
{
    const char * cmd;
    char ** args, sh[4];

    if (argc == 2 && argv[1][0] == '-') {
        fprintf(stderr, "\nUsage: %s [[-a arg0] cmd [args...]]\n\n", argv[0]);
        return 1;
    }
    if (argc > 2 && strcmp(argv[1], "-a") == 0) {
        cmd = argv[3]; argv[3] = argv[2]; args = argv + 3;
    }
    else {
        cmd = argv[1]; args = argv + 1;
    }
    if (setenv("PATH", "/bin:/usr/bin:/sbin:/usr/sbin", 1) < 0) {
	perror("setenv"); return 1;
    }
    if (cmd == NULL) {
        cmd = getenv("SHELL");
        if (cmd == NULL ||
            (/**/ strcmp(cmd, "/bin/bash") != 0
             &&   strcmp(cmd, "/bin/ksh")  != 0
             &&   strcmp(cmd, "/bin/zsh")  != 0))
            cmd = "/bin/sh";

        strcpy(sh, "-sh"); argv[0] = sh; argv[1] = NULL; args = argv;
    }
    if (geteuid() == 0) {
	setuid(0);
	setgid(0);
    }
    execvp(cmd, args);
    perror(cmd);
    return 1;
}

#else
/* launchshell.c version 0 */
int main(int argc, char * const argv[])
{
    extern char ** environ;
    argv[0][0] = '-'; argv[0][1] = 's'; argv[0][2] = 'h'; argv[0][3] = 0;
    return execve("/bin/sh", argv, environ);
}
#endif
