/*
 * This file is part of M3-Weather program
 * This is header file of thread class
 *
 * Copyright (C) 2010 - Ivan Galov
 * Petrozavodsk State University
 *
 * M3-Weather program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * M3-Weather program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with M3-Weather program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#ifndef MYTHREAD_H
#define MYTHREAD_H

#define CONFIG_FILENAME "/.m3w-client.conf"

#include <QThread>
#include <QDebug>
#include <QFile>
#include <QStringList>
#include <QProcess>
#include "kpi_low.h"
#include <qnetworksession.h>
#include <qnetworkconfigmanager.h>

QTM_USE_NAMESPACE

class MyWidget;

class SibThread: public QThread
{

	Q_OBJECT

signals:
	void indication();
	void updateCity(QString);
	void updateTemp(QString);
	void updateIcon(QString);
	void updateCaption(QString);
	void startGPS();

public:
	SibThread(QWidget *parent=0);
	~SibThread();
    void run();
	ss_info_t ss_info;
	ss_subs_info_t subs_info;
	QString ip;
	QString uuid;
	QNetworkSession* session;

private:
	MyWidget *mv;
	
	
};

#endif
