/*
 * This file is part of M3-Weather program
 * This is source file of widget
 *
 * Copyright (C) 2010 - Ivan Galov, Anna Samoryadova
 * Petrozavodsk State University
 *
 * M3-Weather program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * M3-Weather program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with M3-Weather program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#include "mywidget.h"
#include "settingsdialog.h"
#include "thread.h"

/* widget object */
MyWidget::MyWidget(QWidget *parent) : QWidget(parent)
{	
	layout = new QVBoxLayout;
	layout1 = new QVBoxLayout;
	layout2 = new QHBoxLayout;
	layout3 = new QVBoxLayout;

	/* set fonts */
	QSize size(100, 100);
	QSize gps_size(40, 40);
	QFont tmpFont("Bitstream Charter", 30);
	QFont tFont("Bitstream Charter", 15);
	QFont cityFont("Bitstream Charter", 25);
	
	/* create city label and configure it */
	city = new QLabel(this);
	city->setFont(cityFont);	
	city->setText(trUtf8("N/A"));
	city->setAlignment(Qt::AlignCenter);

	/* create image button and configure it */
	but = new QPushButton(this);
	but->setFlat(true);
	but->setIconSize(size);
	//but->setIcon(QIcon(QString(IMG_PATH) + "32.png"));
	
	/* create temperature label and configure it */
	tmp = new QLabel(this);
	tmp->setFont(tmpFont);
	tmp->setText(trUtf8("N/A"));
	tmp->setAlignment(Qt::AlignCenter);

	/* create caption label and configure it */
	t = new QLabel(this);
	t->setFont(tFont);	
	t->setText(trUtf8("N/A"));
	t->setAlignment(Qt::AlignCenter);	

	/* create GPS button and configure it */
	gps_but = new QPushButton(this);
	gps_but->setFlat(true);
	gps_but->setIconSize(gps_size);
	gps_but->setIcon(QIcon(QString(IMG_PATH) + "GPS-ON.png"));

	layout1->addWidget(but);
	layout1->addWidget(t);

	layout3->addWidget(tmp);
	layout3->addWidget(gps_but);

	layout2->addItem(layout1);
	layout2->addItem(layout3);	

	layout->addWidget(city);
	layout->addItem(layout2);

	setLayout(layout);
	setAttribute(Qt::WA_TranslucentBackground);

	gps = false;

	QObject::connect(but, SIGNAL(clicked()), this, SLOT(indication()));
	QObject::connect(gps_but, SIGNAL(clicked()), this, SLOT(changeGPS()));
	
	
	if(!checkConfig())
		makeConfig();
	
	startGPS();
	QNetworkConfigurationManager manager;
        const bool canStartIAP = (manager.capabilities() & QNetworkConfigurationManager::CanStartAndStopInterfaces);

   	cfg = manager.defaultConfiguration();
        if (!cfg.isValid() || (!canStartIAP && cfg.state() != QTM_PREPEND_NAMESPACE(QNetworkConfiguration)::Active)) 			qDebug() << "Network error";

    session = new QNetworkSession(cfg, this);

	connect(session, SIGNAL(stateChanged(QNetworkSession::State)),this, SLOT(stateChanged()));

    session->open();
	
	

	//s = new SibThread(this);
/*
	QObject::connect(&s, SIGNAL(indication()),this, SLOT(indication()));
	QObject::connect(&s, SIGNAL(updateCity(QString)),this, SLOT(updateCity(QString)));
	QObject::connect(&s, SIGNAL(updateTemp(QString)),this, SLOT(updateTemp(QString)));
	QObject::connect(&s, SIGNAL(updateIcon(QString)),this, SLOT(updateIcon(QString)));
	QObject::connect(&s, SIGNAL(updateCaption(QString)),this, SLOT(updateCaption(QString)));
	QObject::connect(&s, SIGNAL(startGPS()),this, SLOT(startGPS()));
*/
	//s->start();
	//s.start();
}


MyWidget::~MyWidget()
{
	stopGPS();
	//s->terminate();
	delete s;
}

/* drawing widget */
void MyWidget::paintEvent(QPaintEvent *event)
{
	/* set color of lines */
	QPainter p(this);
	p.setBrush(QColor(0, 0, 0, 128));
	p.setPen(Qt::NoPen);
	
	/* set geometry of widget */
	p.drawRect(0, 0, this->size().width(), this->size().height());
	
	p.end();

	/* painting */
	QWidget::paintEvent(event);
} 

void MyWidget::indication()
{
update();
}

void MyWidget::updateCity(QString name)
{
	city->setText(name);
	//update();
}

void MyWidget::updateTemp(QString temp)
{
	if (temp == "N/A")	
		tmp->setText(temp);
	else
		tmp->setText(temp + trUtf8("° C"));
	//update();
}

void MyWidget::updateIcon(QString icon)
{
	but->setIcon(QIcon(QString(IMG_PATH) + icon + ".png"));
	//update();
}

void MyWidget::updateCaption(QString caption)
{
	t->setText(caption);
	//update();
}

void MyWidget::startGPS()
{
	if (gps == false) {
		gps_but->setIcon(QIcon(QString(IMG_PATH) + "GPS-ON.png"));
		gps = true;
		qDebug() << "START GPS";
		gpsc.start("m3w-gps");
	}
	
}

void MyWidget::stopGPS()
{
	gps = false;
	gps_but->setIcon(QIcon(QString(IMG_PATH) + "GPS-OFF.png"));
	qDebug() << "STOP GPS";
	gpsc.terminate();
	//gpsc.waitForReadyRead(1000);
	gpsc.waitForFinished(1000);
	//qDebug() << gpsc.readAllStandardOutput().data();
}

void MyWidget::changeGPS()
{
	if(gps) {
		stopGPS();
	}
	else {
		startGPS();
	}
}

void MyWidget::showSettingsDialog()
{
	qDebug() << "!!!!!!!!";
	SettingsDialog* s = new SettingsDialog(this);  		
    
}

bool MyWidget::checkGPS()
{
	return gps;
}

void MyWidget::stateChanged()
{
switch (session->state()) {
     case QNetworkSession::Invalid:
         qDebug() << "Invalid";
         break;
     case QNetworkSession::NotAvailable:
         qDebug() << "Not Available";
         break;
     case QNetworkSession::Connecting:
         qDebug() << "Connecting";
	 	 startGPS(); 
	 	 restartConnection();	
         break;
     case QNetworkSession::Connected:
         qDebug() <<"Connected";
         break;
     case QNetworkSession::Closing:
         qDebug() <<"Closing";
	 	 //delete s;	
	 	 stopGPS();	
         break;
     case QNetworkSession::Disconnected:
         qDebug() <<"Disconnected";
		 
		 session = new QNetworkSession(cfg, this);
		 connect(session, SIGNAL(stateChanged(QNetworkSession::State)),this, SLOT(stateChanged()));		
         break;
     case QNetworkSession::Roaming:
         qDebug() <<"Roaming";
         break;
     default:
         qDebug() <<"Unknown";
     }

}
void MyWidget::restartConnection()
{
	qDebug() << "restarting connection";
	//session->open();
	startGPS(); 
	delete s;
	s = new SibThread(this);
	s->start();
}

void MyWidget::stopConnection()
{
	qDebug() << "stoping connection";
	stopGPS();
/*
	QNetworkConfigurationManager manager;
        const bool canStartIAP = (manager.capabilities() & QNetworkConfigurationManager::CanStartAndStopInterfaces);

   	QTM_PREPEND_NAMESPACE(QNetworkConfiguration) cfg = manager.defaultConfiguration();
        if (!cfg.isValid() || (!canStartIAP && cfg.state() != QTM_PREPEND_NAMESPACE(QNetworkConfiguration)::Active)) 			qDebug() << "Network error";

        session = new QNetworkSession(cfg, this);
*/
}
	
bool MyWidget::checkConfig()
{
QFile defaultfile("/usr/share/m3w-server.conf");
QFile homefile(QDir::homePath() + CONFIG_FILENAME);
QString line;
QStringList list;
QStringList list2;
bool ipflag = false;
bool uuidflag = false;

if (homefile.open (QIODevice::ReadOnly)){
	printf("Finded in /home\n");	
	QTextStream stream ( &homefile );
    while ((line = stream.readLine()) != NULL) {
		list = line.split("=", QString::SkipEmptyParts);

		if (list.first() == NULL) {
			homefile.close();
			return false;
		}

		if (list.count() <= 1) {
			homefile.close();
			return false;
		}

		if (list.at(1) == "") {
			homefile.close();
			return false;
		}

		if(list.first() == "ip") {
			if(!ipflag) {
				ip = list.at(1);
				ipflag = true;
			}
		}

		if(list.first() == "id") {
			if(!uuidflag) {
				uuid = list.at(1);
				uuidflag = true;
			}
		}

		qDebug() << "!";
	}
}

if (!(ipflag && uuidflag)) {
	homefile.close();
	return false;
}

qDebug() << ip;
qDebug() << uuid;
homefile.close();
return true;

}

void MyWidget::makeConfig()
{
QFile defaultfile("/usr/share/m3w-server.conf");
QFile homefile(QDir::homePath()+ CONFIG_FILENAME);
QString line;
QStringList list;
homefile.remove();
defaultfile.copy(homefile.fileName());

QProcess q;

if(homefile.open (QIODevice::Append)) {
	QTextStream stream ( &homefile );

	q.start("uuidgen");
    
    q.waitForStarted(1000);
	q.waitForReadyRead(1000);

	stream << "id=";
	stream << q.readAllStandardOutput().data();
	q.waitForFinished();
	q.terminate();
	homefile.close();

	if (homefile.open (QIODevice::ReadOnly)){
		QTextStream stream2 ( &homefile );
		line = stream.readLine();
		list = line.split("=", QString::SkipEmptyParts);
		ip = list.at(1);

		line = stream.readLine();
		list = line.split("=", QString::SkipEmptyParts);
		uuid = list.at(1);
		homefile.close();	
	}

	qDebug() << ip;
	qDebug() << uuid;

}
}

QString MyWidget::getIP()
{
	return ip;
}

QString MyWidget::getID()
{
	return uuid;
}

QNetworkSession* MyWidget::getSession()
{
	return session;
}

void MyWidget::setIP(QString l_ip)
{
	ip = l_ip;
}

void MyWidget::setID(QString l_id)
{
	uuid = l_id;
}

