/*
 * Copyright (C) 2009 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of libzeemote.
 *
 * libzeemote is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libzeemote is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libzeemote.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef ZEEMOTE_H
#define ZEEMOTE_H

#include <bluetooth/bluetooth.h>
#include <pthread.h>

/* supported zeemote devices */
#define ZEEMOTE_JS1          0

/* currently up to 4 buttons are supported */
#define ZEEMOTE_BUTTON_A     (1<<0)
#define ZEEMOTE_BUTTON_B     (1<<1)
#define ZEEMOTE_BUTTON_C     (1<<2)
#define ZEEMOTE_BUTTON_D     (1<<3)
/* ... up to 32 buttons possible */

/* state the zeemote can be in */
#define ZEEMOTE_STATE_UNKNOWN           0
#define ZEEMOTE_STATE_CONNECTING        1
#define ZEEMOTE_STATE_CONNECTION_FAILED 2
#define ZEEMOTE_STATE_CONNECTED         3
#define ZEEMOTE_STATE_CONNECTION_LOST   4
#define ZEEMOTE_STATE_DISCONNECTED      5

typedef struct {
  int state;
  int axis[4];                // up to 4 axes
  unsigned long buttons;      // up to 32 buttons
  int battery;                // battery voltage in millivolts
} zeemote_state_t;

typedef struct {
  int type;                   // information about
  int num_axes, num_buttons;  // this device
} zeemote_info_t;

typedef struct zeemote {
  zeemote_info_t info;
  zeemote_state_t state[2];

  int refcount, fd;
  bdaddr_t bdaddr;
  struct zeemote *next;
  pthread_t thread;
  pthread_mutex_t mutex;

} zeemote_t;

typedef struct {
  int type;
  bdaddr_t bdaddr;
} zeemote_device_t;

typedef struct {
  int number_of_devices;
  zeemote_device_t device[0];
} zeemote_scan_result_t;

zeemote_scan_result_t *zeemote_scan(void);
zeemote_t *zeemote_connect(bdaddr_t *bdaddr);
void zeemote_disconnect(zeemote_t *zeemote);
zeemote_state_t *zeemote_get_state(zeemote_t *zeemote);
#define zeemote_get_info(zeemote) (&zeemote->info)

#endif
