TEMPLATE = app
TARGET = thumbnailertest-unit
DEFINES += TESTING_CODE
include(../../shared.pri)

OBJECTS_DIR = ../../src/.obj
MOC_DIR = ../../src/.moc

CONFIG += qt \
          qdbus \
          qtestlib

HEADERS += thumbtest.h \
           ../../src/*.h \
           ../../src/include/*.h \
           ../../src/dbus/*.h

SOURCES += thumbtest.cpp \
           ../../src/*.cpp \
           ../../src/dbus/*.cpp


#install
target.path =   $$PREFIX/bin
sources.files = $$SOURCES $$HEADERS thumbnailer-unit-tests.pro
INSTALLS += target

# install xml file describing tests
tests.path   = $$PREFIX/share/libthumbnailer0-tests
tests.commands = -/usr/bin/testhelper -d . -p libthumbnailer/tests -t /usr/bin -o ./tests.xml || echo "!!! using fixed tests.xml file !!!"
tests.files = ./tests.xml
tests.depends = FORCE

INSTALLS    += tests

coverage {
        # add flags to compiler
        LIBS += -lgcov
        QMAKE_CXXFLAGS += -ftest-coverage -fprofile-arcs -fno-elide-constructors
}

check.depends = $$TARGET install
check.commands = ./thumbnailertest-unit
QMAKE_EXTRA_TARGETS += check
