/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Contact: Marius Vollmer <marius.vollmer@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef THUMBTEST_H
#define THUMBTEST_H

#include <QObject>
#include <QString>
#include <QTest>

#include "../../src/include/Thumbnailer"
#include "../../src/thumbnailer_p.h"

#define myDebug() qDebug()
#define FUNC_STARTED static unsigned __count = 0; myDebug() << " started for the" << ++__count << "time."
#define FUNC_STOPPED myDebug() << " has stopped its" << __count-- << "execution."
#define FUNC_CALLED  FUNC_STARTED; FUNC_STOPPED

class ThumbTest : public QObject
{
Q_OBJECT
private:
	QMutex mutex;
	int counter;

private slots:

public Q_SLOTS:
	void thumbnailerStarted();
	void thumbnailerFinished();

// particular tests
private Q_SLOTS:
	/*
	   the naming scheme is: testedFunctionName_whatWeAreTesting[_data]
	   so if You want to test if after calling function request thumbnail signal is send
	   You can create slot with name: request_checkingThumbnailSignal()
	   The second part of the name should be self-explanatory (it should be easy to understand
	   what is tested in that function)

	   _data versions of slots are connected with QTestLib architecture, see:
	   http://doc.trolltech.com/4.5/qtestlib-manual.html and
	   http://doc.trolltech.com/4.5/qtest.html for more details.
	 */
	void request_simpleRequest();
};

#endif // THUMBTEST_H

