/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Contact: Marius Vollmer <marius.vollmer@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <utime.h>
#include "thumbtest.h"
#include <QFile>
#include <QUrl>
#include <QDebug>
#include <QDir>
#include <QFile>
#include <QSignalSpy>
#include <QTimer>

using namespace Thumbnails;

/*
 wait until spy will reach target number of signals; after that number is reached
 we can continue with verifying test's results. Thanks to that we do not need to wait always
 long time to be sure that tumbler replied - just give there finished spy and that should be
 working.

 maxTime is the maximum time we want to wait.

 NOTE: that macro could be placed only once in every block of the code and it is supposed
       to be put at max. only once in every test slot!
 NOTE: as a maxTime You need to put positive number
 */ 
#define WAIT_FOR_FINISH(spy,target,maxTime) static int _counter = 0; \
                                            while(spy.count()<target && _counter <= maxTime/1000) { \
                                                  ++_counter; QTest::qWait(1000); \
                                            }

void  ThumbTest::thumbnailerFinished() {
	//mutex.unlock();
	counter = 1;
	qDebug() << "Unlocking the mutex!";
}

void ThumbTest::thumbnailerStarted() {
	//mutex.lock();
	qDebug() << "Request started!";
}

void ThumbTest::request_simpleRequest() {
	Thumbnailer thumb(QUrl("file:///empty/url"), QPixmap());

	QDir dir("/media/eMMC/libthumbnailer-benchmarks");
	QStringList filters; filters << "*.jpeg";
	dir.setNameFilters(filters);
	QStringList files = dir.entryList(QDir::Files | QDir::Readable);

	QList<QUrl> uris;
	QStringList mimes;

	foreach(QString file, files) {
		file = "file:///media/eMMC/libduithumbnailer-benchmarks/" + file;
		uris << QUrl(file);
		mimes << "image/jpeg";
	}

/*	if(NULL == thumb) {
		thumb = new Thumbnailer( QUrl(""),
	                                 QPixmap(defaultPixmapPath) );
		QObject::connect(thumb, SIGNAL(started()), this, SLOT(loadingStarted()));
		QObject::connect(thumb, SIGNAL(finished(int)), this, SLOT(loadingFinished(int)));
		QObject::connect(thumb, SIGNAL(thumbnail(QUrl,QUrl,QPixmap,QString)), this, SLOT(thumbnail(QUrl,QUrl,QPixmap)));
		QObject::connect(thumb, SIGNAL(defaultThumbnail(QUrl,QUrl,QPixmap,QString)), this, SLOT(defaultThumbnail(QUrl,QUrl,QPixmap)));
		QObject::connect(thumb, SIGNAL(error(QString,QUrl)), this, SLOT(error(QString,QUrl)));
		QObject::connect(thumb, SIGNAL(dequeued(QUrl)), this, SLOT(dequeued(QUrl)));
	}
*/

	mutex.lock();
	QObject::connect(&thumb, SIGNAL(started()), this, SLOT(thumbnailerStarted()));
	QSignalSpy stop(&thumb, SIGNAL(finished(int)));

	QBENCHMARK {
		thumb.request (uris, mimes, false); // true - send also a pixmap with the thumbnail
		WAIT_FOR_FINISH(stop, 1, 999999);
	}
}

/****************************************************************************
 *     TESTS - DUI MEDIA ART
 ****************************************************************************/
/****************************************************************************
 *     TESTS - DUI MEDIA ART THUMBNAILER
 ****************************************************************************/
// execute all tests
QTEST_MAIN(ThumbTest)

