TEMPLATE = lib
CONFIG += dll debug
TARGET = thumbnailer
DEPENDPATH += .
INCLUDEPATH += .
include(base.pri)

OBJECTS_DIR = .obj
MOC_DIR = .moc

#DEFINES += ENABLE_TIMER_DEBUG_OUTPUT

QT += dbus

# Input
HEADERS += include/thumbnailer.h \
           include/mediaartinfo.h \
           include/mediaartrequester.h \
           thumbnailer_p.h \
           mediaartrequester_p.h \
           dbus/dbus_types.h \
           dbus/thumbnailer_generic.h \
           dbus/tumbler_cache.h \
           dbus/albumart_requester.h \
           dbus-services.h
           
SOURCES += thumbnailer_p.cpp \
           mediaartinfo_p.cpp \
           mediaartrequester_p.cpp \
           dbus/dbus_types.cpp \
           thumbnailer_generic.cpp \
           tumbler_cache.cpp \
           albumart_requester.cpp \
           dbus-services.cpp \
           ini_fini.cpp

message(Install prefix is $$PREFIX)

INSTALL_HEADERS = include/*
install_headers.path = $$PREFIX/include/thumbnailer
install_headers.files = $$INSTALL_HEADERS

target.path += $$PREFIX/lib
target.depends += generateproxy generatecacheproxy generatemediaartproxy

generateproxy.target = dbus/thumbnailer_generic.h
generateproxy.depends = dbus/tumbler-service-dbus.xml
generateproxy.commands = qdbusxml2cpp -c ThumbnailerGenericProxy -p dbus/thumbnailer_generic.h:thumbnailer_generic.cpp -i dbus_types.h dbus/tumbler-service-dbus.xml org.freedesktop.thumbnails.Thumbnailer1

generatecacheproxy.target = dbus/tumbler_cache.h
generatecacheproxy.depends = dbus/tumbler-cache-service-dbus.xml
generatecacheproxy.commands = qdbusxml2cpp -c ThumbnailerGenericCacheProxy -p dbus/tumbler_cache.h:tumbler_cache.cpp -i dbus_types.h dbus/tumbler-cache-service-dbus.xml org.freedesktop.thumbnails.Cache1

generatemediaartproxy.target = dbus/albumart_requester.h
generatemediaartproxy.depends = dbus/albumart_requester.xml
generatemediaartproxy.commands = qdbusxml2cpp -c ComNokiaAlbumArtRequester -p dbus/albumart_requester.h:albumart_requester.cpp -i dbus_types.h dbus/albumart_requester.xml com.nokia.albumart.Requester

QMAKE_CLEAN += dbus/thumbnailer_generic.h \
               dbus/tumbler_cache.h \
               dbus/albumart_requester.h \
               thumbnailer_generic.cpp \
               tumbler_cache.cpp \
               albumart_requester.cpp

QMAKE_EXTRA_TARGETS += generateproxy generatecacheproxy generatemediaartproxy

# what to do with these?
# install_pkgconfig.path = $$[QT_INSTALL_LIBS]/pkgconfig
# install_pkgconfig.files = thumbnailer.pc

INSTALLS += target \
#    install_pkgconfig \
    install_headers

clean.depends += cleanproxies

coverage {
	# add flags to compiler
	LIBS += -lgcov
	QMAKE_CXXFLAGS += -ftest-coverage -fprofile-arcs -fno-elide-constructors

	# and add a target for generating report
	QMAKE_EXTRA_TARGETS += coverage-report
	coverage-report.commands  = lcov -d .obj --capture --output-file all.cov -b . &&
	coverage-report.commands += lcov -r all.cov '*thumbtest*' -r all.cov '*/src/dbus/*' -r all.cov '*/src/.moc/*' -o to_test.cov &&
	coverage-report.commands += lcov -e to_test.cov '*/*/src/*.cpp*' -e to_test.cov '*/*/src/*.h*' -e to_test.cov '*/*/src/include/*.h*' -o final.cov &&
	coverage-report.commands += genhtml -o coverage final.cov
}

check.commands = echo 'No check here'
QMAKE_EXTRA_TARGETS += check
