#ifndef MEDIAARTREQUESTERPRIVATE_H
#define MEDIAARTREQUESTERPRIVATE_H
#include "include/mediaartrequester.h"

using namespace MediaArt;

namespace MediaArt {
class MediaArtRequesterPrivate : public QObject {
Q_OBJECT
	protected:
		Requester* parent;
		QUrl _defaultPath;
		QPixmap _defaultPixmap;
		bool stop;
	public:
		MediaArtRequesterPrivate ( Requester* p = 0) :
		                           QObject(), parent(p), stop(false) {}
		inline void setDefaultPath(const QUrl& path) { _defaultPath = path; }
		inline void setDefaultPixmap(const QPixmap& pixmap) { _defaultPixmap = pixmap; }
		inline const QUrl defaultPath() { return _defaultPath; }
		inline const QPixmap defaultPixmap() { return _defaultPixmap; }
	public:
		void cancel (bool sendRemainingSignals = false);
		bool request ( QList<Info>& list,
			       bool sendPixmap );
	public Q_SLOTS:
};}


#endif // MEDIAARTSREQUESTERPRIVATE_H
