#include "mediaartrequester_p.h"
#include <QCoreApplication>
#include <QEventLoop>

Requester::Requester( const QUrl defaultPath,
                                     const QPixmap defaultPixmap) :
                                     QObject(),
                                     priv(new MediaArtRequesterPrivate(this) )
{
	setDefaultPath(defaultPath);
	setDefaultPixmap(defaultPixmap);
}

Requester::~Requester()
{
	delete priv;
}

void Requester::setDefaultPath(const QUrl& path)
{
	priv->setDefaultPath(path);
}

void Requester::setDefaultPixmap(const QPixmap& pixmap)
{
	priv->setDefaultPixmap(pixmap);
}

const QUrl Requester::defaultPath() const
{
	return priv->defaultPath();
}

const QPixmap Requester::defaultPixmap() const
{
	return priv->defaultPixmap();
}

void Requester::cancel (bool sendRemainingSignals)
{
	priv->cancel(sendRemainingSignals);
}

bool Requester::request ( QList<Info>& list,
                                         bool sendPixmap )
{
	return priv->request(list, sendPixmap);
}

void MediaArtRequesterPrivate::cancel (bool sendRemainingSignals)
{
	Q_UNUSED(sendRemainingSignals);
	// currently there is no Media Art service, so no option to cancel
	// the request - just set a flag saying that we need to stop
	stop = true;
}

bool MediaArtRequesterPrivate::request ( QList<Info>& list,
                                                        bool sendPixmap )
{
	Q_EMIT parent->started();
	// we starting the request = set flag 'stop' to false
	stop = false;

	// go through the list and process every element in it
	bool allMediaArtExisted = true;
	foreach (Info mai, list) {
		// check if user did not want to cancel the request
		if(stop) {
			Q_EMIT parent->unqueued(mai);
		}
		// we need to proceed and the media art exists
		else if(mai.exists()) {
			QPixmap pixmap;
			if(sendPixmap) pixmap.load(mai.potentialPath().path());

			Q_EMIT parent->mediaArt( mai,
				                 mai.potentialPath(),
				                 pixmap );
		}
		// we need to proceed but there is no such a media art - need to request it
		else {
			allMediaArtExisted = false;
			/* first we need to send default signal and later error
			  TODO: currently there is not Service in the background
			  later on we should send this request to Media Arts
			  service
			 */
			Q_EMIT parent->defaultMediaArt ( mai,
			                                 defaultPath(),
			                                 defaultPixmap() );

			// send error signal
			Q_EMIT parent->error ( QString("Could not request for that Media Art"),
			                       mai );
		}
	}

	Q_EMIT parent->finished();
	return allMediaArtExisted;
}

