/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Contact: Marius Vollmer <marius.vollmer@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

/*
 * dbus-services.h
 *
 *  Created on: Jan 12, 2010
 *     Authors: wiecheck
 */

#ifndef DBUS_SERVICES_P_H_
#define DBUS_SERVICES_P_H_

#include <QObject>
#include <QHash>
#include "dbus/thumbnailer_generic.h"
#include "dbus/tumbler_cache.h"
#include "dbus/albumart_requester.h"

class DBusServices : public QObject {
Q_OBJECT
	private:
		DBusServices();
		~DBusServices();
		static void reconnectTumblerService();
		static void reconnectMediaArtService();
	public:
		static ThumbnailerGenericCacheProxy* cache();
		static ThumbnailerGenericProxy*      tumbler();
		static ComNokiaAlbumArtRequester*    mediaart();
		static DBusServices*                 instance();

	public Q_SLOTS:
		// just re-emit signals (but now the emmiter is always the same)
		// TUMBLER SERVICE
		inline void tumblerStartedHandler ( uint handle )
			{ Q_EMIT StartedHandler(handle); }
		inline void tumblerReadyHandler   ( uint handle, const QStringList &uris )
			{ Q_EMIT ReadyHandler(handle,uris); }
		inline void tumblerErrorHandler   ( uint handle,
		                                    const QStringList &failedUris,
		                                    int errorCode,
		                                    const QString &message )
			{ Q_EMIT ErrorHandler(handle,failedUris,errorCode,message); }
		inline void tumblerFinishedHandler( uint handle )
			{ Q_EMIT FinishedHandler(handle); }

		// MEDIA ART REQUESTER SERVICE
		inline void mediaartErrorHandler( uint handle,
		                                  int error_code,
		                                  const QString &message )
			{ Q_EMIT mediaartError(handle,error_code,message); }
		inline void mediaartFinishedHandler(uint handle)
			{ Q_EMIT mediaartFinished(handle); }
		inline void mediaartReadyHandler( const QString &artist,
		                                  const QString &album,
		                                  const QString &kind,
		                                  const QString &art_path )
			{ Q_EMIT mediaartReady(artist, album, kind, art_path); }
		inline void mediaartStartedHandler(uint handle)
			{ Q_EMIT mediaartStarted(handle); }
	Q_SIGNALS:
		// signals from TUMBLER
		void StartedHandler ( uint handle );
		void ReadyHandler   ( uint handle, const QStringList &uris );
		void ErrorHandler   ( uint handle,
		                      const QStringList &failedUris,
		                      int errorCode,
		                      const QString &message );
		void FinishedHandler( uint handle );

		//signals from MEDIA ART REQUESTER
		void mediaartError   ( uint handle,
		                       int error_code,
		                       const QString &message );
		void mediaartFinished( uint handle );
		void mediaartReady   ( const QString &artist,
		                       const QString &album,
		                       const QString &kind,
		                       const QString &art_path );
		void mediaartStarted ( uint handle );

		// own signals
		void tumblerServiceReconnected();
		void cacheServiceReconnected();
		void mediaartServiceReconnected();
};

#endif
