#include <MediaArtInfo>
#include <MediaArtRequester>
#include <Thumbnailer>
#include <QDebug>
#include <QHash>
#include <QPixmap>

#define bool2str(b) ((b)?QString("true"):QString("false"))

class MediaArtClient : public QObject {
Q_OBJECT
private:

protected:

public:
	MediaArtClient() {}
};

enum {
	SIGNAL_STARTED = 0,
	SIGNAL_FINISHED,
	SIGNAL_MEDIA_ART,
	SIGNAL_DEFAULT_MEDIA_ART,
	SIGNAL_ERROR,
	SIGNAL_UNQUEUED,
	SIGNALS_NUM
};

class RequesterDebugger : public QObject {
Q_OBJECT
private:
	int counter[SIGNALS_NUM];
public:
	RequesterDebugger(MediaArt::Requester *req) {
		QObject::connect(req, SIGNAL(started()), this, SLOT(started()));
		QObject::connect(req, SIGNAL(finished()), this, SLOT(finished()));
		QObject::connect(req, SIGNAL(mediaArt(MediaArt::Info,QUrl,QPixmap)), this, SLOT(mediaArt(MediaArt::Info,QUrl,QPixmap)));
		QObject::connect(req, SIGNAL(defaultMediaArt(MediaArt::Info,QUrl,QPixmap)), this, SLOT(defaultMediaArt(MediaArt::Info,QUrl,QPixmap)));
		QObject::connect(req, SIGNAL(error(QString,MediaArt::Info)), this, SLOT(error(QString,MediaArt::Info)));
		QObject::connect(req, SIGNAL(unqueued(MediaArt::Info)), this, SLOT(unqueued(MediaArt::Info)));
		printOutput = false;
	}


	void clearCounters(int value = 0) {
		for(int i=0; i < SIGNALS_NUM; ++i) counter[i] = value;
	}
	void printCounters(bool autoReset = true) {
		qDebug() << "   * Signal         started() called" << counter[SIGNAL_STARTED] << "times.";
		qDebug() << "   * Signal        finished() called" << counter[SIGNAL_FINISHED] << "times.";
		qDebug() << "   * Signal        mediaArt() called" << counter[SIGNAL_MEDIA_ART] << "times.";
		qDebug() << "   * Signal defaultMediaArt() called" << counter[SIGNAL_DEFAULT_MEDIA_ART] << "times.";
		qDebug() << "   * Signal           error() called" << counter[SIGNAL_ERROR] << "times.";
		qDebug() << "   * Signal        unqueued() called" << counter[SIGNAL_UNQUEUED] << "times.";
		if(autoReset) clearCounters();
	}
	bool printOutput;
public Q_SLOTS:
	void started() {
		if(printOutput) qDebug(QString("\n   * Function \'%1\' executed.").arg(__FUNCTION__).toLatin1());
		++counter[SIGNAL_STARTED];
	}
	void unqueued (const MediaArt::Info& mai) {
		const QUrl url = mai.potentialPath();
		const QString path = mai.potentialPath().toString();
		if(printOutput) qDebug(QString("\n   * Function \'%1\' executed for media art %2").arg(__FUNCTION__).arg(path).toLatin1());
		++counter[SIGNAL_UNQUEUED];
	}
	void finished() {
		if(printOutput) qDebug(QString("\n   * Function \'%1\' executed.").arg(__FUNCTION__).toLatin1());
		++counter[SIGNAL_FINISHED];
	}
	void mediaArt (const MediaArt::Info& mai, const QUrl& path, const QPixmap& pixmap) {
		Q_UNUSED(pixmap);
		Q_UNUSED(mai);
		if(printOutput) qDebug(QString("\n   * Function \'%1\' executed.").arg(__FUNCTION__).toLatin1());
		//qDebug() << "   * Media Art:" << mai;
		if(printOutput) qDebug() << "   * Returned path" << path.toString();
		++counter[SIGNAL_MEDIA_ART];
	}
	void defaultMediaArt (const MediaArt::Info& mai, const QUrl& path, const QPixmap& pixmap) {
		Q_UNUSED(pixmap);
		Q_UNUSED(mai);
		if(printOutput) qDebug(QString("\n   * Function \'%1\' executed.").arg(__FUNCTION__).toLatin1());
		//qDebug() << "   * Media Art:" << mai;
		if(printOutput) qDebug() << "   * Returned path" << path.toString();
		++counter[SIGNAL_DEFAULT_MEDIA_ART];
	}
	void error (const QString& message, const MediaArt::Info& mai) {
		Q_UNUSED(mai);
		if(printOutput) qDebug(QString("\n   * Function \'%1\' executed.").arg(__FUNCTION__).toLatin1());
		//qDebug() << "   * Media Art:" << mai;
		if(printOutput) qDebug() << "   * Error message" << message;
		++counter[SIGNAL_ERROR];
	}

};



