/** \mainpage Library for accessing thumbnails and media arts.

\section intro Introduction

libthumnbailer library allows You to get a thumbnails of any kind (supported)
type of resources which are identified by its URIs. You can ask for different
type (flavors) of thumbnail and You can change the behaviour how thumbnails
are created and returned to You (schedulers). Use Thumbnails::Thumbnailer API for such
a tasks.

Beside standard thumbnail, libthumnbailer allows You to retrieve a Media
Art content and a thumbnail of that content. Check MediaArt::Info and
MediaArt::Requester methods for retrieving media arts content and
Thumbnails::Thumbnailer for getting thumbnails of media arts.

\section hwo_to-start How to start

The best way of starting using the libthumnbailer library is to go through
the \ref FAQ page. You will find there definitions and terms which are in use in
the code, API and this documentation and also some example codes (some of them
are from example applications).

You can also download the sources of the package:
\code
apt-get source libthumbnailer0-doc
\endcode
and check examples applications (./examples folder) to see API in use. Some of examples are
trivial demo application which are doing nothing particular - just present
how to use the API. And some others are real application doing something concrete.

\section contacts Contacts
<b>API:</b> \n Dariusz Wiechecki <ext-dariusz.2.wiechecki@nokia.com>

<b>Implementation:</b> \n Dariusz Wiechecki <ext-dariusz.2.wiechecki@nokia.com>

<b>Bugs and other issues:</b> \n Dariusz Wiechecki <ext-dariusz.2.wiechecki@nokia.com>

<b>Integration:</b> \n Marius Vollmer <marius.vollmer@nokia.com>
*/

/** \page FAQ Frequently Asked Questions

\section definitions Definition and terms used in the documentation and code

\subsection what_thumbnail_is What thumbnails are?

Thumbnail is a small image representing particular resource. The resource should be something what is
visible - image, video, document, text. Music are not a visual files - they have only sounds so it is
not possible to create a thumbnail from it. To represent music file You have to use Media Art attached
to this file. See next FAQ \ref what_media_arts_are

In other words: thumbnail is a small, static version of the resource.

\subsection what_media_arts_are What media arts are?

Media Art is some image which is attached/distributed with the file. It could be
an album cover, movie poster, cd cover etc. It is not a thumbnail - media art are
only related to the file, but they are not created based on the file itself.

In this dcumentation when we are saying media art we mean an object which is describing
some media art. The image itself we will be calling as a 'media art's content'. You can
have an media art object but it does not mean that corellated image file exists. You can check it easily
or even You can try to request that image from some 3rd parties service. Unfortunatelly currently
there is no such a service on the platform.

\subsection what_media_arts_content_is What media art's content is?

As a media art's content we mean an image itself.

\subsection what_is_a_difference What is a difference between thumbnail and media art?

Let's imagine that we have a video file with some movie. A thumbnail is a one frame
taken from that movie, resized to some standard thumbnails size. So it is created based
on that file. Media art on the other hand is something what is attached to that file - it could be
a second file poster.jpeg which contains poster of that movie. So media art content is not
created based on file - it is just an image connected with that file.

If You will get that video file itself, without anything else, You would be able to recreate
only thumbnail. Media art cannot be created again from just a file - some additional services are needed.

\subsection what_is_flavor What flavors are?

Flavors are connected with thumbnails. They are lots of thumbnail's type and every type can
have a different size. Flavor is a name for thumbnail's type. You can have flavor like 'very-small'
which will describe thumbnails with 50x50 resolution, flavor 'very-big' for thumbnails with 250x250 resolution,
flavor 'half-screen' with 400x240 resolution and so on. When You are asking for thumbnails You need to
specify what type of thumbnails You need. By default 'normal' flavor is used. You can check what
flavors Thumbnailer support by calling function from Thumbnails::Thumbnailer::getFlavors(). If You want to
know the size of particular flavor You can use Thumbnails::Thumbnailer::getFlavorSize(QString flavor).

\subsection what_is_scheduler What schedulers are?
TBD

\section why_that_way Design, reasons... why it is working like that. What for?
TBD

\section normal_faq Standard questions.

\subsection what_is_noop What noop scheduler do?
TBD



*/