
#include <tangle/tangle.h>

const ClutterColor red = { 255, 0, 0, 255 };
const ClutterColor stage_color = { 0, 0, 0, 255 };

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* actor;
	ClutterEffect* effect;
	ClutterAnimation* animation;

	tangle_init(&argc, &argv);
	
	stage = clutter_stage_get_default();
	g_object_set(G_OBJECT(stage), "width", 800.0, "height", 480.0, NULL);
	clutter_stage_set_color(CLUTTER_STAGE(stage), &stage_color);

	actor = tangle_texture_new("test_image_alpha_150x111.png");
	clutter_actor_set_position(actor, 100.0, 100.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), actor);

	effect = tangle_highlight_effect_new();
	tangle_highlight_effect_set_color(TANGLE_HIGHLIGHT_EFFECT(effect), &red);
	clutter_actor_add_effect(actor, effect);

	animation = tangle_object_animate(G_OBJECT(effect), CLUTTER_LINEAR, 2000, "distance", 20.0, NULL);
	clutter_animation_set_loop(animation, TRUE);
	
	clutter_actor_show_all(stage);
	
	clutter_main();

	return 0;
}
