/*
 * tangle-scroll-action.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_SCROLL_ACTION_H__
#define __TANGLE_SCROLL_ACTION_H__

#include <clutter/clutter.h>
#include "tangle-clamp.h"

#define TANGLE_TYPE_SCROLL_ACTION (tangle_scroll_action_get_type())
#define TANGLE_SCROLL_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_SCROLL_ACTION, TangleScrollAction))
#define TANGLE_IS_SCROLL_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_SCROLL_ACTION))
#define TANGLE_SCROLL_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_SCROLL_ACTION, TangleScrollActionClass))
#define TANGLE_IS_SCROLL_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_SCROLL_ACTION))
#define TANGLE_SCROLL_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_SCROLL_ACTION, TangleScrollActionClass))

typedef struct _TangleScrollActionPrivate TangleScrollActionPrivate;

typedef struct _TangleScrollAction {
	ClutterAction parent_instance;
	TangleScrollActionPrivate* priv;
} TangleScrollAction;

typedef struct _TangleScrollActionClass {
	ClutterActionClass parent_class;

	void (*clamp_offset_x)(TangleScrollAction* scroll_action, TangleClamp* clamp);
	void (*clamp_offset_y)(TangleScrollAction* scroll_action, TangleClamp* clamp);
} TangleScrollActionClass;

GType tangle_scroll_action_get_type(void) G_GNUC_CONST;

#include "tangle-scroll-trick.h"

ClutterAction* tangle_scroll_action_new();

void tangle_scroll_action_get_offsets(TangleScrollAction* scroll_action, gfloat* offset_x_return, gfloat* offset_y_return);
void tangle_scroll_action_set_offsets(TangleScrollAction* scroll_action, gfloat offset_x, gfloat offset_y);

void tangle_scroll_action_get_max_offsets(TangleScrollAction* scroll_action, gfloat* max_offset_x_return, gfloat* max_offset_y_return);
void tangle_scroll_action_set_max_offsets(TangleScrollAction* scroll_action, gfloat max_offset_x, gfloat max_offset_y);

void tangle_scroll_action_get_thresholds(TangleScrollAction* scroll_action, gfloat* threshold_x_return, gfloat* threshold_y_return);
void tangle_scroll_action_set_thresholds(TangleScrollAction* scroll_action, gfloat threshold_x, gfloat threshold_y);

void tangle_scroll_action_get_max_overshoots(TangleScrollAction* scroll_action, gfloat* max_overshoot_x_return, gfloat* max_overshoot_y_return);
void tangle_scroll_action_set_max_overshoots(TangleScrollAction* scroll_action, gfloat max_overshoot_x, gfloat max_overshoot_y);

void tangle_scroll_action_get_continuous(TangleScrollAction* scroll_action, gboolean* continuous_x_return, gboolean* continuous_y_return);
void tangle_scroll_action_set_continuous(TangleScrollAction* scroll_action, gboolean continuous_x, gboolean continuous_y);

gboolean tangle_scroll_action_get_kinetic_scrolling(TangleScrollAction* scroll_action);
void tangle_scroll_action_set_kinetic_scrolling(TangleScrollAction* scroll_action, gboolean kinetic_scrolling);

gdouble tangle_scroll_action_get_deceleration(TangleScrollAction* scroll_action);
void tangle_scroll_action_set_deceleration(TangleScrollAction* scroll_action, gdouble deceleration);

gboolean tangle_scroll_action_get_bind_to_scroll_trick(TangleScrollAction* scroll_action);
void tangle_scroll_action_set_bind_to_scroll_trick(TangleScrollAction* scroll_action, gboolean bind_to_scroll_trick);

void tangle_scroll_action_clamp_offset_x(TangleScrollAction* scroll_action);
void tangle_scroll_action_clamp_offset_y(TangleScrollAction* scroll_action);
void tangle_scroll_action_clamp_offsets(TangleScrollAction* scroll_action);

void tangle_scroll_action_bind_to_scroll_trick(TangleScrollAction* scroll_action, TangleScrollTrick* scroll_trick);

#endif
