/*
 * tangle-highlight-effect.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2011 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_HIGHLIGHT_EFFECT_H__
#define __TANGLE_HIGHLIGHT_EFFECT_H__

#include <clutter/clutter.h>

#define TANGLE_TYPE_HIGHLIGHT_EFFECT (tangle_highlight_effect_get_type())
#define TANGLE_HIGHLIGHT_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_HIGHLIGHT_EFFECT, TangleHighlightEffect))
#define TANGLE_IS_HIGHLIGHT_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_HIGHLIGHT_EFFECT))
#define TANGLE_HIGHLIGHT_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_HIGHLIGHT_EFFECT, TangleHighlightEffectClass))
#define TANGLE_IS_HIGHLIGHT_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_HIGHLIGHT_EFFECT))
#define TANGLE_HIGHLIGHT_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_HIGHLIGHT_EFFECT, TangleHighlightEffectClass))

typedef struct _TangleHighlightEffectPrivate TangleHighlightEffectPrivate;

typedef struct _TangleHighlightEffect {
	ClutterOffscreenEffect parent_instance;
	TangleHighlightEffectPrivate* priv;
} TangleHighlightEffect;

typedef struct _TangleHighlightEffectClass {
	ClutterOffscreenEffectClass parent_class;
} TangleHighlightEffectClass;

GType tangle_highlight_effect_get_type(void) G_GNUC_CONST;

ClutterEffect* tangle_highlight_effect_new();

void tangle_highlight_effect_get_color(TangleHighlightEffect* highlight_effect, ClutterColor* color);
void tangle_highlight_effect_set_color(TangleHighlightEffect* highlight_effect, const ClutterColor* color);
gfloat tangle_highlight_effect_get_distance(TangleHighlightEffect* highlight_effect);
void tangle_highlight_effect_set_distance(TangleHighlightEffect* highlight_effect, gfloat distance);

#endif
