/*
 * tangle-activity.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2011 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#include "tangle-activity.h"

G_DEFINE_ABSTRACT_TYPE(TangleActivity, tangle_activity, TANGLE_TYPE_OBJECT);

void tangle_activity_activate(TangleActivity* activity) {
	g_return_if_fail(TANGLE_IS_ACTIVITY(activity));

	TANGLE_ACTIVITY_GET_CLASS(activity)->activate(activity);
}

gboolean tangle_activity_activate_false(TangleActivity* activity) {
	g_return_val_if_fail(TANGLE_IS_ACTIVITY(activity), FALSE);

	tangle_activity_activate(activity);

	return FALSE;
}

gboolean tangle_activity_activate_true(TangleActivity* activity) {
	g_return_val_if_fail(TANGLE_IS_ACTIVITY(activity), TRUE);

	tangle_activity_activate(activity);
	
	return TRUE;
}

static void tangle_activity_real_activate(TangleActivity* activity) {
}

static void tangle_activity_class_init(TangleActivityClass* activity_class) {
	activity_class->activate = tangle_activity_real_activate;
}

static void tangle_activity_init(TangleActivity* activity) {
}
