#include <tangle/tangle.h>

static ClutterColor normal_color = { 0, 128, 128, 255 };
static ClutterColor interactive_color = { 255, 64, 64, 255 };
static ClutterColor gradient_color = { 0, 255, 255, 255 };

static gboolean on_clicked(TangleButton* button, gpointer user_data) {
	g_printf("jee\n");
	
	return FALSE;
}

static void print_status(TangleActor* actor, GParamSpec* pspec, const gchar* string) {
	g_print("%s: %d %d\n", string, tangle_actor_get_interacting(actor), tangle_actor_get_dragging(actor));
}

static void connect_print_status(ClutterActor* actor, const gchar* string) {
	g_signal_connect(actor, "notify::interacting", G_CALLBACK(print_status), (gpointer)string);
	g_signal_connect(actor, "notify::dragging", G_CALLBACK(print_status), (gpointer)string);
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* widget;
	ClutterActor* actors[4];
	ClutterAction* action;
	
	tangle_init(&argc, &argv);
	stage = clutter_stage_get_default();
	clutter_actor_set_size(stage, 800.0, 400.0);
	
	widget = tangle_widget_new();
	connect_print_status(widget, "widget");
	tangle_widget_set_layout(TANGLE_WIDGET(widget), tangle_box_layout_new());
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), widget);
	
	actors[0] = tangle_button_new_with_background_actors(tangle_grid_new(20.0, 20.0),
	                                                     tangle_grid_new(10.0, 10.0));
	connect_print_status(actors[0], "actors[0]");
	g_signal_connect(actors[0], "clicked", G_CALLBACK(on_clicked), NULL);
	clutter_actor_set_size(actors[0], 1350.0, 1000.0);	

	actors[1] = tangle_widget_new_scrollable(tangle_box_layout_new());
	connect_print_status(actors[1], "actors[1]");
	clutter_container_add_actor(CLUTTER_CONTAINER(actors[1]), actors[0]);
	action = tangle_actor_get_action_by_type(actors[1], TANGLE_TYPE_SCROLL_ACTION);
	tangle_scroll_action_set_thresholds(TANGLE_SCROLL_ACTION(action), 100.0, 50.0);
	clutter_actor_set_size(actors[1], 150.0, 100.0);
	clutter_actor_set_reactive(actors[1], TRUE);
	clutter_container_add_actor(CLUTTER_CONTAINER(widget), actors[1]);

	actors[2] = tangle_grid_new(5.0, 5.0);
	connect_print_status(actors[2], "actors[2]");
	action = tangle_drag_action_new();
	clutter_actor_add_action(actors[2], action);
	clutter_actor_set_size(actors[2], 1350.0, 1000.0);	
	clutter_drag_action_set_drag_threshold(CLUTTER_DRAG_ACTION(action), G_MAXUINT, 20);
	clutter_actor_set_reactive(actors[2], TRUE);

	actors[3] = tangle_widget_new_scrollable(tangle_box_layout_new());
	connect_print_status(actors[3], "actors[3]");
	clutter_container_add_actor(CLUTTER_CONTAINER(actors[3]), actors[2]);
//	tangle_scrolling_actor_set_scrolling_threshold_x(TANGLE_SCROLLING_ACTOR(actors[3]), 100.0);
//	tangle_scrolling_actor_set_scrolling_threshold_y(TANGLE_SCROLLING_ACTOR(actors[3]), 50.0);
	clutter_actor_set_size(actors[3], 150.0, 100.0);
	clutter_actor_set_reactive(actors[3], TRUE);
	clutter_container_add_actor(CLUTTER_CONTAINER(widget), actors[3]);

	clutter_actor_show_all(stage);
	
	clutter_main();

	return 0;
}
