#include <tangle/tangle.h>

static ClutterColor color0 = { 0, 0, 0, 255 };
static ClutterColor color1 = { 0, 255, 128, 255 };
static ClutterColor color2 = { 0, 128, 255, 255 };
static TangleSpacing spacing = { 4, 8, 12, 16 };

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* widget;
	ClutterActor* actor;
		
	tangle_init(&argc, &argv);
	
	stage = clutter_stage_get_default();

	widget = tangle_widget_new();
	tangle_widget_set_background_color(TANGLE_WIDGET(widget), &color0);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), widget);;
	
	actor = tangle_linear_gradient_new(&color1, &color2);
	clutter_actor_set_height(actor, 100);
	clutter_actor_set_request_mode(actor, CLUTTER_REQUEST_WIDTH_FOR_HEIGHT);

	tangle_actor_set_aspect_ratio(TANGLE_ACTOR(actor), 2.0);
	// g_object_set(actor, "aspect-ratio", 0.5, NULL);

	tangle_actor_set_max_size(TANGLE_ACTOR(actor), 20.0, 30.0);
	//tangle_actor_set_margin(TANGLE_ACTOR(actor), &spacing);

	clutter_container_add_actor(CLUTTER_CONTAINER(widget), actor);
	
	clutter_actor_show_all(stage);
	
	clutter_main();
	
	return 0;
}
