/*
 * tangle-template.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_TEMPLATE_H__
#define __TANGLE_TEMPLATE_H__

#include "tangle-properties.h"
#include <clutter/clutter.h>

#define TANGLE_TYPE_TEMPLATE (tangle_template_get_type())
#define TANGLE_TEMPLATE(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_TEMPLATE, TangleTemplate))
#define TANGLE_IS_TEMPLATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_TEMPLATE))
#define TANGLE_TEMPLATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_TEMPLATE, TangleTemplateClass))
#define TANGLE_IS_TEMPLATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_TEMPLATE))
#define TANGLE_TEMPLATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_TEMPLATE, TangleTemplateClass))

typedef struct _TangleTemplatePrivate TangleTemplatePrivate;

typedef struct _TangleTemplate {
	TangleProperties parent_instance;
	TangleTemplatePrivate* priv;
} TangleTemplate;

typedef struct _TangleTemplateClass {
	TanglePropertiesClass parent_class;
} TangleTemplateClass;

GType tangle_template_get_type(void) G_GNUC_CONST;

TangleTemplate* tangle_template_new(GType type);
/* TangleTemplate* tangle_template_new_with_properties(GType type, const gchar* first_property, GType first_type, ...); */

GType tangle_template_get_object_type(TangleTemplate* template);
GObject* tangle_template_create_object(TangleTemplate* template);
GObject* tangle_template_create_object_with_id(TangleTemplate* template, const gchar* id);
void tangle_template_apply_properties(TangleTemplate* template, GObject* object);
void tangle_template_animate_properties(TangleTemplate* template, ClutterActor* actor, gulong mode, guint duration);
gulong tangle_template_apply_properties_on_signal(TangleTemplate* template, GObject* target_object, GObject* signal_object, const gchar* signal_name, gboolean signal_return);
gulong tangle_template_animate_properties_on_signal(TangleTemplate* template, ClutterActor* actor, gulong mode, guint duration, GObject* signal_object, const gchar* signal_name, gboolean signal_return);
gboolean tangle_template_has_parameters(TangleTemplate* template);
GList* tangle_template_get_parameter_names(TangleTemplate* template);
gboolean tangle_template_has_parameter(TangleTemplate* template, const gchar* name);
const GValue* tangle_template_get_parameter_value(TangleTemplate* template, const gchar* name);
gboolean tangle_template_set_parameter_value(TangleTemplate* template, const gchar* name, const GValue* value);
void tangle_template_clear_parameter_values(TangleTemplate* template);
gboolean tangle_template_are_parameters_complete(TangleTemplate* template);

#endif
