/*
 * tangle-clamp.h
 *
 * This file is part of Tangle Toolkit - A graphical actor library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_CLAMP_H__
#define __TANGLE_CLAMP_H__

#include <glib-object.h>

#define TANGLE_TYPE_CLAMP (tangle_clamp_get_type())
#define TANGLE_CLAMP(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_CLAMP, TangleClamp))
#define TANGLE_IS_CLAMP(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_CLAMP))
#define TANGLE_CLAMP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_CLAMP, TangleClampClass))
#define TANGLE_IS_CLAMP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_CLAMP))
#define TANGLE_CLAMP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_CLAMP, TangleClampClass))

#define TANGLE_TYPE_CLAMP_DIRECTION (tangle_clamp_direction_get_type())

typedef struct _TangleClampPrivate TangleClampPrivate;

typedef struct _TangleClamp {
	GObject parent_instance;
	TangleClampPrivate* priv;
} TangleClamp;

typedef struct _TangleClampClass {
	GObjectClass parent_class;
} TangleClampClass;

GType tangle_clamp_get_type(void) G_GNUC_CONST;

typedef enum _TangleClampDirection {
	TANGLE_CLAMP_UNKNOWN,
	TANGLE_CLAMP_HORIZONTAL,
	TANGLE_CLAMP_VERTICAL,
	TANGLE_CLAMP_BOTH
} TangleClampDirection;

GType tangle_clamp_direction_get_type(void) G_GNUC_CONST;

TangleClamp* tangle_clamp_new(TangleClampDirection direction, gfloat original_value);

TangleClampDirection tangle_clamp_get_direction(TangleClamp* clamp);
gfloat tangle_clamp_get_original_value(TangleClamp* clamp);
gboolean tangle_clamp_get_clamped_value_set(TangleClamp* clamp);
gfloat tangle_clamp_get_clamped_value(TangleClamp* clamp);
void tangle_clamp_set_clamped_value(TangleClamp* clamp, gfloat clamped_value);

#endif
