/*
 * tangle-drop-action.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_DROP_ACTION_H__
#define __TANGLE_DROP_ACTION_H__

#include <clutter/clutter.h>
#include "tangle-drag-action.h"

#define TANGLE_TYPE_DROP_ACTION (tangle_drop_action_get_type())
#define TANGLE_DROP_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_DROP_ACTION, TangleDropAction))
#define TANGLE_IS_DROP_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_DROP_ACTION))
#define TANGLE_DROP_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_DROP_ACTION, TangleDropActionClass))
#define TANGLE_IS_DROP_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_DROP_ACTION))
#define TANGLE_DROP_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_DROP_ACTION, TangleDropActionClass))

typedef struct _TangleDropActionPrivate TangleDropActionPrivate;

typedef struct _TangleDropAction {
	ClutterAction parent_instance;
	TangleDropActionPrivate* priv;
} TangleDropAction;

typedef struct _TangleDropActionClass {
	ClutterActionClass parent_class;

	gboolean (*drag_begin)(TangleDropAction* drop_action, TangleDragAction* drag_action);
	gboolean (*drag_motion)(TangleDropAction* drop_action, TangleDragAction* drag_action);
	gboolean (*drag_end)(TangleDropAction* drop_action, TangleDragAction* drag_action);
	void (*dropped)(TangleDropAction* drop_action, TangleDragAction* drag_action);
} TangleDropActionClass;

GType tangle_drop_action_get_type(void) G_GNUC_CONST;

ClutterAction* tangle_drop_action_new();

gboolean tangle_drop_action_drag_begin(TangleDropAction* drop_action, TangleDragAction* drag_action);
gboolean tangle_drop_action_drag_motion(TangleDropAction* drop_action, TangleDragAction* drag_action);
gboolean tangle_drop_action_drag_end(TangleDropAction* drop_action, TangleDragAction* drag_action);	
void tangle_drop_action_dropped(TangleDropAction* drop_action, TangleDragAction* drag_action);

#endif

