/*
 * tangle-draggable-actor.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_DRAGGABLE_ACTOR_H__
#define __TANGLE_DRAGGABLE_ACTOR_H__

#include "tangle-floating-actor.h"

#define TANGLE_TYPE_DRAGGABLE_ACTOR (tangle_draggable_actor_get_type())
#define TANGLE_DRAGGABLE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_DRAGGABLE_ACTOR, TangleDraggableActor))
#define TANGLE_IS_DRAGGABLE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_DRAGGABLE_ACTOR))
#define TANGLE_DRAGGABLE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_DRAGGABLE_ACTOR, TangleDraggableActorClass))
#define TANGLE_IS_DRAGGABLE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_DRAGGABLE_ACTOR))
#define TANGLE_DRAGGABLE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_DRAGGABLE_ACTOR, TangleDraggableActorClass))

typedef struct _TangleDraggableActorPrivate TangleDraggableActorPrivate;
typedef struct _TangleDragging TangleDragging;

typedef struct _TangleDraggableActor {
	TangleFloatingActor parent_instance;
	TangleDraggableActorPrivate* priv;
} TangleDraggableActor;

typedef struct _TangleDraggableActorClass {
	TangleFloatingActorClass parent_class;

	gboolean (*begin_dragging)(TangleDraggableActor* draggable_actor, TangleDragging* dragging);
	gboolean (*do_dragging)(TangleDraggableActor* draggable_actor, TangleDragging* dragging);
	gboolean (*end_dragging)(TangleDraggableActor* draggable_actor, TangleDragging* dragging);
} TangleDraggableActorClass;

#include "tangle-droppable-actor.h"

struct _TangleDragging {
	TangleDraggableActor* draggable_actor;
	ClutterActor* real_draggable_actor;
	gfloat x;
	gfloat y;
	gfloat dx;
	gfloat dy;
	gfloat anchor_x;
	gfloat anchor_y;
	gfloat center_x;
	gfloat center_y;
	TangleDroppableActor* droppable_actor;
};

GType tangle_draggable_actor_get_type(void) G_GNUC_CONST;

ClutterActor* tangle_draggable_actor_new(ClutterActor* wrapped);

gboolean tangle_draggable_actor_get_dragging_enabled(TangleDraggableActor* draggable_actor);
void tangle_draggable_actor_set_dragging_enabled(TangleDraggableActor* draggable_actor, gboolean dragging_enabled);

gfloat tangle_draggable_actor_get_dragging_threshold_x(TangleDraggableActor* draggable_actor);
void tangle_draggable_actor_set_dragging_threshold_x(TangleDraggableActor* draggable_actor, gfloat dragging_threshold_x);
gfloat tangle_draggable_actor_get_dragging_threshold_y(TangleDraggableActor* draggable_actor);
void tangle_draggable_actor_set_dragging_threshold_y(TangleDraggableActor* draggable_actor, gfloat dragging_threshold_y);
void tangle_draggable_actor_set_dragging_threshold(TangleDraggableActor* draggable_actor, gfloat dragging_threshold);

#define TANGLE_TYPE_DRAGGING (tangle_dragging_get_type())
#define TANGLE_DRAGGING(p) ((TangleDragging*)(p))

GType tangle_dragging_get_type(void) G_GNUC_CONST;

TangleDragging* tangle_dragging_new(TangleDraggableActor* draggable_actor);
TangleDragging* tangle_dragging_copy(const TangleDragging* dragging);
void tangle_dragging_free(TangleDragging* dragging);
void tangle_dragging_set_droppable_actor(TangleDragging* dragging, TangleDroppableActor* droppable_actor);


#endif
