
#include <clutter/clutter.h>

#include "tangle/tangle-button.h"
#include "tangle/tangle-widget.h"
#include "tangle/tangle-box-layout.h"
#include "tangle/tangle-scroll-trick.h"
#include "tangle/tangle-linear-gradient.h"

static ClutterActor* create_item(const gchar* image, const gchar* message) {
	ClutterActor* actor;
	TangleSpacing spacing;
	ClutterActor* texture;
	ClutterActor* text;
	ClutterColor* color0;
	ClutterColor* color1;
	ClutterColor* color2;
	
	actor = tangle_widget_new();
	spacing.left = spacing.right = spacing.top = spacing.bottom = 2.0;
	tangle_actor_set_margin(TANGLE_ACTOR(actor), &spacing);
	tangle_widget_set_layout(TANGLE_WIDGET(actor), tangle_box_layout_new());
//	texture = clutter_texture_new_from_file(image, NULL);
color0 = clutter_color_new(255, 0, 0, 128);
tangle_widget_set_background_color(TANGLE_WIDGET(actor), color0);
color1 = clutter_color_new(0, 0, 255, 255);
color2 = clutter_color_new(0, 0, 0, 0);
texture = tangle_linear_gradient_new(color1, color2);
tangle_actor_animate(TANGLE_ACTOR(texture), CLUTTER_EASE_IN_SINE, 5000, "angle", 6.28, NULL);
g_object_set(actor, "width", 44.0, "height", 99.0, NULL);
	tangle_widget_set_background_actor(TANGLE_WIDGET(actor), texture);

	color1 = clutter_color_new(0, 255, 255, 255);
	color2 = clutter_color_new(255, 0, 255, 0);
	texture = tangle_linear_gradient_new(color1, color2);
	tangle_linear_gradient_set_angle(TANGLE_LINEAR_GRADIENT(texture), 3.14 / 2);
	tangle_widget_set_foreground_actor(TANGLE_WIDGET(actor), texture);


	text = clutter_text_new_with_text("Sans 10pt", message);
//	clutter_container_add(CLUTTER_CONTAINER(actor), text, NULL);
	
	return CLUTTER_ACTOR(actor);
}

static ClutterTimeline* animate_transition(TangleActor* actor, ClutterActorBox* current_box, ClutterActorBox* new_box) {
	ClutterAnimation* animation = NULL;
	gfloat move_x, move_y;
	gdouble scale_x, scale_y;
	gulong mode = 1;
	guint duration = 1500;
	
	if (!current_box) {
		g_object_get(actor,
		             "transition-move-x", &move_x, "transition-move-y", &move_y,
		             "transition-scale-x", &scale_x, "transition-scale-y", &scale_y,
			     NULL);
		if (!duration) {
			duration = 1000;
		}
		move_x = move_y = 0.0;
		scale_x = scale_y = 5.0;
		g_object_set(actor,
		             "transition-move-x", move_x, "transition-move-y", move_y,
			     "transition-scale-x", scale_x, "transition-scale-y", scale_y,
			     "opacity", 0,
			     NULL);
		animation = tangle_actor_animate(actor, mode, duration,
		                      "transition-move-x", 0.0, "transition-move-y", 0.0,
				      "transition-scale-x", 1.0, "transition-scale-y", 1.0,
				      NULL);
		tangle_actor_animate(actor, CLUTTER_EASE_OUT_SINE, duration,
				      "opacity", 255,
				      NULL);
	}
	
	return (animation ? clutter_animation_get_timeline(animation) : NULL);
}

static gboolean add_actor(ClutterActor* stage, ClutterEvent* event, gpointer user_data) {
	static int i = 0;
	static int j = 0;
	static int k = 0;
	ClutterContainer* container;
	ClutterActor* actor;

	container = CLUTTER_CONTAINER(user_data);
 	if (clutter_event_get_source(event) == stage) {
		if (clutter_event_get_button(event) == 1) {
			actor = create_item("test_image_100x74.jpg", "Test item");
			j += 1;
			if (j == 3) {
				g_signal_connect(actor, "animate-transition", G_CALLBACK(animate_transition), NULL);
				j = 0;
			}
			clutter_container_add_actor(container, actor);
		} else if (clutter_event_get_button(event) == 2) {
			i += 100;
			if (i > 400) {
				i = 50;
			}
			clutter_actor_set_position(CLUTTER_ACTOR(container), i, i);
			
		} else {
			TangleLayout* layout;
			
			layout = tangle_widget_get_layout(TANGLE_WIDGET(container));
			k += 1;
			if (k == 0) {
				tangle_layout_set_direction(layout, 0);
			} else if (k == 1) {
				tangle_layout_set_direction(layout, TANGLE_LAYOUT_DIRECTION_VERTICAL_FIRST | TANGLE_LAYOUT_DIRECTION_BTT);
			} else if (k == 2) {
				tangle_layout_set_direction(layout, TANGLE_LAYOUT_DIRECTION_RTL);
			} else {
				tangle_layout_set_direction(layout, TANGLE_LAYOUT_DIRECTION_VERTICAL_FIRST);
				k = -1;
			}
		}
	}
	
	return FALSE;
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* box;
	TangleLayout* box_layout;
	TangleTrick* scroll_trick;
	
	tangle_init(&argc, &argv);
	
	stage = clutter_stage_get_default();
	g_object_set(G_OBJECT(stage), "width", 800.0, "height", 480.0, NULL);

printf("%p\n", tangle_widget_new());

	tangle_stylesheet_set_default(tangle_stylesheet_new_from_file("box-stylesheet"));

	box_layout = tangle_box_layout_new();
	scroll_trick = tangle_scroll_trick_new();
	tangle_layout_add_trick(box_layout, scroll_trick);
	tangle_scroll_trick_set_offsets(TANGLE_SCROLL_TRICK(scroll_trick), -20.0, -20.0);

	box = tangle_widget_new();
	tangle_widget_set_layout(TANGLE_WIDGET(box), box_layout);
//	g_object_set(G_OBJECT(box), "width", 600.0, "height", 100.0, NULL);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), CLUTTER_ACTOR(box));

	g_signal_connect(stage, "button_press_event", G_CALLBACK(add_actor), box);

	clutter_actor_show_all(stage);

	clutter_main();

	return 0;
}
