/*
 * tangle-opacity-effect.c
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_OPACITY_EFFECT_H__
#define __TANGLE_OPACITY_EFFECT_H__

#include <clutter/clutter.h>

#define TANGLE_TYPE_OPACITY_EFFECT (tangle_opacity_effect_get_type())
#define TANGLE_OPACITY_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_OPACITY_EFFECT, TangleOpacityEffect))
#define TANGLE_IS_OPACITY_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_OPACITY_EFFECT))
#define TANGLE_OPACITY_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_OPACITY_EFFECT, TangleOpacityEffectClass))
#define TANGLE_IS_OPACITY_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_OPACITY_EFFECT))
#define TANGLE_OPACITY_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_OPACITY_EFFECT, TangleOpacityEffectClass))

typedef struct _TangleOpacityEffectPrivate TangleOpacityEffectPrivate;

typedef struct _TangleOpacityEffect {
	ClutterOffscreenEffect parent_instance;
	TangleOpacityEffectPrivate* priv;
} TangleOpacityEffect;

typedef struct _TangleOpacityEffectClass {
	ClutterOffscreenEffectClass parent_class;
} TangleOpacityEffectClass;

GType tangle_opacity_effect_get_type(void) G_GNUC_CONST;

ClutterEffect* tangle_opacity_effect_new();

#endif
