/*
 * tangle-multiplexed-transition.c
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_MULTIPLEXED_TRANSITION_H__
#define __TANGLE_MULTIPLEXED_TRANSITION_H__

#include "tangle-transition.h"

#define TANGLE_TYPE_MULTIPLEXED_TRANSITION (tangle_multiplexed_transition_get_type())
#define TANGLE_MULTIPLEXED_TRANSITION(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_MULTIPLEXED_TRANSITION, TangleMultiplexedTransition))
#define TANGLE_IS_MULTIPLEXED_TRANSITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_MULTIPLEXED_TRANSITION))
#define TANGLE_MULTIPLEXED_TRANSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_MULTIPLEXED_TRANSITION, TangleMultiplexedTransitionClass))
#define TANGLE_IS_MULTIPLEXED_TRANSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_MULTIPLEXED_TRANSITION))
#define TANGLE_MULTIPLEXED_TRANSITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_MULTIPLEXED_TRANSITION, TangleMultiplexedTransitionClass))

typedef struct _TangleMultiplexedTransitionPrivate TangleMultiplexedTransitionPrivate;

typedef struct _TangleMultiplexedTransition {
	TangleTransition parent_instance;
	TangleMultiplexedTransitionPrivate* priv;
} TangleMultiplexedTransition;

typedef struct _TangleMultiplexedTransitionClass {
	TangleTransitionClass parent_class;
} TangleMultiplexedTransitionClass;

GType tangle_multiplexed_transition_get_type(void) G_GNUC_CONST;

TangleTransition* tangle_multiplexed_transition_new();
TangleTransition* tangle_multiplexed_transition_new_full(TangleTransition* show_transition, TangleTransition* move_transition, TangleTransition* hide_transition);

TangleTransition* tangle_multiplexed_transition_get_show_transition(TangleMultiplexedTransition* multiplexed_transition);
void tangle_multiplexed_transition_set_show_transition(TangleMultiplexedTransition* multiplexed_transition, TangleTransition* show_transition);
TangleTransition* tangle_multiplexed_transition_get_move_transition(TangleMultiplexedTransition* multiplexed_transition);
void tangle_multiplexed_transition_set_move_transition(TangleMultiplexedTransition* multiplexed_transition, TangleTransition* move_transition);
TangleTransition* tangle_multiplexed_transition_get_hide_transition(TangleMultiplexedTransition* multiplexed_transition);
void tangle_multiplexed_transition_set_hide_transition(TangleMultiplexedTransition* multiplexed_transition, TangleTransition* hide_transition);

#endif
