/*
 * tangle-style.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_STYLE_H__
#define __TANGLE_STYLE_H__

#include "tangle-properties.h"

#define TANGLE_TYPE_STYLE (tangle_style_get_type())
#define TANGLE_STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_STYLE, TangleStyle))
#define TANGLE_IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_STYLE))
#define TANGLE_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_STYLE, TangleStyleClass))
#define TANGLE_IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_STYLE))
#define TANGLE_STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_STYLE, TangleStyleClass))

typedef struct _TangleStylePrivate TangleStylePrivate;

typedef struct _TangleStyle {
	GObject parent_instance;
	TangleStylePrivate* priv;
} TangleStyle;

typedef struct _TangleStyleClass {
	GObjectClass parent_class;
	
	/* virtual functions */
	gboolean (*get_style_property)(TangleStyle* style, const gchar* name, GValue* value);
	void (*set_style_property)(TangleStyle* style, const gchar* name, const GValue* value);
	void (*foreach_style_property)(TangleStyle* style, TanglePropertyCallback callback, gpointer user_data);
} TangleStyleClass;

GType tangle_style_get_type(void) G_GNUC_CONST;

TangleStyle* tangle_style_new(GType for_type);

GType tangle_style_get_for_type(TangleStyle* style);
const gchar* tangle_style_get_for_class(TangleStyle* style);
const gchar* tangle_style_get_for_name(TangleStyle* style);
void tangle_style_set_for_name(TangleStyle* style, const gchar* for_name);
gboolean tangle_style_get_for_subclasses(TangleStyle* style);
void tangle_style_set_for_subclasses(TangleStyle* style, gboolean for_subclasses);

gboolean tangle_style_get_style_property(TangleStyle* style, const gchar* name, GValue* value);
void tangle_style_set_style_property(TangleStyle* style, const gchar* name, const GValue* value);
void tangle_style_foreach_style_property(TangleStyle* style, TanglePropertyCallback callback, gpointer user_data);

gboolean tangle_style_is_for_object(TangleStyle* style, GObject* object);
void tangle_style_apply(TangleStyle* style, GObject* object);
void tangle_style_unapply(TangleStyle* style, GObject* object);

TangleStyle* tangle_object_get_style(GObject* object);
gboolean tangle_object_is_style_property(GObject* object, const gchar* name);

#endif
