/*
 * tangle-private.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_PRIVATE_H__
#define __TANGLE_PRIVATE_H__

#include <clutter/clutter.h>
#include "tangle-template.h"

gboolean _tangle_scriptable_parse_custom_node(ClutterScriptable* scriptable, ClutterScript* script, GValue* value, const gchar* name, JsonNode* node, TangleTemplate* template, gboolean* template_applied_return);
gboolean _tangle_scriptable_set_custom_property(ClutterScriptable* scriptable, ClutterScript* script, const gchar* name, const GValue* value);

gchar* _tangle_script_lookup_filename(ClutterScript* script, const gchar* filename);

#endif
