/*
 * tangle-stack-layout.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */
#ifndef __TANGLE_STACK_LAYOUT_H__
#define __TANGLE_STACK_LAYOUT_H__

#include "tangle-layout.h"

#define TANGLE_TYPE_STACK_LAYOUT (tangle_stack_layout_get_type())
#define TANGLE_STACK_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_STACK_LAYOUT, TangleStackLayout))
#define TANGLE_IS_STACK_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_STACK_LAYOUT))
#define TANGLE_STACK_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_STACK_LAYOUT, TangleStackLayoutClass))
#define TANGLE_IS_STACK_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_STACK_LAYOUT))
#define TANGLE_STACK_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_STACK_LAYOUT, TangleStackLayoutClass))

typedef struct _TangleStackLayoutPrivate TangleStackLayoutPrivate;

typedef struct _TangleStackLayout {
	TangleLayout parent_instance;
} TangleStackLayout;

typedef struct _TangleStackLayoutClass {
	TangleLayoutClass parent_class;
} TangleStackLayoutClass;

GType tangle_stack_layout_get_type(void) G_GNUC_CONST;

TangleLayout* tangle_stack_layout_new();

#endif
