/*
 * tangle-template.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_TEMPLATE_H__
#define __TANGLE_TEMPLATE_H__

#include "tangle-properties.h"

#define TANGLE_TYPE_TEMPLATE (tangle_template_get_type())
#define TANGLE_TEMPLATE(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_TEMPLATE, TangleTemplate))
#define TANGLE_IS_TEMPLATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_TEMPLATE))
#define TANGLE_TEMPLATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_TEMPLATE, TangleTemplateClass))
#define TANGLE_IS_TEMPLATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_TEMPLATE))
#define TANGLE_TEMPLATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_TEMPLATE, TangleTemplateClass))

typedef struct _TangleTemplatePrivate TangleTemplatePrivate;

typedef struct _TangleTemplate {
	TangleProperties parent_instance;
	TangleTemplatePrivate* priv;
} TangleTemplate;

typedef struct _TangleTemplateClass {
	TanglePropertiesClass parent_class;
} TangleTemplateClass;

GType tangle_template_get_type(void) G_GNUC_CONST;

TangleTemplate* tangle_template_new(GType type);
/* TangleTemplate* tangle_template_new_with_properties(GType type, const gchar* first_property, GType first_type, ...); */

GType tangle_template_get_object_type(TangleTemplate* template);
GObject* tangle_template_create_object(TangleTemplate* template);

#endif
