/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    int modelHandle;
    static final int TEXT_COLUMN = 0;

    public List(Composite composite, int n) {
        super(composite, List.checkStyle(n));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (n == 0) {
            this.error(14);
        }
        OS.gtk_list_store_append(this.modelHandle, n);
        OS.gtk_list_store_set(this.modelHandle, n, 0, byArray, -1);
        OS.g_free(n);
    }

    public void add(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (0 > n || n > n2) {
            this.error(6);
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n3 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (n3 == 0) {
            this.error(14);
        }
        if (n == n2) {
            OS.gtk_list_store_append(this.modelHandle, n3);
        } else {
            OS.gtk_list_store_insert(this.modelHandle, n3, n);
        }
        OS.gtk_list_store_set(this.modelHandle, n3, 0, byArray, -1);
        OS.g_free(n3);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return List.checkBits(n, 4, 2, 0, 0, 0, 0);
    }

    @Override
    void createHandle(int n) {
        int n2;
        int n3;
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.scrolledHandle = OS.gtk_scrolled_window_new(0, 0);
        if (this.scrolledHandle == 0) {
            this.error(2);
        }
        int[] nArray = new int[]{OS.G_TYPE_STRING()};
        this.modelHandle = OS.gtk_list_store_newv(nArray.length, nArray);
        if (this.modelHandle == 0) {
            this.error(2);
        }
        this.handle = OS.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((n3 = OS.gtk_cell_renderer_text_new()) == 0) {
            this.error(2);
        }
        if ((n2 = OS.gtk_tree_view_column_new()) == 0) {
            this.error(2);
        }
        OS.gtk_tree_view_column_pack_start(n2, n3, true);
        OS.gtk_tree_view_column_add_attribute(n2, n3, OS.text, 0);
        OS.gtk_tree_view_insert_column(this.handle, n2, n);
        OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
        OS.gtk_container_add(this.scrolledHandle, this.handle);
        int n4 = (this.style & 2) != 0 ? 3 : 2;
        int n5 = OS.gtk_tree_view_get_selection(this.handle);
        OS.gtk_tree_selection_set_mode(n5, n4);
        OS.gtk_tree_view_set_headers_visible(this.handle, false);
        int n6 = (this.style & 0x100) != 0 ? 1 : 2;
        int n7 = (this.style & 0x200) != 0 ? 1 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, n6, n7);
        if ((this.style & 0x800) != 0) {
            OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
        }
        if ((this.getShell().style & 0x4000) != 0) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        }
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        point.x = rectangle.width;
        point.y = rectangle.height;
        return point;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(OS.gtk_tree_view_get_selection(this.handle));
    }

    public void deselect(int n) {
        this.checkWidget();
        if (0 > n || n >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            return;
        }
        int n2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int n3 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, n2, 0, n);
        OS.gtk_tree_selection_unselect_iter(n3, n2);
        OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
        OS.g_free(n2);
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        if (n < 0 && n2 < 0) {
            return;
        }
        int n3 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (n >= n3 && n2 >= n3) {
            return;
        }
        n = Math.min(n3 - 1, Math.max(0, n));
        n2 = Math.min(n3 - 1, Math.max(0, n2));
        int n4 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int n5 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n5, 16, 0, 0, 0, 0, 6);
        for (int i = n; i <= n2; ++i) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, n4, 0, i);
            OS.gtk_tree_selection_unselect_iter(n5, n4);
        }
        OS.g_signal_handlers_unblock_matched(n5, 16, 0, 0, 0, 0, 6);
        OS.g_free(n4);
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        int n = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int n2 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        int n3 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            if (n4 < 0 || n4 > n2 - 1) continue;
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, n, 0, n4);
            OS.gtk_tree_selection_unselect_iter(n3, n);
        }
        OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
        OS.g_free(n);
    }

    public void deselectAll() {
        this.checkWidget();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_unselect_all(n);
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
    }

    @Override
    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        boolean bl2;
        boolean bl3 = false;
        if (bl) {
            int[] nArray = new int[1];
            if (OS.gtk_tree_view_get_path_at_pos(this.handle, n, n2, nArray, null, null, null)) {
                if (nArray[0] != 0) {
                    int n3 = OS.gtk_tree_view_get_selection(this.handle);
                    if (OS.gtk_tree_selection_path_is_selected(n3, nArray[0])) {
                        bl3 = true;
                    }
                    OS.gtk_tree_path_free(nArray[0]);
                }
            } else {
                return false;
            }
        }
        if ((bl2 = super.dragDetect(n, n2, bl, blArray)) && bl3 && blArray != null) {
            blArray[0] = true;
        }
        return bl2;
    }

    @Override
    int eventWindow() {
        return this.paintWindow();
    }

    @Override
    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public int getFocusIndex() {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.gtk_tree_view_get_cursor(this.handle, nArray, null);
        if (nArray[0] == 0) {
            return -1;
        }
        int n = OS.gtk_tree_path_get_indices(nArray[0]);
        int[] nArray2 = new int[]{-1};
        if (n != 0) {
            OS.memmove(nArray2, n, 4);
        }
        OS.gtk_tree_path_free(nArray[0]);
        return nArray2[0];
    }

    @Override
    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public String getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            this.error(6);
        }
        int[] nArray = new int[1];
        int n2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, n2, 0, n);
        OS.gtk_tree_model_get(this.modelHandle, n2, 0, nArray, -1);
        OS.g_free(n2);
        if (nArray[0] == 0) {
            return null;
        }
        int n3 = OS.strlen(nArray[0]);
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, nArray[0], n3);
        OS.g_free(nArray[0]);
        return new String(Converter.mbcsToWcs(null, byArray));
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
    }

    public int getItemHeight() {
        this.checkWidget();
        int n = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        int n2 = OS.gtk_tree_view_get_column(this.handle, 0);
        if (n == 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_tree_view_column_cell_get_size(n2, null, null, null, nArray, nArray2);
            return nArray2[0];
        }
        int n3 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_get_iter_first(this.modelHandle, n3);
        OS.gtk_tree_view_column_cell_set_cell_data(n2, this.modelHandle, n3, false, false);
        int[] nArray = new int[1];
        int[] nArray3 = new int[1];
        OS.gtk_tree_view_column_cell_get_size(n2, null, null, null, nArray, nArray3);
        OS.g_free(n3);
        return nArray3[0];
    }

    public String[] getItems() {
        this.checkWidget();
        int n = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        int[] nArray = new int[1];
        String[] stringArray = new String[n];
        int n2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        for (int i = 0; i < n; ++i) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, n2, 0, i);
            OS.gtk_tree_model_get(this.modelHandle, n2, 0, nArray, -1);
            if (nArray[0] == 0) continue;
            int n3 = OS.strlen(nArray[0]);
            byte[] byArray = new byte[n3];
            OS.memmove(byArray, nArray[0], n3);
            OS.g_free(nArray[0]);
            stringArray[i] = new String(Converter.mbcsToWcs(null, byArray));
        }
        OS.g_free(n2);
        return stringArray;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] nArray = this.getSelectionIndices();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.getItem(nArray[i]);
        }
        return stringArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            this.display.treeSelectionLength = 0;
            this.display.treeSelection = null;
            OS.gtk_tree_selection_selected_foreach(n, this.display.treeSelectionProc, this.handle);
            return this.display.treeSelectionLength;
        }
        return OS.gtk_tree_selection_count_selected_rows(n);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            int n2 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
            this.display.treeSelectionLength = 0;
            this.display.treeSelection = new int[n2];
            OS.gtk_tree_selection_selected_foreach(n, this.display.treeSelectionProc, this.handle);
            if (this.display.treeSelectionLength == 0) {
                return -1;
            }
            return this.display.treeSelection[0];
        }
        int[] nArray = OS.GTK_VERSION < OS.VERSION(2, 2, 4) ? new int[1] : null;
        int n3 = OS.gtk_tree_selection_get_selected_rows(n, nArray);
        if (n3 != 0) {
            int n4 = OS.g_list_length(n3);
            int[] nArray2 = new int[1];
            for (int i = 0; i < n4; ++i) {
                int n5 = OS.g_list_nth_data(n3, i);
                int n6 = OS.gtk_tree_path_get_indices(n5);
                if (n6 == 0) continue;
                OS.memmove(nArray2, n6, 4);
                break;
            }
            OS.g_list_free(n3);
            return nArray2[0];
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            int n2 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
            this.display.treeSelectionLength = 0;
            this.display.treeSelection = new int[n2];
            OS.gtk_tree_selection_selected_foreach(n, this.display.treeSelectionProc, this.handle);
            if (this.display.treeSelectionLength == this.display.treeSelection.length) {
                return this.display.treeSelection;
            }
            int[] nArray = new int[this.display.treeSelectionLength];
            System.arraycopy(this.display.treeSelection, 0, nArray, 0, this.display.treeSelectionLength);
            return nArray;
        }
        int[] nArray = OS.GTK_VERSION < OS.VERSION(2, 2, 4) ? new int[1] : null;
        int n3 = OS.gtk_tree_selection_get_selected_rows(n, nArray);
        if (n3 != 0) {
            int n4 = OS.g_list_length(n3);
            int[] nArray2 = new int[n4];
            int n5 = 0;
            for (int i = 0; i < n4; ++i) {
                int n6 = OS.g_list_nth_data(n3, i);
                int n7 = OS.gtk_tree_path_get_indices(n6);
                if (n7 == 0) continue;
                int[] nArray3 = new int[1];
                OS.memmove(nArray3, n7, 4);
                nArray2[n5] = nArray3[0];
                ++n5;
            }
            OS.g_list_free(n3);
            int[] nArray4 = new int[n5];
            System.arraycopy(nArray2, 0, nArray4, 0, n5);
            return nArray4;
        }
        return new int[0];
    }

    public int getTopIndex() {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, nArray, null, null, null)) {
            return 0;
        }
        if (nArray[0] == 0) {
            return 0;
        }
        int n = OS.gtk_tree_path_get_indices(nArray[0]);
        int[] nArray2 = new int[1];
        if (n != 0) {
            OS.memmove(nArray2, n, 4);
        }
        OS.gtk_tree_path_free(nArray[0]);
        return nArray2[0];
    }

    @Override
    int gtk_changed(int n) {
        this.postEvent(13);
        return 0;
    }

    @Override
    int gtk_button_press_event(int n, int n2) {
        int n3;
        int[] nArray;
        int n4 = super.gtk_button_press_event(n, n2);
        if (n4 != 0) {
            return n4;
        }
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        int n5 = gdkEventButton.button;
        if (n5 == 3 && gdkEventButton.type == 4 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEventButton.x, (int)gdkEventButton.y, nArray = new int[1], null, null, null) && nArray[0] != 0) {
            n3 = OS.gtk_tree_view_get_selection(this.handle);
            if (OS.gtk_tree_selection_path_is_selected(n3, nArray[0])) {
                n4 = 1;
            }
            OS.gtk_tree_path_free(nArray[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEventButton.x, (int)gdkEventButton.y, nArray = new int[1], null, null, null) && nArray[0] != 0) {
            n3 = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
            OS.gtk_tree_view_set_cursor(this.handle, nArray[0], 0, false);
            OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
            OS.gtk_tree_path_free(nArray[0]);
        }
        if (!OS.GTK_WIDGET_HAS_FOCUS(this.handle)) {
            OS.gtk_widget_grab_focus(this.handle);
        }
        return n4;
    }

    @Override
    int gtk_key_press_event(int n, int n2) {
        int n3 = super.gtk_key_press_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
            int n4 = gdkEventKey.keyval;
            switch (n4) {
                case 65293: 
                case 65421: {
                    this.postEvent(14);
                }
            }
        }
        return n3;
    }

    @Override
    int gtk_popup_menu(int n) {
        int n2 = super.gtk_popup_menu(n);
        return OS.GTK_VERSION < OS.VERSION(2, 6, 5) ? 1 : n2;
    }

    @Override
    int gtk_row_activated(int n, int n2, int n3) {
        this.postEvent(14);
        return 0;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(n, OS.changed, this.display.closures[6], false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.closures[41], false);
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        String[] stringArray = this.getItems();
        for (int i = n; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        int n2 = OS.gtk_tree_view_get_selection(this.handle);
        byte[] byArray = Converter.wcsToMbcs(null, Integer.toString(n), true);
        int n3 = OS.gtk_tree_path_new_from_string(byArray);
        boolean bl = OS.gtk_tree_selection_path_is_selected(n2, n3);
        OS.gtk_tree_path_free(n3);
        return bl;
    }

    @Override
    int paintWindow() {
        OS.gtk_widget_realize(this.handle);
        return OS.gtk_tree_view_get_bin_window(this.handle);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(OS.gtk_tree_view_get_selection(this.handle), this);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0;
    }

    public void remove(int n) {
        this.checkWidget();
        if (0 > n || n >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            this.error(6);
        }
        int n2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, n2, 0, n);
        int n3 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
        OS.gtk_list_store_remove(this.modelHandle, n2);
        OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
        OS.g_free(n2);
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (0 > n || n > n2 || n2 >= n3) {
            this.error(6);
        }
        int n4 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int n5 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n5, 16, 0, 0, 0, 0, 6);
        for (int i = n2; i >= n; --i) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, n4, 0, i);
            OS.gtk_list_store_remove(this.modelHandle, n4);
        }
        OS.g_signal_handlers_unblock_matched(n5, 16, 0, 0, 0, 0, 6);
        OS.g_free(n4);
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        int n3 = this.getItemCount();
        if (0 > n || n > n2 || n2 >= n3) {
            this.error(6);
        }
        int n4 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int n5 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n5, 16, 0, 0, 0, 0, 6);
        int n6 = -1;
        for (int i = 0; i < nArray2.length; ++i) {
            int n7 = nArray2[i];
            if (n7 == n6) continue;
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, n4, 0, n7);
            OS.gtk_list_store_remove(this.modelHandle, n4);
            n6 = n7;
        }
        OS.g_signal_handlers_unblock_matched(n5, 16, 0, 0, 0, 0, 6);
        OS.g_free(n4);
    }

    public void removeAll() {
        this.checkWidget();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        OS.gtk_list_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (0 > n || n >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            return;
        }
        int n2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int n3 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, n2, 0, n);
        OS.gtk_tree_selection_select_iter(n3, n2);
        if ((this.style & 4) != 0) {
            int n4 = OS.gtk_tree_model_get_path(this.modelHandle, n2);
            OS.gtk_tree_view_set_cursor(this.handle, n4, 0, false);
            OS.gtk_tree_path_free(n4);
        }
        OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
        OS.g_free(n2);
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        int n3 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (n3 == 0 || n >= n3) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        int n4 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int n5 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n5, 16, 0, 0, 0, 0, 6);
        for (int i = n; i <= n2; ++i) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, n4, 0, i);
            OS.gtk_tree_selection_select_iter(n5, n4);
            if ((this.style & 4) == 0) continue;
            int n6 = OS.gtk_tree_model_get_path(this.modelHandle, n4);
            OS.gtk_tree_view_set_cursor(this.handle, n6, 0, false);
            OS.gtk_tree_path_free(n6);
        }
        OS.g_signal_handlers_unblock_matched(n5, 16, 0, 0, 0, 0, 6);
        OS.g_free(n4);
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int n2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        int n3 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        int n4 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n4, 16, 0, 0, 0, 0, 6);
        for (int i = 0; i < n; ++i) {
            int n5 = nArray[i];
            if (0 > n5 || n5 >= n3) continue;
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, n2, 0, n5);
            OS.gtk_tree_selection_select_iter(n4, n2);
            if ((this.style & 4) == 0) continue;
            int n6 = OS.gtk_tree_model_get_path(this.modelHandle, n2);
            OS.gtk_tree_view_set_cursor(this.handle, n6, 0, false);
            OS.gtk_tree_path_free(n6);
        }
        OS.g_signal_handlers_unblock_matched(n4, 16, 0, 0, 0, 0, 6);
        OS.g_free(n2);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_select_all(n);
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
    }

    void selectFocusIndex(int n) {
        int n2 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (0 > n || n >= n2) {
            return;
        }
        int n3 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, n3, 0, n);
        int n4 = OS.gtk_tree_model_get_path(this.modelHandle, n3);
        int n5 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n5, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_view_set_cursor(this.handle, n4, 0, false);
        OS.gtk_tree_selection_select_iter(n5, n3);
        OS.g_signal_handlers_unblock_matched(n5, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_path_free(n4);
        OS.g_free(n3);
    }

    @Override
    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        OS.gtk_widget_modify_base(this.handle, 0, gdkColor);
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        OS.gtk_widget_realize(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 6, 0) && OS.gtk_tree_model_iter_n_children(this.modelHandle, 0) == 0) {
            this.redraw(false);
        }
        return n5;
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            this.error(6);
        }
        int n2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, n2, 0, n);
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        OS.gtk_list_store_set(this.modelHandle, n2, 0, byArray, -1);
        OS.g_free(n2);
    }

    public void setItems(String[] stringArray) {
        int n;
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null) continue;
            this.error(5);
        }
        n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        OS.gtk_list_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
        int n2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (n2 == 0) {
            this.error(14);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            OS.gtk_list_store_append(this.modelHandle, n2);
            OS.gtk_list_store_set(this.modelHandle, n2, 0, byArray, -1);
        }
        OS.g_free(n2);
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.deselectAll();
        this.selectFocusIndex(n);
        this.showSelection();
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        int n3 = OS.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (n3 == 0 || n >= n3) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        this.selectFocusIndex(n);
        if ((this.style & 2) != 0) {
            this.select(n, n2);
        }
        this.showSelection();
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        this.selectFocusIndex(nArray[0]);
        if ((this.style & 2) != 0) {
            this.select(nArray);
        }
        this.showSelection();
    }

    public void setSelection(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = stringArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        boolean bl = true;
        block0: for (int i = 0; i < n; ++i) {
            int n2 = 0;
            String string = stringArray[i];
            if (string == null) continue;
            while ((n2 = this.indexOf(string, n2)) != -1) {
                if ((this.style & 2) != 0) {
                    if (bl) {
                        bl = false;
                        this.selectFocusIndex(n2);
                    } else {
                        this.select(n2);
                    }
                } else {
                    this.selectFocusIndex(n2);
                    continue block0;
                }
                ++n2;
            }
        }
        this.showSelection();
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if (0 > n || n >= OS.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            return;
        }
        int n2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, n2, 0, n);
        int n3 = OS.gtk_tree_model_get_path(this.modelHandle, n2);
        OS.gtk_tree_view_scroll_to_cell(this.handle, n3, 0, true, 0.0f, 0.0f);
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            OS.gtk_widget_realize(this.handle);
            GdkRectangle gdkRectangle = new GdkRectangle();
            OS.gtk_tree_view_get_cell_area(this.handle, n3, 0, gdkRectangle);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_tree_view_widget_to_tree_coords(this.handle, gdkRectangle.x, gdkRectangle.y, nArray, nArray2);
            OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
        }
        OS.gtk_tree_path_free(n3);
        OS.g_free(n2);
    }

    public void showSelection() {
        this.checkWidget();
        int n = this.getSelectionIndex();
        if (n == -1) {
            return;
        }
        int n2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_iter_nth_child(this.modelHandle, n2, 0, n);
        int n3 = OS.gtk_tree_model_get_path(this.modelHandle, n2);
        OS.gtk_widget_realize(this.handle);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_tree_view_get_visible_rect(this.handle, gdkRectangle);
        GdkRectangle gdkRectangle2 = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(this.handle, n3, 0, gdkRectangle2);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_tree_view_widget_to_tree_coords(this.handle, gdkRectangle2.x, gdkRectangle2.y, nArray, nArray2);
        if (nArray2[0] < gdkRectangle.y) {
            OS.gtk_tree_view_scroll_to_cell(this.handle, n3, 0, true, 0.0f, 0.0f);
            OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
        } else {
            int n4 = Math.min(gdkRectangle.height, gdkRectangle2.height);
            if (nArray2[0] + n4 > gdkRectangle.y + gdkRectangle.height) {
                OS.gtk_tree_view_scroll_to_cell(this.handle, n3, 0, true, 1.0f, 0.0f);
                nArray2[0] = nArray2[0] + (gdkRectangle2.height - gdkRectangle.height);
                OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
            }
        }
        OS.gtk_tree_path_free(n3);
        OS.g_free(n2);
    }

    @Override
    int treeSelectionProc(int n, int n2, int n3, int[] nArray, int n4) {
        int n5;
        if (nArray != null && (n5 = OS.gtk_tree_path_get_indices(n2)) != 0) {
            int[] nArray2 = new int[1];
            OS.memmove(nArray2, n5, 4);
            nArray[n4] = nArray2[0];
        }
        return 0;
    }
}

