//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qvariant_c.h"

QVariantH QVariant_create()
{
	return (QVariantH) new QVariant();
}

void QVariant_destroy(QVariantH handle)
{
	delete (QVariant *)handle;
}

QVariantH QVariant_create2(QVariant::Type type)
{
	return (QVariantH) new QVariant(type);
}

QVariantH QVariant_create3(int typeOrUserType, const void* copy)
{
	return (QVariantH) new QVariant(typeOrUserType, copy);
}

QVariantH QVariant_create4(int typeOrUserType, const void* copy, uint flags)
{
	return (QVariantH) new QVariant(typeOrUserType, copy, flags);
}

QVariantH QVariant_create5(const QVariantH other)
{
	return (QVariantH) new QVariant(*(const QVariant*)other);
}

QVariantH QVariant_create6(QDataStreamH s)
{
	return (QVariantH) new QVariant(*(QDataStream*)s);
}

QVariantH QVariant_create9(qlonglong ll)
{
	return (QVariantH) new QVariant(ll);
}

QVariantH QVariant_create10(qulonglong ull)
{
	return (QVariantH) new QVariant(ull);
}

QVariantH QVariant_create11(bool b)
{
	return (QVariantH) new QVariant(b);
}

QVariantH QVariant_create12(double d)
{
	return (QVariantH) new QVariant(d);
}

QVariantH QVariant_create13(float f)
{
	return (QVariantH) new QVariant(f);
}

QVariantH QVariant_create14(const char* str)
{
	return (QVariantH) new QVariant(str);
}

QVariantH QVariant_create15(const QByteArrayH bytearray)
{
	return (QVariantH) new QVariant(*(const QByteArray*)bytearray);
}

QVariantH QVariant_create16(const QBitArrayH bitarray)
{
	return (QVariantH) new QVariant(*(const QBitArray*)bitarray);
}

QVariantH QVariant_create17(PWideString string)
{
	QString t_string;
	copyPWideStringToQString(string, t_string);
	return (QVariantH) new QVariant(t_string);
}

QVariantH QVariant_create18(const QLatin1StringH string)
{
	return (QVariantH) new QVariant(*(const QLatin1String*)string);
}

QVariantH QVariant_create19(const QStringListH stringlist)
{
	return (QVariantH) new QVariant(*(const QStringList*)stringlist);
}

QVariantH QVariant_create20(const QCharH qchar)
{
	return (QVariantH) new QVariant(*(const QChar*)qchar);
}

QVariantH QVariant_create21(const QDateH date)
{
	return (QVariantH) new QVariant(*(const QDate*)date);
}

QVariantH QVariant_create25(const QSizeFH size)
{
	return (QVariantH) new QVariant(*(const QSizeF*)size);
}

QVariantH QVariant_create26(const QPointH pt)
{
	return (QVariantH) new QVariant(*(const QPoint*)pt);
}

QVariantH QVariant_create27(const QPointFH pt)
{
	return (QVariantH) new QVariant(*(const QPointF*)pt);
}

QVariantH QVariant_create28(const QLineH line)
{
	return (QVariantH) new QVariant(*(const QLine*)line);
}

QVariantH QVariant_create29(const QLineFH line)
{
	return (QVariantH) new QVariant(*(const QLineF*)line);
}

QVariantH QVariant_create30(PRect rect)
{
	QRect t_rect;
	copyPRectToQRect(rect, t_rect);
	return (QVariantH) new QVariant(t_rect);
}

QVariantH QVariant_create31(const QRectFH rect)
{
	return (QVariantH) new QVariant(*(const QRectF*)rect);
}

QVariantH QVariant_create32(const QUrlH url)
{
	return (QVariantH) new QVariant(*(const QUrl*)url);
}

QVariantH QVariant_create33(const QLocaleH locale)
{
	return (QVariantH) new QVariant(*(const QLocale*)locale);
}

QVariantH QVariant_create34(const QRegExpH regExp)
{
	return (QVariantH) new QVariant(*(const QRegExp*)regExp);
}

QVariantH QVariant_create35(Qt::GlobalColor color)
{
	return (QVariantH) new QVariant(color);
}

QVariant::Type QVariant_type(QVariantH handle)
{
	return (QVariant::Type) ((QVariant *)handle)->type();
}

int QVariant_userType(QVariantH handle)
{
	return (int) ((QVariant *)handle)->userType();
}

const char* QVariant_typeName(QVariantH handle)
{
	return (const char*) ((QVariant *)handle)->typeName();
}

bool QVariant_canConvert(QVariantH handle, QVariant::Type t)
{
	return (bool) ((QVariant *)handle)->canConvert(t);
}

bool QVariant_convert(QVariantH handle, QVariant::Type t)
{
	return (bool) ((QVariant *)handle)->convert(t);
}

bool QVariant_isValid(QVariantH handle)
{
	return (bool) ((QVariant *)handle)->isValid();
}

bool QVariant_isNull(QVariantH handle)
{
	return (bool) ((QVariant *)handle)->isNull();
}

void QVariant_clear(QVariantH handle)
{
	((QVariant *)handle)->clear();
}

void QVariant_detach(QVariantH handle)
{
	((QVariant *)handle)->detach();
}

bool QVariant_isDetached(QVariantH handle)
{
	return (bool) ((QVariant *)handle)->isDetached();
}

int QVariant_toInt(QVariantH handle, bool* ok)
{
	return (int) ((QVariant *)handle)->toInt(ok);
}

uint QVariant_toUInt(QVariantH handle, bool* ok)
{
	return (uint) ((QVariant *)handle)->toUInt(ok);
}

qlonglong QVariant_toLongLong(QVariantH handle, bool* ok)
{
	return (qlonglong) ((QVariant *)handle)->toLongLong(ok);
}

qulonglong QVariant_toULongLong(QVariantH handle, bool* ok)
{
	return (qulonglong) ((QVariant *)handle)->toULongLong(ok);
}

bool QVariant_toBool(QVariantH handle)
{
	return (bool) ((QVariant *)handle)->toBool();
}

double QVariant_toDouble(QVariantH handle, bool* ok)
{
	return (double) ((QVariant *)handle)->toDouble(ok);
}

float QVariant_toFloat(QVariantH handle, bool* ok)
{
	return (float) ((QVariant *)handle)->toFloat(ok);
}

qreal QVariant_toReal(QVariantH handle, bool* ok)
{
	return (qreal) ((QVariant *)handle)->toReal(ok);
}

void QVariant_toByteArray(QVariantH handle, QByteArrayH retval)
{
	*(QByteArray *)retval = ((QVariant *)handle)->toByteArray();
}

void QVariant_toBitArray(QVariantH handle, QBitArrayH retval)
{
	*(QBitArray *)retval = ((QVariant *)handle)->toBitArray();
}

void QVariant_toString(QVariantH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QVariant *)handle)->toString();
	copyQStringToPWideString(t_retval, retval);
}

void QVariant_toStringList(QVariantH handle, QStringListH retval)
{
	*(QStringList *)retval = ((QVariant *)handle)->toStringList();
}

void QVariant_toChar(QVariantH handle, PWideChar retval)
{
	*(QChar *)retval = ((QVariant *)handle)->toChar();
}

void QVariant_toDate(QVariantH handle, QDateH retval)
{
	*(QDate *)retval = ((QVariant *)handle)->toDate();
}

void QVariant_toTime(QVariantH handle, QTimeH retval)
{
	*(QTime *)retval = ((QVariant *)handle)->toTime();
}

void QVariant_toDateTime(QVariantH handle, QDateTimeH retval)
{
	*(QDateTime *)retval = ((QVariant *)handle)->toDateTime();
}

void QVariant_toPoint(QVariantH handle, PQtPoint retval)
{
	*(QPoint *)retval = ((QVariant *)handle)->toPoint();
}

void QVariant_toPointF(QVariantH handle, PQtPointF retval)
{
	*(QPointF *)retval = ((QVariant *)handle)->toPointF();
}

void QVariant_toRect(QVariantH handle, PRect retval)
{
	QRect t_retval;
	t_retval = ((QVariant *)handle)->toRect();
	copyQRectToPRect(t_retval, retval);
}

void QVariant_toSize(QVariantH handle, PSize retval)
{
	*(QSize *)retval = ((QVariant *)handle)->toSize();
}

void QVariant_toSizeF(QVariantH handle, QSizeFH retval)
{
	*(QSizeF *)retval = ((QVariant *)handle)->toSizeF();
}

void QVariant_toLine(QVariantH handle, QLineH retval)
{
	*(QLine *)retval = ((QVariant *)handle)->toLine();
}

void QVariant_toLineF(QVariantH handle, QLineFH retval)
{
	*(QLineF *)retval = ((QVariant *)handle)->toLineF();
}

void QVariant_toRectF(QVariantH handle, QRectFH retval)
{
	*(QRectF *)retval = ((QVariant *)handle)->toRectF();
}

void QVariant_toUrl(QVariantH handle, QUrlH retval)
{
	*(QUrl *)retval = ((QVariant *)handle)->toUrl();
}

void QVariant_toLocale(QVariantH handle, QLocaleH retval)
{
	*(QLocale *)retval = ((QVariant *)handle)->toLocale();
}

void QVariant_toRegExp(QVariantH handle, QRegExpH retval)
{
	*(QRegExp *)retval = ((QVariant *)handle)->toRegExp();
}

void QVariant_load(QVariantH handle, QDataStreamH ds)
{
	((QVariant *)handle)->load(*(QDataStream*)ds);
}

void QVariant_save(QVariantH handle, QDataStreamH ds)
{
	((QVariant *)handle)->save(*(QDataStream*)ds);
}

const char* QVariant_typeToName(QVariant::Type type)
{
	return (const char*) QVariant::typeToName(type);
}

QVariant::Type QVariant_nameToType(const char* name)
{
	return (QVariant::Type) QVariant::nameToType(name);
}

const void* QVariant_constData(QVariantH handle)
{
	return (const void*) ((QVariant *)handle)->constData();
}

