//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qmaemo5timepickselector_c.h"

#if defined MAEMO5
QMaemo5TimePickSelectorH QMaemo5TimePickSelector_create(QObjectH parent)
{
	return (QMaemo5TimePickSelectorH) new QMaemo5TimePickSelector((QObject*)parent);
}

void QMaemo5TimePickSelector_destroy(QMaemo5TimePickSelectorH handle)
{
	delete (QMaemo5TimePickSelector *)handle;
}

QWidgetH QMaemo5TimePickSelector_widget(QMaemo5TimePickSelectorH handle, QWidgetH parent)
{
	return (QWidgetH) ((QMaemo5TimePickSelector *)handle)->widget((QWidget*)parent);
}

void QMaemo5TimePickSelector_currentTime(QMaemo5TimePickSelectorH handle, QTimeH retval)
{
	*(QTime *)retval = ((QMaemo5TimePickSelector *)handle)->currentTime();
}

void QMaemo5TimePickSelector_setCurrentTime(QMaemo5TimePickSelectorH handle, const QTimeH time)
{
	((QMaemo5TimePickSelector *)handle)->setCurrentTime(*(const QTime*)time);
}

int QMaemo5TimePickSelector_minuteStep(QMaemo5TimePickSelectorH handle)
{
	return (int) ((QMaemo5TimePickSelector *)handle)->minuteStep();
}

void QMaemo5TimePickSelector_setMinuteStep(QMaemo5TimePickSelectorH handle, int step)
{
	((QMaemo5TimePickSelector *)handle)->setMinuteStep(step);
}

void QMaemo5TimePickSelector_currentValueText(QMaemo5TimePickSelectorH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QMaemo5TimePickSelector *)handle)->currentValueText();
	copyQStringToPWideString(t_retval, retval);
}

#endif
