//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QMAEMO5INFORMATIONBOX_HOOK_H
#define QMAEMO5INFORMATIONBOX_HOOK_H

#include <qmaemo5informationbox.h>

#include "qdialog_hook.h"

class QMaemo5InformationBox_hook : public QDialog_hook {
  Q_OBJECT
  public:
    QMaemo5InformationBox_hook(QObject *handle) : QDialog_hook(handle) {
#if defined MAEMO5
      clicked_event.func = NULL;
#endif
    }
#if defined MAEMO5
    void hook_clicked(QHook &hook) { 
      if ( !clicked_event.func )
        connect(handle, SIGNAL(clicked()), this, SLOT(clicked_hook()));
      clicked_event = hook;
      if ( !hook.func )
        disconnect(handle, SIGNAL(clicked()), this, SLOT(clicked_hook()));
    }
#endif

#if defined MAEMO5
  private slots:
    void clicked_hook() {
      if ( clicked_event.func ) {
        typedef void (*func_type)(void *data);
	(*(func_type)clicked_event.func)(clicked_event.data);
      }
    }
#endif
#if defined MAEMO5
  private:
    QHook clicked_event;
#endif
};


#endif
