//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QMAEMO5ABSTRACTPICKSELECTOR_HOOK_H
#define QMAEMO5ABSTRACTPICKSELECTOR_HOOK_H

#include <qmaemo5abstractpickselector.h>

#include "qobject_hook.h"

class QMaemo5AbstractPickSelector_hook : public QObject_hook {
  Q_OBJECT
  public:
    QMaemo5AbstractPickSelector_hook(QObject *handle) : QObject_hook(handle) {
#if defined MAEMO5
      selected_event.func = NULL;
#endif
    }
#if defined MAEMO5
    void hook_selected(QHook &hook) { 
      if ( !selected_event.func )
        connect(handle, SIGNAL(selected(const QString&)), this, SLOT(selected_hook(const QString&)));
      selected_event = hook;
      if ( !hook.func )
        disconnect(handle, SIGNAL(selected(const QString&)), this, SLOT(selected_hook(const QString&)));
    }
#endif

#if defined MAEMO5
  private slots:
    void selected_hook(const QString& p1) {
      if ( selected_event.func ) {
        typedef void (*func_type)(void *data, PWideString p1);
	PWideString t_p1;
	initializePWideString(t_p1);
	copyQStringToPWideString(p1, t_p1);
	(*(func_type)selected_event.func)(selected_event.data, t_p1);
	finalizePWideString(t_p1);
      }
    }
#endif
#if defined MAEMO5
  private:
    QHook selected_event;
#endif
};


#endif
