#include <QtNetwork>
#include <QString>
#include <QChar>
#include <QObject>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QDebug>
#include <QNetworkCookie>
#include <QNetworkCookieJar>

#include "HttpConnector.h"

/* public functions */ 
HttpConnector::HttpConnector() {
    busy = false;
    http = new QNetworkAccessManager ();
    cache = new QNetworkDiskCache ();
    #ifdef Q_WS_MAEMO_5
        cache->setCacheDirectory ("/opt/appdownloader/meta/cache/");
    #else
        cache->setCacheDirectory ("/tmp/.maemoclient/");
    #endif
    cache->setMaximumCacheSize (100000);
    http->setCache(cache);
    timeout=10000;
    cookies = new QNetworkCookieJar(http);
    http->setCookieJar(cookies);

}

HttpConnector::HttpConnector(int _timeout,int _cacheSize) {
    busy = false;
    http = new QNetworkAccessManager ();
    cache = new QNetworkDiskCache ();
    #ifdef Q_WS_MAEMO_5
        cache->setCacheDirectory ("/opt/appdownloader/meta/cache/");
    #else
        cache->setCacheDirectory ("/tmp/.maemoclient/");
    #endif
    if (_cacheSize==0) {
        _cacheSize=10000;
    }
    cache->setMaximumCacheSize (_cacheSize);
    http->setCache (cache);
    if (_timeout==0)
        _timeout=10000;
    timeout=_timeout;
    cookies = new QNetworkCookieJar(http);
    http->setCookieJar(cookies);

}

void HttpConnector::setProxy (QString host,int port) {
    QNetworkProxy proxy;
    proxy.setType (QNetworkProxy::HttpProxy);
    proxy.setHostName (host);
    proxy.setPort (port);
    http->setProxy (proxy);
}

void HttpConnector::getRequest (QString url) {
    qDebug() << url;
    if (!busy) {
        busy = true;
        timer = new QTimer();

        QNetworkRequest req;
        req.setUrl (QUrl (url));
        req.setAttribute(QNetworkRequest::CacheLoadControlAttribute,QVariant ((int)QNetworkRequest::PreferCache));
        qDebug() << req.url().toString();

        /* now connect */
        reply = http->get (req);
        req.~QNetworkRequest();
        qDebug() << "connected";
        // read the data, which is received
        connect (reply, SIGNAL(readChannelFinished()), this, SLOT(readResponse ()));
        // timer for connection timeout
        connect (timer, SIGNAL(timeout()),this, SLOT (setRequestTimeout()));
        /* set network timeout */
        timer->start (10000);
     } else {
         qDebug() << "busy";
     }
}

bool HttpConnector::hasCookieForUrl(QUrl url) {
    if (http->cookieJar()->cookiesForUrl(url).length()>0) {
        return true;
    }
    else {
        return false;
    }
}

void HttpConnector::resetCookies() {
    delete cookies;
    cookies = new QNetworkCookieJar (http);
    http->setCookieJar(cookies);
}

void HttpConnector::postRequest(QUrl url, QByteArray data) {
    reply = http->post(QNetworkRequest (url),data);
    connect (reply,SIGNAL(readChannelFinished()), this,SLOT(readResponse()));
}

bool HttpConnector::isBusy() {
    qDebug()<<"** is busy **" << busy;
    return busy;
}

void HttpConnector::readResponse () {
        int bytes = reply->bytesAvailable();
        qDebug ()<< "is cached? -> "<<reply->attribute(QNetworkRequest::SourceIsFromCacheAttribute);
        qDebug()<<http->cookieJar()->cookiesForUrl(QUrl("https://maemo.org/"));
        if (bytes > 0) {
            response = reply->readAll();
            emit getResponseContent (response,reply->attribute(QNetworkRequest::HttpStatusCodeAttribute).toInt());
        } else {
            emit getResponseContent(QByteArray(),reply->attribute(QNetworkRequest::HttpStatusCodeAttribute).toInt());
        }

        reply->close();
        timer->stop();
        disconnect (reply, SIGNAL(readChannelFinished()), this, SLOT(readResponse ()));
        disconnect (timer, SIGNAL(timeout()),this, SLOT (setRequestTimeout()));
        busy = false;
        emit isFree();
        reply->reset();
}


/* private functions */

void HttpConnector::setRequestTimeout() {
    qDebug () << "timeout";
    disconnect (reply, SIGNAL(readChannelFinished()), this, SLOT(readResponse ()));
    disconnect (timer, SIGNAL(timeout()),this, SLOT (setRequestTimeout()));
    /* stop all requests when timeout occurs (see QTimer->timeout signal */
    reply->abort();
    busy=false;
    emit getResponseContent (reply->readAll(),0);
    reply->reset();
    emit isFree();
}
