#ifndef HTTPCONNECTOR_H
#define HTTPCONNECTOR_H

#include <QObject>
#include <QtNetwork>
#include <QTextStream>
#include <QTimer>
#include <QNetworkReply>
#include <QNetworkAccessManager>
#include <QNetworkDiskCache>
#include <QNetworkProxy>



class HttpConnector : public QObject {	
	Q_OBJECT
	
	public:
                //constructors
                HttpConnector();
                HttpConnector(int, int);

                 //deconstructor
        //        ~HttpConnector () {
          //          delete http;
            //    }

                //public functions
                void setProxy (QString,int);
                void connectToHost (QString);
                bool isBusy ();

        public slots:
                void readResponse ();
		void requestStarted (int);
                void requestsDone ();
	
        private slots:
                void setRequestTimeout ();

        signals:
                // response: statusCode, error, error-msg
                void getResponseStatus (int,bool,QString);
                void getResponseContent (bool,QString*);
                void getRawData (bool,QByteArray);
                void isFree();
        private:
                QNetworkAccessManager *http;
                QNetworkDiskCache *cache;
                QNetworkReply *reply;
                int timeout;
                QTimer *timer;
                bool busy;
                QByteArray response;

};

#endif
