#include <QObject>
#include <QXmlStreamReader>
#include <QList>
#include <QPixmap>

#include "HttpConnector.h"
#include "MaemoApplication.h"
#include "MaemoApplicationDetails.h"
#include "queueelement.h"

class MaemoApplicationHandler : public QObject {
    Q_OBJECT

    public:
            //constructors
            MaemoApplicationHandler ();
            //public functions

            //requests a list of all available applications
            void requestApplications (QString OS,
                                      QString cat,
                                      int page,
                                      int pageSize,
                                      QString keyword,
                                      QString sortmode="");
            //requests details of an application
            void requestApplicationData (QString uid);
            //request an image by a url
            void requestImage (QString url, QString id="", QString info="", bool addToQueue=true);
            //request an install file
            void requestInstallFile (QString url);
            void parseCommentsOnly (QString *);


    private:
            QString queryBuilder ( QString OS,QString cat,int page,int pageSize,QString keyword,QString sortmode);
            QString formalizeQString (QString);
    private slots:
            // private slots to proceed the requests
            void parseAppListResponse (bool,QString*);
            void parseSingleAppResponse (bool,QString*);
            void proceedImageResponse (bool, QByteArray);
            void proceedQueue ();

    public slots:
            void proceedInstallFileResponse (bool, QString*);
    signals:
            //signals returning the responses of the requests
            // application list
            void applicationListReady (QList<MaemoApplication *>*);
            //application details
            void applicationDetailsReady(MaemoApplicationDetails*);
            //image
            void imageReady(QPixmap*,QString, QString);
            //commments
            void commentsParsed (QList <MaemoComment*> *);
            void raiseError (QString*);

    private:
            QXmlStreamReader xmlReader;
            HttpConnector *connector;
            QList <QueueElement*> *imageQueue;
            QString mode;
            QueueElement *imageInUse;
            bool queueConnected;
};
