#!/bin/sh -e
# /usr/lib/emacsen-common/packages/remove/libqca2-plugin-ossl

FLAVOR=$1
PACKAGE=libqca2-plugin-ossl

if [ ${FLAVOR} != emacs ]; then
    if test -x /usr/sbin/install-info-altdir; then
        echo remove/${PACKAGE}: removing Info links for ${FLAVOR}
        install-info-altdir --quiet --remove --dirname=${FLAVOR} /usr/info/libqca2-plugin-ossl.info.gz
    fi

    echo remove/${PACKAGE}: purging byte-compiled files for ${FLAVOR}
    rm -rf /usr/share/${FLAVOR}/site-lisp/${PACKAGE}
fi
