/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2008 LUT. .
 *
 * @name MaemoWLANCreator.h
 * @memo Implementation of CMaemoWLANCreator interface (MaemoWLANCreator.h)
 *
 * @version 0.03
 * date     12.10.2008
 * change   7.1.2009
 */

#include <string>
#include "ListenerFactory.h"
#include "MaemoWLANCreator.h"
#include "MaemoWLANListener.h"

/**
 * @memo Constructor, registers automatically to ListenerFactory
 * @doc Default constructor for creator, is called when plugin is loaded
 * (and static instance of this class is initialized), registers itself to 
 * ListenerFactory. Prototype name for creating CMaemoWLANListeners
 * is set to be "wlan" (hardcode).
 */
CMaemoWLANCreator::CMaemoWLANCreator()
{
	iProto = std::string("wlan");
	DBG("CMaemoWLANCreator::Constructor: %s", iProto.c_str());
	ListenerFactory::GetInstance()->Register(this);
}

/**
 * @memo Creator function, creates CMaemoWLANListener -objects
 * @doc Creates CMaemoWLANListener -objects if the given prototype name is correct, passes
 * the given reference to owner object (that calls this function) to actual Listener (if it is created)
 * that will use the same reference to access owner object (via interface).
 * 
 * @param aName prototype name, will create with "wlan"
 * @param aConverter The component that will own the created object (needed for registeration)
 * 
 * @return MAbstractListener reference to created object or NULL if prototype does not match
 */
MAbstractListener* CMaemoWLANCreator::CreateListener(const std::string& aName,MAbstractStateConverter* aConverter)
{
	if(iProto.compare(aName) == 0)
	{
		return new CMaemoWLANListener(aConverter);
	}
	else return NULL;
}

static CMaemoWLANCreator maemowlancreator;
