/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2003 LUT. .
 *
 * @name GPRSCreator.h
 * @memo GPRS-specific implementation of the MAbstractCreator interface.
 *
 * @version 0.1
 * date     21.08.2003
 * change   14.11.2003
 */

#ifndef __GPRSCREATOR_H__
#define __GPRSCREATOR_H__

#include <AbstractCreator.h>

/**
 * @memo GPRS-specific implementation of the MAbstractCreator interface.
 * This class is used by the PeerHood factory to create connection objects that
 * implement the MAbstractConnection interface. 
 * @doc GPRS-specific implementation of the MAbstractCreator interface. 
 * This class is used by the PeerHood factory to create connection objects that
 * implement the MAbstractConnection interface. The idea is to provide a 
 * transparent way to create objects with specific properties. This makes the
 * whole PeerHood system quite flexible; new transport medium can be added 
 * without any modifications to the source code itself.
 *
 * @see MAbstractCreator
 * @see MAbstractConnection
 * @see TCPConnection
 * @see Factory
 */
class CGPRSCreator : public MAbstractCreator
{
 public:
  CGPRSCreator();
  MAbstractConnection* CreateConnectionL(const std::string& aProto);
  MAbstractPinger* CreatePingerL(const std::string& aProto, const std::string& aAddress);
  MAbstractMonitor* CreateMonitorL(const std::string& aProto, const std::string& aAddress);
  const std::string& GetPrototype();

 private:
  std::string iProto;
};

#endif // __GPRSCREATOR_H__
