/** This file is part of PeerHood.
*
*   PeerHood is free software: you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License 
*   version 2 as published by the Free Software Foundation.
*
*   PeerHood is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public
*   License along with PeerHood. If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Copyright 2008 LUT. .
 *
 * @name MaemoSystemCreator.cc
 * @memo Implementation of the MaemoSystemCreator.
 *
 * @version 0.11
 * date     25.08.2008
 * change   24.09.2008
 */

#include <string>
#include "ListenerFactory.h"
#include "MaemoSystemCreator.h"
#include "MaemoSystemListener.h"

/** 
 * @memo Constructor, sets prototype name and registers with factory
 * @doc Called when instance of this object is created (static)
 */
CMaemoSystemCreator::CMaemoSystemCreator()
{
	iProto = std::string("daemon");
	ListenerFactory::GetInstance()->Register(this);
}

/**
 * @memo Creates new Maemo System listener object
 * @doc Creates new listener if the given prototype name is the same as the 
 * name set to this creator.
 * 
 * @param aName The name of the prototype
 * 
 * @return MAbstractListener A reference to created object if it has been created,
 * otherwise NULL.
 */
MAbstractListener* CMaemoSystemCreator::CreateListener(const std::string& aName, MAbstractStateConverter* aConverter)
{
	if(iProto.compare(aName) == 0)
	{
		return new CMaemoSystemListener(aConverter);
	}
	else return NULL;
}

// Static reference to self
static CMaemoSystemCreator maemodbuscreator;
